/*
 * Decompiled with CFR 0.152.
 */
package org.tron.program;

import ch.qos.logback.classic.Level;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.tron.common.application.Application;
import org.tron.common.application.ApplicationFactory;
import org.tron.common.application.TronApplicationContext;
import org.tron.common.overlay.client.DatabaseGrpcClient;
import org.tron.common.overlay.discover.DiscoverServer;
import org.tron.common.overlay.discover.node.NodeManager;
import org.tron.common.overlay.server.ChannelManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.TransactionInfoCapsule;
import org.tron.core.config.DefaultConfig;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;
import org.tron.core.services.RpcApiService;
import org.tron.core.services.http.solidity.SolidityNodeHttpApiService;
import org.tron.program.FullNode;
import org.tron.protos.Protocol;

public class SolidityNode {
    private static final Logger logger = LoggerFactory.getLogger(SolidityNode.class);
    private Manager dbManager;
    private Args cfgArgs;
    private DatabaseGrpcClient databaseGrpcClient;
    private AtomicLong ID = new AtomicLong();
    private Map<Long, Protocol.Block> blockMap = Maps.newConcurrentMap();
    private LinkedBlockingDeque<Protocol.Block> blockQueue = new LinkedBlockingDeque(10000);
    private LinkedBlockingDeque<Protocol.Block> blockBakQueue = new LinkedBlockingDeque(10000);
    private volatile long remoteLastSolidityBlockNum = 0L;
    private volatile long lastSolidityBlockNum;
    private long startTime = System.currentTimeMillis();
    private volatile boolean syncFlag = true;
    private volatile boolean flag = true;

    public SolidityNode(Manager dbManager, Args cfgArgs) {
        this.dbManager = dbManager;
        this.cfgArgs = cfgArgs;
        this.lastSolidityBlockNum = dbManager.getDynamicPropertiesStore().getLatestSolidifiedBlockNum();
        this.ID.set(this.lastSolidityBlockNum);
        this.databaseGrpcClient = new DatabaseGrpcClient(cfgArgs.getTrustNodeAddr());
        this.remoteLastSolidityBlockNum = this.getLastSolidityBlockNum();
    }

    private void start() {
        try {
            for (int i = 0; i < 50; ++i) {
                new Thread(() -> this.getSyncBlock()).start();
            }
            new Thread(() -> this.getAdvBlock()).start();
            new Thread(() -> this.pushBlock()).start();
            new Thread(() -> this.processBlock()).start();
            new Thread(() -> this.processTrx()).start();
            logger.info("Success to start solid node, lastSolidityBlockNum: {}, ID: {}, remoteLastSolidityBlockNum: {}.", new Object[]{this.lastSolidityBlockNum, this.ID.get(), this.remoteLastSolidityBlockNum});
        }
        catch (Exception e) {
            logger.error("Failed to start solid node, address: {}.", (Object)this.cfgArgs.getTrustNodeAddr());
            System.exit(0);
        }
    }

    private void getSyncBlock() {
        long blockNum = this.getNextSyncBlockId();
        while (this.syncFlag) {
            try {
                if (blockNum == 0L) break;
                if (this.blockMap.size() > 10000) {
                    this.sleep(1000L);
                    continue;
                }
                Protocol.Block block = this.getBlockByNum(blockNum);
                this.blockMap.put(blockNum, block);
                logger.info("Success to get sync block: {}.", (Object)blockNum);
                blockNum = this.getNextSyncBlockId();
            }
            catch (Exception e) {
                logger.error("Failed to get sync block {}.", (Object)blockNum);
                this.sleep(1000L);
            }
        }
        logger.warn("Get sync block thread {} exit.", (Object)Thread.currentThread().getName());
    }

    synchronized long getNextSyncBlockId() {
        if (!this.syncFlag) {
            return 0L;
        }
        if (this.ID.get() < this.remoteLastSolidityBlockNum) {
            return this.ID.incrementAndGet();
        }
        long lastNum = this.getLastSolidityBlockNum();
        if (lastNum - this.remoteLastSolidityBlockNum > 50L) {
            this.remoteLastSolidityBlockNum = lastNum;
            return this.ID.incrementAndGet();
        }
        logger.warn("Sync mode switch to adv, ID = {}, lastNum = {}, remoteLastSolidityBlockNum = {}", new Object[]{this.ID.get(), lastNum, this.remoteLastSolidityBlockNum});
        this.syncFlag = false;
        return 0L;
    }

    private void getAdvBlock() {
        while (this.syncFlag) {
            this.sleep(5000L);
        }
        logger.warn("Get adv block thread start.");
        long blockNum = this.ID.incrementAndGet();
        while (this.flag) {
            try {
                if (blockNum > this.remoteLastSolidityBlockNum) {
                    this.sleep(3000L);
                    this.remoteLastSolidityBlockNum = this.getLastSolidityBlockNum();
                    continue;
                }
                Protocol.Block block = this.getBlockByNum(blockNum);
                this.blockMap.put(blockNum, block);
                logger.info("Success to get adv block: {}.", (Object)blockNum);
                blockNum = this.ID.incrementAndGet();
            }
            catch (Exception e) {
                logger.error("Failed to get adv block {}.", (Object)blockNum);
                this.sleep(1000L);
            }
        }
    }

    private Protocol.Block getBlockByNum(long blockNum) throws Exception {
        Protocol.Block block = this.databaseGrpcClient.getBlock(blockNum);
        if (block.getBlockHeader().getRawData().getNumber() != blockNum) {
            logger.warn("Get adv block id not the same , {}, {}.", (Object)blockNum, (Object)block.getBlockHeader().getRawData().getNumber());
            throw new Exception();
        }
        return block;
    }

    private long getLastSolidityBlockNum() {
        while (true) {
            try {
                long blockNum = this.databaseGrpcClient.getDynamicProperties().getLastSolidityBlockNum();
                logger.info("Get last remote solid blockNum: {}.", (Object)this.remoteLastSolidityBlockNum);
                return blockNum;
            }
            catch (Exception e) {
                logger.error("Failed to get last solid blockNum: {}.", (Object)this.remoteLastSolidityBlockNum);
                this.sleep(1000L);
                continue;
            }
            break;
        }
    }

    private void pushBlock() {
        while (this.flag) {
            try {
                Protocol.Block block = this.blockMap.remove(this.lastSolidityBlockNum + 1L);
                if (block == null) {
                    this.sleep(1000L);
                    continue;
                }
                this.blockQueue.put(block);
                ++this.lastSolidityBlockNum;
            }
            catch (Exception exception) {}
        }
    }

    private void processBlock() {
        while (this.flag) {
            try {
                Protocol.Block block = this.blockQueue.take();
                this.loopProcessBlock(block);
                this.blockBakQueue.put(block);
                logger.info("Success to process block: {}, blockMapSize: {}, blockQueueSize: {}, blockBakQueue: {}, cost {}.", new Object[]{block.getBlockHeader().getRawData().getNumber(), this.blockMap.size(), this.blockQueue.size(), this.blockBakQueue.size(), System.currentTimeMillis() - this.startTime});
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                this.sleep(100L);
            }
        }
    }

    private void resolveCompatibilityIssueIfUsingFullNodeDatabase() {
        long lastSolidityBlockNum = this.dbManager.getDynamicPropertiesStore().getLatestSolidifiedBlockNum();
        long headBlockNum = this.dbManager.getHeadBlockNum();
        logger.info("headBlockNum:{}, solidityBlockNum:{}, diff:{}", new Object[]{headBlockNum, lastSolidityBlockNum, headBlockNum - lastSolidityBlockNum});
        if (lastSolidityBlockNum < headBlockNum) {
            logger.info("use fullnode database, headBlockNum:{}, solidityBlockNum:{}, diff:{}", new Object[]{headBlockNum, lastSolidityBlockNum, headBlockNum - lastSolidityBlockNum});
            this.dbManager.getDynamicPropertiesStore().saveLatestSolidifiedBlockNum(headBlockNum);
        }
    }

    private void loopProcessBlock(Protocol.Block block) {
        while (true) {
            long blockNum = block.getBlockHeader().getRawData().getNumber();
            try {
                this.dbManager.pushVerifiedBlock(new BlockCapsule(block));
                this.dbManager.getDynamicPropertiesStore().saveLatestSolidifiedBlockNum(blockNum);
                return;
            }
            catch (Exception e) {
                logger.error("Failed to process block {}.", (Object)blockNum);
                try {
                    this.sleep(100L);
                    block = this.databaseGrpcClient.getBlock(blockNum);
                    continue;
                }
                catch (Exception e1) {
                    logger.error(e1.getMessage());
                    continue;
                }
            }
            break;
        }
    }

    private void processTrx() {
        while (this.flag) {
            try {
                Protocol.Block block = this.blockBakQueue.take();
                BlockCapsule blockCapsule = new BlockCapsule(block);
                for (TransactionCapsule trx : blockCapsule.getTransactions()) {
                    TransactionInfoCapsule ret;
                    try {
                        ret = this.dbManager.getTransactionHistoryStore().get(trx.getTransactionId().getBytes());
                    }
                    catch (Exception ex) {
                        logger.warn("Failed to get trx: {}", (Object)trx.getTransactionId(), (Object)ex);
                        continue;
                    }
                    ret.setBlockNumber(blockCapsule.getNum());
                    ret.setBlockTimeStamp(blockCapsule.getTimeStamp());
                    this.dbManager.getTransactionHistoryStore().put(trx.getTransactionId().getBytes(), ret);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                this.sleep(100L);
            }
        }
    }

    public void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws InterruptedException {
        logger.info("Solidity node running.");
        Args.setParam(args, "config.conf");
        Args cfgArgs = Args.getInstance();
        logger.info("index switch is {}", (Object)BooleanUtils.toStringOnOff((boolean)BooleanUtils.toBoolean((String)cfgArgs.getStorage().getIndexSwitch())));
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(Level.toLevel((String)cfgArgs.getLogLevel()));
        if (StringUtils.isEmpty((Object)cfgArgs.getTrustNodeAddr())) {
            logger.error("Trust node not set.");
            return;
        }
        cfgArgs.setSolidityNode(true);
        TronApplicationContext context = new TronApplicationContext(DefaultConfig.class);
        if (cfgArgs.isHelp()) {
            logger.info("Here is the help message.");
            return;
        }
        Application appT = ApplicationFactory.create((ApplicationContext)context);
        FullNode.shutdown(appT);
        RpcApiService rpcApiService = (RpcApiService)context.getBean(RpcApiService.class);
        appT.addService(rpcApiService);
        SolidityNodeHttpApiService httpApiService = (SolidityNodeHttpApiService)context.getBean(SolidityNodeHttpApiService.class);
        appT.addService(httpApiService);
        appT.initServices(cfgArgs);
        appT.startServices();
        DiscoverServer discoverServer = (DiscoverServer)context.getBean(DiscoverServer.class);
        discoverServer.close();
        ChannelManager channelManager = (ChannelManager)context.getBean(ChannelManager.class);
        channelManager.close();
        NodeManager nodeManager = (NodeManager)context.getBean(NodeManager.class);
        nodeManager.close();
        SolidityNode node = new SolidityNode(appT.getDbManager(), cfgArgs);
        node.resolveCompatibilityIssueIfUsingFullNodeDatabase();
        node.start();
        rpcApiService.blockUntilShutdown();
    }
}

