/*
 * Decompiled with CFR 0.152.
 */
package org.tron.program;

import ch.qos.logback.classic.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.tron.common.application.Application;
import org.tron.common.application.ApplicationFactory;
import org.tron.common.application.TronApplicationContext;
import org.tron.core.config.DefaultConfig;
import org.tron.core.config.args.Args;
import org.tron.core.services.RpcApiService;
import org.tron.core.services.WitnessService;
import org.tron.core.services.http.FullNodeHttpApiService;

public class FullNode {
    private static final Logger logger = LoggerFactory.getLogger(FullNode.class);

    public static void main(String[] args) throws InterruptedException {
        logger.info("Full node running.");
        Args.setParam(args, "config.conf");
        Args cfgArgs = Args.getInstance();
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(Level.toLevel((String)cfgArgs.getLogLevel()));
        if (cfgArgs.isHelp()) {
            logger.info("Here is the help message.");
            return;
        }
        if (Args.getInstance().isDebug()) {
            logger.info("in debug mode, it won't check energy time");
        } else {
            logger.info("not in debug mode, it will check energy time");
        }
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        beanFactory.setAllowCircularReferences(false);
        TronApplicationContext context = new TronApplicationContext(beanFactory);
        context.register(new Class[]{DefaultConfig.class});
        context.refresh();
        Application appT = ApplicationFactory.create((ApplicationContext)context);
        FullNode.shutdown(appT);
        RpcApiService rpcApiService = (RpcApiService)context.getBean(RpcApiService.class);
        appT.addService(rpcApiService);
        if (cfgArgs.isWitness()) {
            appT.addService(new WitnessService(appT, context));
        }
        FullNodeHttpApiService httpApiService = (FullNodeHttpApiService)context.getBean(FullNodeHttpApiService.class);
        appT.addService(httpApiService);
        appT.initServices(cfgArgs);
        appT.startServices();
        appT.startup();
        rpcApiService.blockUntilShutdown();
    }

    public static void shutdown(Application app) {
        logger.info("********register application shutdown hook********");
        Runtime.getRuntime().addShutdownHook(new Thread(app::shutdown));
    }
}

