/*
 * Decompiled with CFR 0.152.
 */
package org.tron.keystore;

import org.tron.common.crypto.ECKey;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;

public class Credentials {
    private final ECKey ecKeyPair;
    private final String address;

    private Credentials(ECKey ecKeyPair, String address) {
        this.ecKeyPair = ecKeyPair;
        this.address = address;
    }

    public ECKey getEcKeyPair() {
        return this.ecKeyPair;
    }

    public String getAddress() {
        return this.address;
    }

    public static Credentials create(ECKey ecKeyPair) {
        String address = Wallet.encode58Check(ecKeyPair.getAddress());
        return new Credentials(ecKeyPair, address);
    }

    public static Credentials create(String privateKey) {
        ECKey eCkey = ECKey.fromPrivate(ByteArray.fromHexString(privateKey));
        return Credentials.create(eCkey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credentials that = (Credentials)o;
        if (this.ecKeyPair != null ? !this.ecKeyPair.equals(that.ecKeyPair) : that.ecKeyPair != null) {
            return false;
        }
        return this.address != null ? this.address.equals(that.address) : that.address == null;
    }

    public int hashCode() {
        int result = this.ecKeyPair != null ? this.ecKeyPair.hashCode() : 0;
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        return result;
    }
}

