/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.witness;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.StringUtil;
import org.tron.common.utils.Time;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.AccountStore;
import org.tron.core.db.Manager;
import org.tron.core.db.VotesStore;
import org.tron.core.db.WitnessStore;
import org.tron.core.exception.HeaderNotFound;

public class WitnessController {
    private static final Logger logger = LoggerFactory.getLogger(WitnessController.class);
    private Manager manager;
    private AtomicBoolean generatingBlock = new AtomicBoolean(false);

    public static WitnessController createInstance(Manager manager) {
        WitnessController instance = new WitnessController();
        instance.setManager(manager);
        return instance;
    }

    public void initWits() {
        ArrayList<ByteString> witnessAddresses = new ArrayList<ByteString>();
        this.manager.getWitnessStore().getAllWitnesses().forEach(witnessCapsule -> {
            if (witnessCapsule.getIsJobs()) {
                witnessAddresses.add(witnessCapsule.getAddress());
            }
        });
        this.sortWitness(witnessAddresses);
        this.setActiveWitnesses(witnessAddresses);
        witnessAddresses.forEach(address -> logger.info("initWits shuffled addresses:" + ByteArray.toHexString(address.toByteArray())));
        this.setCurrentShuffledWitnesses(witnessAddresses);
    }

    public WitnessCapsule getWitnesseByAddress(ByteString address) {
        return this.manager.getWitnessStore().get(address.toByteArray());
    }

    public List<ByteString> getActiveWitnesses() {
        return this.manager.getWitnessScheduleStore().getActiveWitnesses();
    }

    public void setActiveWitnesses(List<ByteString> addresses) {
        this.manager.getWitnessScheduleStore().saveActiveWitnesses(addresses);
    }

    public void addWitness(ByteString address) {
        List<ByteString> l = this.getActiveWitnesses();
        l.add(address);
        this.setActiveWitnesses(l);
    }

    public List<ByteString> getCurrentShuffledWitnesses() {
        return this.manager.getWitnessScheduleStore().getCurrentShuffledWitnesses();
    }

    public void setCurrentShuffledWitnesses(List<ByteString> addresses) {
        this.manager.getWitnessScheduleStore().saveCurrentShuffledWitnesses(addresses);
    }

    public long getSlotAtTime(long when) {
        long firstSlotTime = this.getSlotTime(1L);
        if (when < firstSlotTime) {
            return 0L;
        }
        logger.debug("nextFirstSlotTime:[{}],when[{}]", (Object)new DateTime(firstSlotTime), (Object)new DateTime(when));
        return (when - firstSlotTime) / 3000L + 1L;
    }

    public BlockCapsule getGenesisBlock() {
        return this.manager.getGenesisBlock();
    }

    public BlockCapsule getHead() throws HeaderNotFound {
        return this.manager.getHead();
    }

    public boolean lastHeadBlockIsMaintenance() {
        return this.manager.lastHeadBlockIsMaintenance();
    }

    public long getAbSlotAtTime(long when) {
        return (when - this.getGenesisBlock().getTimeStamp()) / 3000L;
    }

    public long getSlotTime(long slotNum) {
        if (slotNum == 0L) {
            return Time.getCurrentMillis();
        }
        long interval = 3000L;
        if (this.manager.getDynamicPropertiesStore().getLatestBlockHeaderNumber() == 0L) {
            return this.getGenesisBlock().getTimeStamp() + slotNum * interval;
        }
        if (this.lastHeadBlockIsMaintenance()) {
            slotNum += this.manager.getSkipSlotInMaintenance();
        }
        long headSlotTime = this.manager.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
        headSlotTime -= (headSlotTime - this.getGenesisBlock().getTimeStamp()) % interval;
        return headSlotTime + interval * slotNum;
    }

    public boolean validateWitnessSchedule(BlockCapsule block) {
        ByteString witnessAddress = block.getInstance().getBlockHeader().getRawData().getWitnessAddress();
        long timeStamp = block.getTimeStamp();
        return this.validateWitnessSchedule(witnessAddress, timeStamp);
    }

    public boolean validateWitnessSchedule(ByteString witnessAddress, long timeStamp) {
        long headBlockAbSlot;
        if (this.manager.getDynamicPropertiesStore().getLatestBlockHeaderNumber() == 0L) {
            return true;
        }
        long blockAbSlot = this.getAbSlotAtTime(timeStamp);
        if (blockAbSlot <= (headBlockAbSlot = this.getAbSlotAtTime(this.manager.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp()))) {
            logger.warn("blockAbSlot is equals with headBlockAbSlot[" + blockAbSlot + "]");
            return false;
        }
        long slot = this.getSlotAtTime(timeStamp);
        ByteString scheduledWitness = this.getScheduledWitness(slot);
        if (!scheduledWitness.equals((Object)witnessAddress)) {
            logger.warn("Witness is out of order, scheduledWitness[{}],blockWitnessAddress[{}],blockTimeStamp[{}],slot[{}]", new Object[]{ByteArray.toHexString(scheduledWitness.toByteArray()), ByteArray.toHexString(witnessAddress.toByteArray()), new DateTime(timeStamp), slot});
            return false;
        }
        logger.debug("Validate witnessSchedule successfully,scheduledWitness:{}", (Object)ByteArray.toHexString(witnessAddress.toByteArray()));
        return true;
    }

    public boolean activeWitnessesContain(Set<ByteString> localWitnesses) {
        List<ByteString> activeWitnesses = this.getActiveWitnesses();
        for (ByteString witnessAddress : localWitnesses) {
            if (!activeWitnesses.contains(witnessAddress)) continue;
            return true;
        }
        return false;
    }

    public ByteString getScheduledWitness(long slot) {
        long currentSlot = this.getHeadSlot() + slot;
        if (currentSlot < 0L) {
            throw new RuntimeException("currentSlot should be positive.");
        }
        int numberActiveWitness = this.getActiveWitnesses().size();
        int singleRepeat = 1;
        if (numberActiveWitness <= 0) {
            throw new RuntimeException("Active Witnesses is null.");
        }
        int witnessIndex = (int)currentSlot % (numberActiveWitness * singleRepeat);
        logger.debug("currentSlot:" + currentSlot + ", witnessIndex" + (witnessIndex /= singleRepeat) + ", currentActiveWitnesses size:" + numberActiveWitness);
        ByteString scheduledWitness = this.getActiveWitnesses().get(witnessIndex);
        logger.info("scheduledWitness:" + ByteArray.toHexString(scheduledWitness.toByteArray()) + ", currentSlot:" + currentSlot);
        return scheduledWitness;
    }

    public long getHeadSlot() {
        return (this.manager.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp() - this.getGenesisBlock().getTimeStamp()) / 3000L;
    }

    public void updateWitnessSchedule() {
    }

    private Map<ByteString, Long> countVote(VotesStore votesStore) {
        HashMap countWitness = Maps.newHashMap();
        Iterator dbIterator = votesStore.iterator();
        long sizeCount = 0L;
        while (dbIterator.hasNext()) {
            Map.Entry next = dbIterator.next();
            VotesCapsule votes = (VotesCapsule)next.getValue();
            votes.getOldVotes().forEach(vote -> {
                ByteString voteAddress = vote.getVoteAddress();
                long voteCount = vote.getVoteCount();
                if (countWitness.containsKey(voteAddress)) {
                    countWitness.put(voteAddress, (Long)countWitness.get(voteAddress) - voteCount);
                } else {
                    countWitness.put(voteAddress, -voteCount);
                }
            });
            votes.getNewVotes().forEach(vote -> {
                ByteString voteAddress = vote.getVoteAddress();
                long voteCount = vote.getVoteCount();
                if (countWitness.containsKey(voteAddress)) {
                    countWitness.put(voteAddress, (Long)countWitness.get(voteAddress) + voteCount);
                } else {
                    countWitness.put(voteAddress, voteCount);
                }
            });
            ++sizeCount;
            votesStore.delete(next.getKey());
        }
        logger.info("there is {} new votes in this epoch", (Object)sizeCount);
        return countWitness;
    }

    public void updateWitness() {
        WitnessStore witnessStore = this.manager.getWitnessStore();
        VotesStore votesStore = this.manager.getVotesStore();
        AccountStore accountStore = this.manager.getAccountStore();
        this.tryRemoveThePowerOfTheGr();
        Map<ByteString, Long> countWitness = this.countVote(votesStore);
        if (countWitness.isEmpty()) {
            logger.info("No vote, no change to witness.");
        } else {
            List<ByteString> currentWits = this.getActiveWitnesses();
            ArrayList<ByteString> newWitnessAddressList = new ArrayList<ByteString>();
            witnessStore.getAllWitnesses().forEach(witnessCapsule -> newWitnessAddressList.add(witnessCapsule.getAddress()));
            countWitness.forEach((address, voteCount) -> {
                WitnessCapsule witnessCapsule = witnessStore.get(StringUtil.createDbKey(address));
                if (null == witnessCapsule) {
                    logger.warn("witnessCapsule is null.address is {}", (Object)StringUtil.createReadableString(address));
                    return;
                }
                AccountCapsule witnessAccountCapsule = accountStore.get(StringUtil.createDbKey(address));
                if (witnessAccountCapsule == null) {
                    logger.warn("witnessAccount[" + StringUtil.createReadableString(address) + "] not exists");
                } else {
                    witnessCapsule.setVoteCount(witnessCapsule.getVoteCount() + voteCount);
                    witnessStore.put(witnessCapsule.createDbKey(), witnessCapsule);
                    logger.info("address is {}  ,countVote is {}", (Object)witnessCapsule.createReadableString(), (Object)witnessCapsule.getVoteCount());
                }
            });
            this.sortWitness(newWitnessAddressList);
            if (newWitnessAddressList.size() > 27) {
                this.setActiveWitnesses(newWitnessAddressList.subList(0, 27));
            } else {
                this.setActiveWitnesses(newWitnessAddressList);
            }
            if (newWitnessAddressList.size() > 127) {
                this.payStandbyWitness(newWitnessAddressList.subList(0, 127));
            } else {
                this.payStandbyWitness(newWitnessAddressList);
            }
            List<ByteString> newWits = this.getActiveWitnesses();
            if (WitnessController.witnessSetChanged(currentWits, newWits)) {
                currentWits.forEach(address -> {
                    WitnessCapsule witnessCapsule = this.getWitnesseByAddress((ByteString)address);
                    witnessCapsule.setIsJobs(false);
                    witnessStore.put(witnessCapsule.createDbKey(), witnessCapsule);
                });
                newWits.forEach(address -> {
                    WitnessCapsule witnessCapsule = this.getWitnesseByAddress((ByteString)address);
                    witnessCapsule.setIsJobs(true);
                    witnessStore.put(witnessCapsule.createDbKey(), witnessCapsule);
                });
            }
            logger.info("updateWitness,before:{} ", (Object)(StringUtil.getAddressStringList(currentWits) + ",\nafter:{} " + StringUtil.getAddressStringList(newWits)));
        }
    }

    public void tryRemoveThePowerOfTheGr() {
        if (this.manager.getDynamicPropertiesStore().getRemoveThePowerOfTheGr() == 1L) {
            WitnessStore witnessStore = this.manager.getWitnessStore();
            Args.getInstance().getGenesisBlock().getWitnesses().forEach(witnessInGenesisBlock -> {
                WitnessCapsule witnessCapsule = witnessStore.get(witnessInGenesisBlock.getAddress());
                witnessCapsule.setVoteCount(witnessCapsule.getVoteCount() - witnessInGenesisBlock.getVoteCount());
                witnessStore.put(witnessCapsule.createDbKey(), witnessCapsule);
            });
            this.manager.getDynamicPropertiesStore().saveRemoveThePowerOfTheGr(-1L);
        }
    }

    private static boolean witnessSetChanged(List<ByteString> list1, List<ByteString> list2) {
        return !CollectionUtils.isEqualCollection(list1, list2);
    }

    public int calculateParticipationRate() {
        return this.manager.getDynamicPropertiesStore().calculateFilledSlotsCount();
    }

    public void dumpParticipationLog() {
        StringBuilder builder = new StringBuilder();
        int[] blockFilledSlots = this.manager.getDynamicPropertiesStore().getBlockFilledSlots();
        builder.append("dump participation log \n ").append("blockFilledSlots:").append(Arrays.toString(blockFilledSlots)).append(",");
        long headSlot = this.getHeadSlot();
        builder.append("\n").append(" headSlot:").append(headSlot).append(",");
        List<ByteString> activeWitnesses = this.getActiveWitnesses();
        activeWitnesses.forEach(a -> {
            WitnessCapsule witnessCapsule = this.manager.getWitnessStore().get(a.toByteArray());
            builder.append("\n").append(" witness:").append(witnessCapsule.createReadableString()).append(",").append("latestBlockNum:").append(witnessCapsule.getLatestBlockNum()).append(",").append("LatestSlotNum:").append(witnessCapsule.getLatestSlotNum()).append(".");
        });
        logger.debug(builder.toString());
    }

    private void sortWitness(List<ByteString> list) {
        list.sort(Comparator.comparingLong(b -> this.getWitnesseByAddress((ByteString)b).getVoteCount()).reversed().thenComparing(Comparator.comparingInt(ByteString::hashCode).reversed()));
    }

    private void payStandbyWitness(List<ByteString> list) {
        long voteSum = 0L;
        long totalPay = this.manager.getDynamicPropertiesStore().getWitnessStandbyAllowance();
        for (ByteString b : list) {
            voteSum += this.getWitnesseByAddress(b).getVoteCount();
        }
        if (voteSum > 0L) {
            for (ByteString b : list) {
                long pay = (long)((double)this.getWitnesseByAddress(b).getVoteCount() * ((double)totalPay / (double)voteSum));
                AccountCapsule accountCapsule = this.manager.getAccountStore().get(b.toByteArray());
                accountCapsule.setAllowance(accountCapsule.getAllowance() + pay);
                this.manager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
            }
        }
    }

    public boolean isGeneratingBlock() {
        return this.generatingBlock.get();
    }

    public void setGeneratingBlock(boolean generatingBlock) {
        this.generatingBlock.set(generatingBlock);
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public Manager getManager() {
        return this.manager;
    }
}

