/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.interfaceOnSolidity.http.solidity;

import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tron.common.application.Service;
import org.tron.core.config.args.Args;
import org.tron.core.services.interfaceOnSolidity.http.GetAccountOnSolidityServlet;
import org.tron.core.services.interfaceOnSolidity.http.GetAssetIssueListOnSolidityServlet;
import org.tron.core.services.interfaceOnSolidity.http.GetBlockByNumOnSolidityServlet;
import org.tron.core.services.interfaceOnSolidity.http.GetNodeInfoOnSolidityServlet;
import org.tron.core.services.interfaceOnSolidity.http.GetNowBlockOnSolidityServlet;
import org.tron.core.services.interfaceOnSolidity.http.GetPaginatedAssetIssueListOnSolidityServlet;
import org.tron.core.services.interfaceOnSolidity.http.ListWitnessesOnSolidityServlet;
import org.tron.core.services.interfaceOnSolidity.http.solidity.GetTransactionByIdOnSolidityServlet;
import org.tron.core.services.interfaceOnSolidity.http.solidity.GetTransactionInfoByIdOnSolidityServlet;

public class HttpApiOnSolidityService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(HttpApiOnSolidityService.class);
    private int port = Args.getInstance().getSolidityHttpPort();
    private Server server;
    @Autowired
    private GetAccountOnSolidityServlet accountOnSolidityServlet;
    @Autowired
    private GetTransactionByIdOnSolidityServlet getTransactionByIdOnSolidityServlet;
    @Autowired
    private GetTransactionInfoByIdOnSolidityServlet getTransactionInfoByIdOnSolidityServlet;
    @Autowired
    private ListWitnessesOnSolidityServlet listWitnessesOnSolidityServlet;
    @Autowired
    private GetAssetIssueListOnSolidityServlet getAssetIssueListOnSolidityServlet;
    @Autowired
    private GetPaginatedAssetIssueListOnSolidityServlet getPaginatedAssetIssueListOnSolidityServlet;
    @Autowired
    private GetNowBlockOnSolidityServlet getNowBlockOnSolidityServlet;
    @Autowired
    private GetBlockByNumOnSolidityServlet getBlockByNumOnSolidityServlet;
    @Autowired
    private GetNodeInfoOnSolidityServlet getNodeInfoOnSolidityServlet;

    @Override
    public void init() {
    }

    @Override
    public void init(Args args) {
    }

    @Override
    public void start() {
        Args args = Args.getInstance();
        try {
            this.server = new Server(this.port);
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            this.server.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)this.accountOnSolidityServlet), "/walletsolidity/getaccount");
            context.addServlet(new ServletHolder((Servlet)this.listWitnessesOnSolidityServlet), "/walletsolidity/listwitnesses");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueListOnSolidityServlet), "/walletsolidity/getassetissuelist");
            context.addServlet(new ServletHolder((Servlet)this.getPaginatedAssetIssueListOnSolidityServlet), "/walletsolidity/getpaginatedassetissuelist");
            context.addServlet(new ServletHolder((Servlet)this.getNowBlockOnSolidityServlet), "/walletsolidity/getnowblock");
            context.addServlet(new ServletHolder((Servlet)this.getBlockByNumOnSolidityServlet), "/walletsolidity/getblockbynum");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionByIdOnSolidityServlet), "/walletsolidity/gettransactionbyid");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionInfoByIdOnSolidityServlet), "/walletsolidity/gettransactioninfobyid");
            context.addServlet(new ServletHolder((Servlet)this.getNodeInfoOnSolidityServlet), "/wallet/getnodeinfo");
            this.server.start();
        }
        catch (Exception e) {
            logger.debug("IOException: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
        }
    }
}

