/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.interfaceOnSolidity.http;

import com.google.protobuf.Message;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;
import org.tron.core.services.interfaceOnSolidity.WalletOnSolidity;

@Component
public class GetAssetIssueListOnSolidityServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(GetAssetIssueListOnSolidityServlet.class);
    @Autowired
    private WalletOnSolidity walletOnSolidity;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            GrpcAPI.AssetIssueList reply = this.walletOnSolidity.getAssetIssueList();
            if (reply != null) {
                response.getWriter().println(JsonFormat.printToString((Message)reply));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }
}

