/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http.solidity;

import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.application.Service;
import org.tron.core.config.args.Args;
import org.tron.core.services.http.GetAccountServlet;
import org.tron.core.services.http.GetAssetIssueByIdServlet;
import org.tron.core.services.http.GetAssetIssueByNameServlet;
import org.tron.core.services.http.GetAssetIssueListByNameServlet;
import org.tron.core.services.http.GetAssetIssueListServlet;
import org.tron.core.services.http.GetBlockByNumServlet;
import org.tron.core.services.http.GetDelegatedResourceAccountIndexServlet;
import org.tron.core.services.http.GetDelegatedResourceServlet;
import org.tron.core.services.http.GetExchangeByIdServlet;
import org.tron.core.services.http.GetNodeInfoServlet;
import org.tron.core.services.http.GetNowBlockServlet;
import org.tron.core.services.http.GetPaginatedAssetIssueListServlet;
import org.tron.core.services.http.GetTransactionCountByBlockNumServlet;
import org.tron.core.services.http.ListExchangesServlet;
import org.tron.core.services.http.ListWitnessesServlet;
import org.tron.core.services.http.solidity.GetTransactionByIdSolidityServlet;
import org.tron.core.services.http.solidity.GetTransactionInfoByIdSolidityServlet;
import org.tron.core.services.http.solidity.GetTransactionsFromThisServlet;
import org.tron.core.services.http.solidity.GetTransactionsToThisServlet;

@Component
public class SolidityNodeHttpApiService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(SolidityNodeHttpApiService.class);
    private int port = Args.getInstance().getSolidityHttpPort();
    private Server server;
    @Autowired
    private GetAccountServlet accountServlet;
    @Autowired
    private GetTransactionByIdSolidityServlet getTransactionByIdServlet;
    @Autowired
    private GetTransactionInfoByIdSolidityServlet getTransactionInfoByIdServlet;
    @Autowired
    private GetTransactionsFromThisServlet getTransactionsFromThisServlet;
    @Autowired
    private GetTransactionsToThisServlet getTransactionsToThisServlet;
    @Autowired
    private GetTransactionCountByBlockNumServlet getTransactionCountByBlockNumServlet;
    @Autowired
    private GetDelegatedResourceServlet getDelegatedResourceServlet;
    @Autowired
    private GetDelegatedResourceAccountIndexServlet getDelegatedResourceAccountIndexServlet;
    @Autowired
    private GetExchangeByIdServlet getExchangeByIdServlet;
    @Autowired
    private ListExchangesServlet listExchangesServlet;
    @Autowired
    private ListWitnessesServlet listWitnessesServlet;
    @Autowired
    private GetAssetIssueListServlet getAssetIssueListServlet;
    @Autowired
    private GetPaginatedAssetIssueListServlet getPaginatedAssetIssueListServlet;
    @Autowired
    private GetAssetIssueByNameServlet getAssetIssueByNameServlet;
    @Autowired
    private GetAssetIssueByIdServlet getAssetIssueByIdServlet;
    @Autowired
    private GetAssetIssueListByNameServlet getAssetIssueListByNameServlet;
    @Autowired
    private GetNowBlockServlet getNowBlockServlet;
    @Autowired
    private GetBlockByNumServlet getBlockByNumServlet;
    @Autowired
    private GetNodeInfoServlet getNodeInfoServlet;

    @Override
    public void init() {
    }

    @Override
    public void init(Args args) {
    }

    @Override
    public void start() {
        Args args = Args.getInstance();
        try {
            this.server = new Server(this.port);
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            this.server.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)this.accountServlet), "/walletsolidity/getaccount");
            context.addServlet(new ServletHolder((Servlet)this.listWitnessesServlet), "/walletsolidity/listwitnesses");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueListServlet), "/walletsolidity/getassetissuelist");
            context.addServlet(new ServletHolder((Servlet)this.getPaginatedAssetIssueListServlet), "/walletsolidity/getpaginatedassetissuelist");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueByNameServlet), "/walletsolidity/getassetissuebyname");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueByIdServlet), "/walletsolidity/getassetissuebyid");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueListByNameServlet), "/walletsolidity/getassetissuelistbyname");
            context.addServlet(new ServletHolder((Servlet)this.getNowBlockServlet), "/walletsolidity/getnowblock");
            context.addServlet(new ServletHolder((Servlet)this.getBlockByNumServlet), "/walletsolidity/getblockbynum");
            context.addServlet(new ServletHolder((Servlet)this.getDelegatedResourceServlet), "/walletsolidity/getdelegatedresource");
            context.addServlet(new ServletHolder((Servlet)this.getDelegatedResourceAccountIndexServlet), "/walletsolidity/getdelegatedresourceaccountindex");
            context.addServlet(new ServletHolder((Servlet)this.getExchangeByIdServlet), "/walletsolidity/getexchangebyid");
            context.addServlet(new ServletHolder((Servlet)this.listExchangesServlet), "/walletsolidity/listexchanges");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionByIdServlet), "/walletsolidity/gettransactionbyid");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionInfoByIdServlet), "/walletsolidity/gettransactioninfobyid");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionCountByBlockNumServlet), "/walletsolidity/gettransactioncountbyblocknum");
            if (args.isWalletExtensionApi()) {
                context.addServlet(new ServletHolder((Servlet)this.getTransactionsFromThisServlet), "/walletextension/gettransactionsfromthis");
                context.addServlet(new ServletHolder((Servlet)this.getTransactionsToThisServlet), "/walletextension/gettransactionstothis");
            }
            context.addServlet(new ServletHolder((Servlet)this.getNodeInfoServlet), "/wallet/getnodeinfo");
            this.server.start();
        }
        catch (Exception e) {
            logger.debug("IOException: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
        }
    }
}

