/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class GetAssetIssueByAccountServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(GetAssetIssueByAccountServlet.class);
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String address = request.getParameter("address");
            GrpcAPI.AssetIssueList reply = this.wallet.getAssetIssueByAccount(ByteString.copyFrom((byte[])ByteArray.fromHexString(address)));
            if (reply != null) {
                response.getWriter().println(JsonFormat.printToString((Message)reply));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String account = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            Protocol.Account.Builder build = Protocol.Account.newBuilder();
            JsonFormat.merge(account, (Message.Builder)build);
            GrpcAPI.AssetIssueList reply = this.wallet.getAssetIssueByAccount(build.getAddress());
            if (reply != null) {
                response.getWriter().println(JsonFormat.printToString((Message)reply));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }
}

