/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.crypto.ECKey;
import org.tron.core.Wallet;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

@Component
public class EasyTransferServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(EasyTransferServlet.class);
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        GrpcAPI.Return.Builder returnBuilder = GrpcAPI.Return.newBuilder();
        GrpcAPI.EasyTransferResponse.Builder responseBuild = GrpcAPI.EasyTransferResponse.newBuilder();
        try {
            String input = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            GrpcAPI.EasyTransferMessage.Builder build = GrpcAPI.EasyTransferMessage.newBuilder();
            JsonFormat.merge(input, (Message.Builder)build);
            byte[] privateKey = this.wallet.pass2Key(build.getPassPhrase().toByteArray());
            ECKey ecKey = ECKey.fromPrivate(privateKey);
            byte[] owner = ecKey.getAddress();
            Contract.TransferContract.Builder builder = Contract.TransferContract.newBuilder();
            builder.setOwnerAddress(ByteString.copyFrom((byte[])owner));
            builder.setToAddress(build.getToAddress());
            builder.setAmount(build.getAmount());
            TransactionCapsule transactionCapsule = this.wallet.createTransactionCapsule((Message)builder.build(), Protocol.Transaction.Contract.ContractType.TransferContract);
            transactionCapsule.sign(privateKey);
            GrpcAPI.Return retur = this.wallet.broadcastTransaction(transactionCapsule.getInstance());
            responseBuild.setTransaction(transactionCapsule.getInstance());
            responseBuild.setResult(retur);
            response.getWriter().println(Util.printEasyTransferResponse(responseBuild.build()));
        }
        catch (JsonFormat.ParseException e) {
            logger.debug("ParseException: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            logger.debug("IOException: {}", (Object)e.getMessage());
        }
        catch (ContractValidateException e) {
            returnBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)e.getMessage()));
            responseBuild.setResult(returnBuilder.build());
            try {
                response.getWriter().println(JsonFormat.printToString((Message)responseBuild.build()));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
            return;
        }
    }
}

