/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.application.Application;
import org.tron.common.application.Service;
import org.tron.common.application.TronApplicationContext;
import org.tron.common.backup.BackupManager;
import org.tron.common.backup.BackupServer;
import org.tron.common.crypto.ECKey;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.UnLinkedBlockException;
import org.tron.core.exception.ValidateScheduleException;
import org.tron.core.exception.ValidateSignatureException;
import org.tron.core.net.message.BlockMessage;
import org.tron.core.witness.BlockProductionCondition;
import org.tron.core.witness.WitnessController;

public class WitnessService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(WitnessService.class);
    private static final int MIN_PARTICIPATION_RATE = Args.getInstance().getMinParticipationRate();
    private static final int PRODUCE_TIME_OUT = 500;
    private Application tronApp;
    protected Map<ByteString, WitnessCapsule> localWitnessStateMap = Maps.newHashMap();
    private Thread generateThread;
    private volatile boolean isRunning = false;
    private Map<ByteString, byte[]> privateKeyMap = Maps.newHashMap();
    private volatile boolean needSyncCheck = Args.getInstance().isNeedSyncCheck();
    private Manager manager;
    private WitnessController controller;
    private TronApplicationContext context;
    private BackupManager backupManager;
    private BackupServer backupServer;
    private AtomicInteger dupBlockCount = new AtomicInteger(0);
    private AtomicLong dupBlockTime = new AtomicLong(0L);
    private long blockCycle = 81000L;
    private Runnable scheduleProductionLoop = () -> {
        if (this.localWitnessStateMap == null || this.localWitnessStateMap.keySet().isEmpty()) {
            logger.error("LocalWitnesses is null");
            return;
        }
        while (this.isRunning) {
            try {
                if (this.needSyncCheck) {
                    Thread.sleep(500L);
                } else {
                    DateTime time = DateTime.now();
                    long timeToNextSecond = 3000 - (time.getSecondOfMinute() * 1000 + time.getMillisOfSecond()) % 3000;
                    if (timeToNextSecond < 50L) {
                        timeToNextSecond += 3000L;
                    }
                    DateTime nextTime = time.plus(timeToNextSecond);
                    logger.debug("ProductionLoop sleep : " + timeToNextSecond + " ms,next time:" + nextTime);
                    Thread.sleep(timeToNextSecond);
                }
                this.blockProductionLoop();
            }
            catch (InterruptedException ex) {
                logger.info("ProductionLoop interrupted");
            }
            catch (Exception ex) {
                logger.error("unknown exception happened in witness loop", (Throwable)ex);
            }
            catch (Throwable throwable) {
                logger.error("unknown throwable happened in witness loop", throwable);
            }
        }
    };

    public WitnessService(Application tronApp, TronApplicationContext context) {
        this.tronApp = tronApp;
        this.context = context;
        this.backupManager = (BackupManager)context.getBean(BackupManager.class);
        this.backupServer = (BackupServer)context.getBean(BackupServer.class);
        this.generateThread = new Thread(this.scheduleProductionLoop);
        this.manager = tronApp.getDbManager();
        this.manager.setWitnessService(this);
        this.controller = this.manager.getWitnessController();
        new Thread(() -> {
            while (this.needSyncCheck) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            this.backupServer.initServer();
        }).start();
    }

    private void blockProductionLoop() throws InterruptedException {
        BlockProductionCondition result = this.tryProduceBlock();
        if (result == null) {
            logger.warn("Result is null");
            return;
        }
        if (result.ordinal() <= BlockProductionCondition.NOT_MY_TURN.ordinal()) {
            logger.debug(result.toString());
        } else {
            logger.info(result.toString());
        }
    }

    /*
     * Exception decompiling
     */
    private BlockProductionCondition tryProduceBlock() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void broadcastBlock(BlockCapsule block) {
        try {
            this.tronApp.getP2pNode().broadcast(new BlockMessage(block.getData()));
        }
        catch (Exception ex) {
            throw new RuntimeException("BroadcastBlock error");
        }
    }

    private BlockCapsule generateBlock(long when, ByteString witnessAddress, Boolean lastHeadBlockIsMaintenance) throws ValidateSignatureException, ContractValidateException, ContractExeException, UnLinkedBlockException, ValidateScheduleException, AccountResourceInsufficientException {
        return this.tronApp.getDbManager().generateBlock(this.localWitnessStateMap.get(witnessAddress), when, this.privateKeyMap.get(witnessAddress), lastHeadBlockIsMaintenance);
    }

    private boolean dupWitnessCheck() {
        if (this.dupBlockCount.get() == 0) {
            return false;
        }
        if (System.currentTimeMillis() - this.dupBlockTime.get() > (long)this.dupBlockCount.get() * this.blockCycle) {
            this.dupBlockCount.set(0);
            return false;
        }
        return true;
    }

    public void processBlock(BlockCapsule block) {
        if (block.generatedByMyself) {
            return;
        }
        if (System.currentTimeMillis() - block.getTimeStamp() > 3000L) {
            return;
        }
        if (!this.privateKeyMap.containsKey(block.getWitnessAddress())) {
            return;
        }
        if (this.dupBlockCount.get() == 0) {
            this.dupBlockCount.set(new Random().nextInt(10));
        } else {
            this.dupBlockCount.set(10);
        }
        this.dupBlockTime.set(System.currentTimeMillis());
    }

    @Override
    public void init() {
        Args.getInstance().getLocalWitnesses().getPrivateKeys().forEach(key -> {
            byte[] privateKey = ByteArray.fromHexString(key);
            ECKey ecKey = ECKey.fromPrivate(privateKey);
            byte[] address = ecKey.getAddress();
            WitnessCapsule witnessCapsule = this.tronApp.getDbManager().getWitnessStore().get(address);
            if (null == witnessCapsule) {
                logger.warn("WitnessCapsule[" + address + "] is not in witnessStore");
                witnessCapsule = new WitnessCapsule(ByteString.copyFrom((byte[])address));
            }
            this.privateKeyMap.put(witnessCapsule.getAddress(), privateKey);
            this.localWitnessStateMap.put(witnessCapsule.getAddress(), witnessCapsule);
        });
    }

    @Override
    public void init(Args args) {
        this.init();
    }

    @Override
    public void start() {
        this.isRunning = true;
        this.generateThread.start();
    }

    @Override
    public void stop() {
        this.isRunning = false;
        this.generateThread.interrupt();
    }

    public Map<ByteString, WitnessCapsule> getLocalWitnessStateMap() {
        return this.localWitnessStateMap;
    }
}

