/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.DatabaseGrpc;
import org.tron.api.GrpcAPI;
import org.tron.api.WalletExtensionGrpc;
import org.tron.api.WalletGrpc;
import org.tron.api.WalletSolidityGrpc;
import org.tron.common.application.Service;
import org.tron.common.crypto.ECKey;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.overlay.discover.node.NodeHandler;
import org.tron.common.overlay.discover.node.NodeManager;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StringUtil;
import org.tron.common.utils.Utils;
import org.tron.core.Wallet;
import org.tron.core.WalletSolidity;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.BandwidthProcessor;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.NonUniqueObjectException;
import org.tron.core.exception.StoreException;
import org.tron.core.exception.VMIllegalException;
import org.tron.core.services.NodeInfoService;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

@Component
public class RpcApiService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(RpcApiService.class);
    private int port = Args.getInstance().getRpcPort();
    private Server apiServer;
    @Autowired
    private Manager dbManager;
    @Autowired
    private NodeManager nodeManager;
    @Autowired
    private WalletSolidity walletSolidity;
    @Autowired
    private Wallet wallet;
    @Autowired
    private NodeInfoService nodeInfoService;
    private static final long BLOCK_LIMIT_NUM = 100L;
    private static final long TRANSACTION_LIMIT_NUM = 1000L;

    @Override
    public void init() {
    }

    @Override
    public void init(Args args) {
    }

    @Override
    public void start() {
        try {
            NettyServerBuilder serverBuilder = (NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).addService((BindableService)new DatabaseApi());
            Args args = Args.getInstance();
            if (args.getRpcThreadNum() > 0) {
                serverBuilder = (NettyServerBuilder)serverBuilder.executor((Executor)Executors.newFixedThreadPool(args.getRpcThreadNum()));
            }
            if (args.isSolidityNode()) {
                serverBuilder = (NettyServerBuilder)serverBuilder.addService((BindableService)new WalletSolidityApi());
                if (args.isWalletExtensionApi()) {
                    serverBuilder = (NettyServerBuilder)serverBuilder.addService((BindableService)new WalletExtensionApi());
                }
            } else {
                serverBuilder = (NettyServerBuilder)serverBuilder.addService((BindableService)new WalletApi());
            }
            serverBuilder.maxConcurrentCallsPerConnection(args.getMaxConcurrentCallsPerConnection()).flowControlWindow(args.getFlowControlWindow()).maxConnectionIdle(args.getMaxConnectionIdleInMillis(), TimeUnit.MILLISECONDS).maxConnectionAge(args.getMaxConnectionAgeInMillis(), TimeUnit.MILLISECONDS).maxMessageSize(args.getMaxMessageSize()).maxHeaderListSize(args.getMaxHeaderListSize());
            this.apiServer = serverBuilder.build().start();
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        logger.info("RpcApiService started, listening on " + this.port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("*** shutting down gRPC server since JVM is shutting down");
            System.err.println("*** server shut down");
        }));
    }

    private GrpcAPI.TransactionExtention transaction2Extention(Protocol.Transaction transaction) {
        if (transaction == null) {
            return null;
        }
        GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        trxExtBuilder.setTransaction(transaction);
        trxExtBuilder.setTxid(Sha256Hash.of(transaction.getRawData().toByteArray()).getByteString());
        retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
        trxExtBuilder.setResult(retBuilder);
        return trxExtBuilder.build();
    }

    private GrpcAPI.BlockExtention block2Extention(Protocol.Block block) {
        if (block == null) {
            return null;
        }
        GrpcAPI.BlockExtention.Builder builder = GrpcAPI.BlockExtention.newBuilder();
        BlockCapsule blockCapsule = new BlockCapsule(block);
        builder.setBlockHeader(block.getBlockHeader());
        builder.setBlockid(ByteString.copyFrom((byte[])blockCapsule.getBlockId().getBytes()));
        for (int i = 0; i < block.getTransactionsCount(); ++i) {
            Protocol.Transaction transaction = block.getTransactions(i);
            builder.addTransactions(this.transaction2Extention(transaction));
        }
        return builder.build();
    }

    @Override
    public void stop() {
        if (this.apiServer != null) {
            this.apiServer.shutdown();
        }
    }

    public void blockUntilShutdown() {
        if (this.apiServer != null) {
            try {
                this.apiServer.awaitTermination();
            }
            catch (InterruptedException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private class WalletApi
    extends WalletGrpc.WalletImplBase {
        private WalletApi() {
        }

        private GrpcAPI.BlockListExtention blocklist2Extention(GrpcAPI.BlockList blockList) {
            if (blockList == null) {
                return null;
            }
            GrpcAPI.BlockListExtention.Builder builder = GrpcAPI.BlockListExtention.newBuilder();
            for (Protocol.Block block : blockList.getBlockList()) {
                builder.addBlock(RpcApiService.this.block2Extention(block));
            }
            return builder.build();
        }

        @Override
        public void getAccount(Protocol.Account req, StreamObserver<Protocol.Account> responseObserver) {
            ByteString addressBs = req.getAddress();
            if (addressBs != null) {
                Protocol.Account reply = RpcApiService.this.wallet.getAccount(req);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getAccountById(Protocol.Account req, StreamObserver<Protocol.Account> responseObserver) {
            ByteString accountId = req.getAccountId();
            if (accountId != null) {
                Protocol.Account reply = RpcApiService.this.wallet.getAccountById(req);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void createTransaction(Contract.TransferContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.TransferContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void createTransaction2(Contract.TransferContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.TransferContract, responseObserver);
        }

        private void createTransactionExtention(Message request, Protocol.Transaction.Contract.ContractType contractType, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
            GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
            try {
                TransactionCapsule trx = this.createTransactionCapsule(request, contractType);
                trxExtBuilder.setTransaction(trx.getInstance());
                trxExtBuilder.setTxid(trx.getTransactionId().getByteString());
                retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
            }
            catch (ContractValidateException e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)("contract validate error : " + e.getMessage())));
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            catch (Exception e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                logger.info("exception caught" + e.getMessage());
            }
            trxExtBuilder.setResult(retBuilder);
            responseObserver.onNext((Object)trxExtBuilder.build());
            responseObserver.onCompleted();
        }

        private TransactionCapsule createTransactionCapsule(Message message, Protocol.Transaction.Contract.ContractType contractType) throws ContractValidateException {
            return RpcApiService.this.wallet.createTransactionCapsule(message, contractType);
        }

        @Override
        public void getTransactionSign(Protocol.TransactionSign req, StreamObserver<Protocol.Transaction> responseObserver) {
            TransactionCapsule retur = RpcApiService.this.wallet.getTransactionSign(req);
            responseObserver.onNext((Object)retur.getInstance());
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionSign2(Protocol.TransactionSign req, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
            GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
            try {
                TransactionCapsule trx = RpcApiService.this.wallet.getTransactionSign(req);
                trxExtBuilder.setTransaction(trx.getInstance());
                trxExtBuilder.setTxid(trx.getTransactionId().getByteString());
                retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
            }
            catch (Exception e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                logger.info("exception caught" + e.getMessage());
            }
            trxExtBuilder.setResult(retBuilder);
            responseObserver.onNext((Object)trxExtBuilder.build());
            responseObserver.onCompleted();
        }

        @Override
        public void createAddress(GrpcAPI.BytesMessage req, StreamObserver<GrpcAPI.BytesMessage> responseObserver) {
            byte[] address = RpcApiService.this.wallet.createAdresss(req.getValue().toByteArray());
            GrpcAPI.BytesMessage.Builder builder = GrpcAPI.BytesMessage.newBuilder();
            builder.setValue(ByteString.copyFrom((byte[])address));
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }

        private GrpcAPI.EasyTransferResponse easyTransfer(byte[] privateKey, ByteString toAddress, long amount) {
            GrpcAPI.Return.Builder returnBuilder = GrpcAPI.Return.newBuilder();
            GrpcAPI.EasyTransferResponse.Builder responseBuild = GrpcAPI.EasyTransferResponse.newBuilder();
            try {
                ECKey ecKey = ECKey.fromPrivate(privateKey);
                byte[] owner = ecKey.getAddress();
                Contract.TransferContract.Builder builder = Contract.TransferContract.newBuilder();
                builder.setOwnerAddress(ByteString.copyFrom((byte[])owner));
                builder.setToAddress(toAddress);
                builder.setAmount(amount);
                TransactionCapsule transactionCapsule = this.createTransactionCapsule((Message)builder.build(), Protocol.Transaction.Contract.ContractType.TransferContract);
                transactionCapsule.sign(privateKey);
                GrpcAPI.Return retur = RpcApiService.this.wallet.broadcastTransaction(transactionCapsule.getInstance());
                responseBuild.setTransaction(transactionCapsule.getInstance());
                responseBuild.setTxid(transactionCapsule.getTransactionId().getByteString());
                responseBuild.setResult(retur);
            }
            catch (ContractValidateException e) {
                returnBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)e.getMessage()));
                responseBuild.setResult(returnBuilder.build());
            }
            catch (Exception e) {
                returnBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                responseBuild.setResult(returnBuilder.build());
            }
            return responseBuild.build();
        }

        @Override
        public void easyTransfer(GrpcAPI.EasyTransferMessage req, StreamObserver<GrpcAPI.EasyTransferResponse> responseObserver) {
            byte[] privateKey = RpcApiService.this.wallet.pass2Key(req.getPassPhrase().toByteArray());
            GrpcAPI.EasyTransferResponse response = this.easyTransfer(privateKey, req.getToAddress(), req.getAmount());
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }

        @Override
        public void easyTransferByPrivate(GrpcAPI.EasyTransferByPrivateMessage req, StreamObserver<GrpcAPI.EasyTransferResponse> responseObserver) {
            byte[] privateKey = req.getPrivateKey().toByteArray();
            GrpcAPI.EasyTransferResponse response = this.easyTransfer(privateKey, req.getToAddress(), req.getAmount());
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }

        @Override
        public void broadcastTransaction(Protocol.Transaction req, StreamObserver<GrpcAPI.Return> responseObserver) {
            GrpcAPI.Return retur = RpcApiService.this.wallet.broadcastTransaction(req);
            responseObserver.onNext((Object)retur);
            responseObserver.onCompleted();
        }

        @Override
        public void createAssetIssue(Contract.AssetIssueContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.AssetIssueContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void createAssetIssue2(Contract.AssetIssueContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.AssetIssueContract, responseObserver);
        }

        @Override
        public void unfreezeAsset(Contract.UnfreezeAssetContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.UnfreezeAssetContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void unfreezeAsset2(Contract.UnfreezeAssetContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UnfreezeAssetContract, responseObserver);
        }

        private void checkVoteWitnessAccount(Contract.VoteWitnessContract req) {
            ByteString ownerAddress = req.getOwnerAddress();
            Preconditions.checkNotNull((Object)ownerAddress, (Object)"OwnerAddress is null");
            AccountCapsule account = RpcApiService.this.dbManager.getAccountStore().get(ownerAddress.toByteArray());
            Preconditions.checkNotNull((Object)account, (Object)("OwnerAddress[" + StringUtil.createReadableString(ownerAddress) + "] not exists"));
            int votesCount = req.getVotesCount();
            Preconditions.checkArgument((votesCount <= 0 ? 1 : 0) != 0, (Object)("VotesCount[" + votesCount + "] <= 0"));
            Preconditions.checkArgument((account.getTronPower() < (long)votesCount ? 1 : 0) != 0, (Object)("tron power[" + account.getTronPower() + "] <  VotesCount[" + votesCount + "]"));
            req.getVotesList().forEach(vote -> {
                ByteString voteAddress = vote.getVoteAddress();
                WitnessCapsule witness = RpcApiService.this.dbManager.getWitnessStore().get(voteAddress.toByteArray());
                String readableWitnessAddress = StringUtil.createReadableString(voteAddress);
                Preconditions.checkNotNull((Object)witness, (Object)("witness[" + readableWitnessAddress + "] not exists"));
                Preconditions.checkArgument((vote.getVoteCount() <= 0L ? 1 : 0) != 0, (Object)("VoteAddress[" + readableWitnessAddress + "],VotesCount[" + vote.getVoteCount() + "] <= 0"));
            });
        }

        @Override
        public void voteWitnessAccount(Contract.VoteWitnessContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.VoteWitnessContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void voteWitnessAccount2(Contract.VoteWitnessContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.VoteWitnessContract, responseObserver);
        }

        @Override
        public void updateSetting(Contract.UpdateSettingContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UpdateSettingContract, responseObserver);
        }

        @Override
        public void updateEnergyLimit(Contract.UpdateEnergyLimitContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UpdateEnergyLimitContract, responseObserver);
        }

        @Override
        public void createWitness(Contract.WitnessCreateContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.WitnessCreateContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void createWitness2(Contract.WitnessCreateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.WitnessCreateContract, responseObserver);
        }

        @Override
        public void createAccount(Contract.AccountCreateContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.AccountCreateContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void createAccount2(Contract.AccountCreateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.AccountCreateContract, responseObserver);
        }

        @Override
        public void updateWitness(Contract.WitnessUpdateContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.WitnessUpdateContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void updateWitness2(Contract.WitnessUpdateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.WitnessUpdateContract, responseObserver);
        }

        @Override
        public void updateAccount(Contract.AccountUpdateContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.AccountUpdateContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void setAccountId(Contract.SetAccountIdContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.SetAccountIdContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void updateAccount2(Contract.AccountUpdateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.AccountUpdateContract, responseObserver);
        }

        @Override
        public void updateAsset(Contract.UpdateAssetContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.UpdateAssetContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void updateAsset2(Contract.UpdateAssetContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UpdateAssetContract, responseObserver);
        }

        @Override
        public void freezeBalance(Contract.FreezeBalanceContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.FreezeBalanceContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void freezeBalance2(Contract.FreezeBalanceContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.FreezeBalanceContract, responseObserver);
        }

        @Override
        public void unfreezeBalance(Contract.UnfreezeBalanceContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.UnfreezeBalanceContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void unfreezeBalance2(Contract.UnfreezeBalanceContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UnfreezeBalanceContract, responseObserver);
        }

        @Override
        public void withdrawBalance(Contract.WithdrawBalanceContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.WithdrawBalanceContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void withdrawBalance2(Contract.WithdrawBalanceContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.WithdrawBalanceContract, responseObserver);
        }

        @Override
        public void proposalCreate(Contract.ProposalCreateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ProposalCreateContract, responseObserver);
        }

        @Override
        public void proposalApprove(Contract.ProposalApproveContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ProposalApproveContract, responseObserver);
        }

        @Override
        public void proposalDelete(Contract.ProposalDeleteContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ProposalDeleteContract, responseObserver);
        }

        @Override
        public void exchangeCreate(Contract.ExchangeCreateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ExchangeCreateContract, responseObserver);
        }

        @Override
        public void exchangeInject(Contract.ExchangeInjectContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ExchangeInjectContract, responseObserver);
        }

        @Override
        public void exchangeWithdraw(Contract.ExchangeWithdrawContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ExchangeWithdrawContract, responseObserver);
        }

        @Override
        public void exchangeTransaction(Contract.ExchangeTransactionContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ExchangeTransactionContract, responseObserver);
        }

        @Override
        public void getNowBlock(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.Block> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getNowBlock());
            responseObserver.onCompleted();
        }

        @Override
        public void getNowBlock2(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            Protocol.Block block = RpcApiService.this.wallet.getNowBlock();
            responseObserver.onNext((Object)RpcApiService.this.block2Extention(block));
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockByNum(GrpcAPI.NumberMessage request, StreamObserver<Protocol.Block> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getBlockByNum(request.getNum()));
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockByNum2(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            Protocol.Block block = RpcApiService.this.wallet.getBlockByNum(request.getNum());
            responseObserver.onNext((Object)RpcApiService.this.block2Extention(block));
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionCountByBlockNum(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder();
            try {
                Protocol.Block block = RpcApiService.this.dbManager.getBlockByNum(request.getNum()).getInstance();
                builder.setNum(block.getTransactionsCount());
            }
            catch (StoreException e) {
                logger.error(e.getMessage());
                builder.setNum(-1L);
            }
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }

        @Override
        public void listNodes(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NodeList> responseObserver) {
            List<NodeHandler> handlerList = RpcApiService.this.nodeManager.dumpActiveNodes();
            HashMap<String, NodeHandler> nodeHandlerMap = new HashMap<String, NodeHandler>();
            for (NodeHandler handler : handlerList) {
                String key = handler.getNode().getHexId() + handler.getNode().getHost();
                nodeHandlerMap.put(key, handler);
            }
            GrpcAPI.NodeList.Builder nodeListBuilder = GrpcAPI.NodeList.newBuilder();
            nodeHandlerMap.entrySet().stream().forEach(v -> {
                Node node = ((NodeHandler)v.getValue()).getNode();
                nodeListBuilder.addNodes(GrpcAPI.Node.newBuilder().setAddress(GrpcAPI.Address.newBuilder().setHost(ByteString.copyFrom((byte[])ByteArray.fromString(node.getHost()))).setPort(node.getPort())));
            });
            responseObserver.onNext((Object)nodeListBuilder.build());
            responseObserver.onCompleted();
        }

        @Override
        public void transferAsset(Contract.TransferAssetContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.TransferAssetContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void transferAsset2(Contract.TransferAssetContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.TransferAssetContract, responseObserver);
        }

        @Override
        public void participateAssetIssue(Contract.ParticipateAssetIssueContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.ParticipateAssetIssueContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        @Override
        public void participateAssetIssue2(Contract.ParticipateAssetIssueContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ParticipateAssetIssueContract, responseObserver);
        }

        @Override
        public void getAssetIssueByAccount(Protocol.Account request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            ByteString fromBs = request.getAddress();
            if (fromBs != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueByAccount(fromBs));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getAccountNet(Protocol.Account request, StreamObserver<GrpcAPI.AccountNetMessage> responseObserver) {
            ByteString fromBs = request.getAddress();
            if (fromBs != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAccountNet(fromBs));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getAccountResource(Protocol.Account request, StreamObserver<GrpcAPI.AccountResourceMessage> responseObserver) {
            ByteString fromBs = request.getAddress();
            if (fromBs != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAccountResource(fromBs));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getAssetIssueByName(GrpcAPI.BytesMessage request, StreamObserver<Contract.AssetIssueContract> responseObserver) {
            ByteString assetName = request.getValue();
            if (assetName != null) {
                try {
                    responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueByName(assetName));
                }
                catch (NonUniqueObjectException e) {
                    responseObserver.onNext(null);
                    logger.debug("FullNode NonUniqueObjectException: {}", (Object)e.getMessage());
                }
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getAssetIssueListByName(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            ByteString assetName = request.getValue();
            if (assetName != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueListByName(assetName));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getAssetIssueById(GrpcAPI.BytesMessage request, StreamObserver<Contract.AssetIssueContract> responseObserver) {
            ByteString assetId = request.getValue();
            if (assetId != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueById(assetId.toStringUtf8()));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Block> responseObserver) {
            ByteString blockId = request.getValue();
            if (Objects.nonNull(blockId)) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getBlockById(blockId));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getProposalById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Proposal> responseObserver) {
            ByteString proposalId = request.getValue();
            if (Objects.nonNull(proposalId)) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getProposalById(proposalId));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getExchangeById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Exchange> responseObserver) {
            ByteString exchangeId = request.getValue();
            if (Objects.nonNull(exchangeId)) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getExchangeById(exchangeId));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockByLimitNext(GrpcAPI.BlockLimit request, StreamObserver<GrpcAPI.BlockList> responseObserver) {
            long startNum = request.getStartNum();
            long endNum = request.getEndNum();
            if (endNum > 0L && endNum > startNum && endNum - startNum <= 100L) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getBlocksByLimitNext(startNum, endNum - startNum));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockByLimitNext2(GrpcAPI.BlockLimit request, StreamObserver<GrpcAPI.BlockListExtention> responseObserver) {
            long startNum = request.getStartNum();
            long endNum = request.getEndNum();
            if (endNum > 0L && endNum > startNum && endNum - startNum <= 100L) {
                responseObserver.onNext((Object)this.blocklist2Extention(RpcApiService.this.wallet.getBlocksByLimitNext(startNum, endNum - startNum)));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockByLatestNum(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.BlockList> responseObserver) {
            long getNum = request.getNum();
            if (getNum > 0L && getNum < 100L) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getBlockByLatestNum(getNum));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockByLatestNum2(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.BlockListExtention> responseObserver) {
            long getNum = request.getNum();
            if (getNum > 0L && getNum < 100L) {
                responseObserver.onNext((Object)this.blocklist2Extention(RpcApiService.this.wallet.getBlockByLatestNum(getNum)));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Transaction> responseObserver) {
            ByteString transactionId = request.getValue();
            if (Objects.nonNull(transactionId)) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getTransactionById(transactionId));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void deployContract(Contract.CreateSmartContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.CreateSmartContract, responseObserver);
        }

        @Override
        public void totalTransaction(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.totalTransaction());
            responseObserver.onCompleted();
        }

        @Override
        public void getNextMaintenanceTime(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getNextMaintenanceTime());
            responseObserver.onCompleted();
        }

        @Override
        public void getAssetIssueList(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueList());
            responseObserver.onCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void triggerContract(Contract.TriggerSmartContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
            GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
            try {
                TransactionCapsule trxCap = this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.TriggerSmartContract);
                Protocol.Transaction trx = RpcApiService.this.wallet.triggerContract(request, trxCap, trxExtBuilder, retBuilder);
                trxExtBuilder.setTransaction(trx);
                trxExtBuilder.setTxid(trxCap.getTransactionId().getByteString());
                retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
                trxExtBuilder.setResult(retBuilder);
            }
            catch (ContractValidateException | VMIllegalException e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)("contract validate error : " + e.getMessage())));
                trxExtBuilder.setResult(retBuilder);
                logger.warn("ContractValidateException: {}", (Object)e.getMessage());
            }
            catch (RuntimeException e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_EXE_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                trxExtBuilder.setResult(retBuilder);
                logger.warn("When run constant call in VM, have RuntimeException: " + e.getMessage());
            }
            catch (Exception e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                trxExtBuilder.setResult(retBuilder);
                logger.warn("unknown exception caught: " + e.getMessage(), (Throwable)e);
            }
            finally {
                responseObserver.onNext((Object)trxExtBuilder.build());
                responseObserver.onCompleted();
            }
        }

        @Override
        public void getPaginatedAssetIssueList(GrpcAPI.PaginatedMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueList(request.getOffset(), request.getLimit()));
            responseObserver.onCompleted();
        }

        @Override
        public void getContract(GrpcAPI.BytesMessage request, StreamObserver<Protocol.SmartContract> responseObserver) {
            Protocol.SmartContract contract = RpcApiService.this.wallet.getContract(request);
            responseObserver.onNext((Object)contract);
            responseObserver.onCompleted();
        }

        @Override
        public void listWitnesses(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.WitnessList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getWitnessList());
            responseObserver.onCompleted();
        }

        @Override
        public void listProposals(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.ProposalList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getProposalList());
            responseObserver.onCompleted();
        }

        @Override
        public void getDelegatedResource(GrpcAPI.DelegatedResourceMessage request, StreamObserver<GrpcAPI.DelegatedResourceList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getDelegatedResource(request.getFromAddress(), request.getToAddress()));
            responseObserver.onCompleted();
        }

        @Override
        public void getDelegatedResourceAccountIndex(GrpcAPI.BytesMessage request, StreamObserver<Protocol.DelegatedResourceAccountIndex> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getDelegatedResourceAccountIndex(request.getValue()));
            responseObserver.onCompleted();
        }

        @Override
        public void getPaginatedProposalList(GrpcAPI.PaginatedMessage request, StreamObserver<GrpcAPI.ProposalList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getPaginatedProposalList(request.getOffset(), request.getLimit()));
            responseObserver.onCompleted();
        }

        @Override
        public void getPaginatedExchangeList(GrpcAPI.PaginatedMessage request, StreamObserver<GrpcAPI.ExchangeList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getPaginatedExchangeList(request.getOffset(), request.getLimit()));
            responseObserver.onCompleted();
        }

        @Override
        public void listExchanges(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.ExchangeList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getExchangeList());
            responseObserver.onCompleted();
        }

        @Override
        public void getChainParameters(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.ChainParameters> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getChainParameters());
            responseObserver.onCompleted();
        }

        @Override
        public void generateAddress(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.AddressPrKeyPairMessage> responseObserver) {
            ECKey ecKey = new ECKey(Utils.getRandom());
            byte[] priKey = ecKey.getPrivKeyBytes();
            byte[] address = ecKey.getAddress();
            String addressStr = Wallet.encode58Check(address);
            String priKeyStr = Hex.encodeHexString((byte[])priKey);
            GrpcAPI.AddressPrKeyPairMessage.Builder builder = GrpcAPI.AddressPrKeyPairMessage.newBuilder();
            builder.setAddress(addressStr);
            builder.setPrivateKey(priKeyStr);
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionInfoById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.TransactionInfo> responseObserver) {
            ByteString id = request.getValue();
            if (null != id) {
                Protocol.TransactionInfo reply = RpcApiService.this.wallet.getTransactionInfoById(id);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getNodeInfo(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.NodeInfo> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.nodeInfoService.getNodeInfo().transferToProtoEntity());
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)e);
            }
            responseObserver.onCompleted();
        }
    }

    private class WalletExtensionApi
    extends WalletExtensionGrpc.WalletExtensionImplBase {
        private WalletExtensionApi() {
        }

        private GrpcAPI.TransactionListExtention transactionList2Extention(GrpcAPI.TransactionList transactionList) {
            if (transactionList == null) {
                return null;
            }
            GrpcAPI.TransactionListExtention.Builder builder = GrpcAPI.TransactionListExtention.newBuilder();
            for (Protocol.Transaction transaction : transactionList.getTransactionList()) {
                builder.addTransaction(RpcApiService.this.transaction2Extention(transaction));
            }
            return builder.build();
        }

        @Override
        public void getTransactionsFromThis(GrpcAPI.AccountPaginated request, StreamObserver<GrpcAPI.TransactionList> responseObserver) {
            ByteString thisAddress = request.getAccount().getAddress();
            long offset = request.getOffset();
            long limit = request.getLimit();
            if (null != thisAddress && offset >= 0L && limit >= 0L) {
                GrpcAPI.TransactionList reply = RpcApiService.this.walletSolidity.getTransactionsFromThis(thisAddress, offset, limit);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionsFromThis2(GrpcAPI.AccountPaginated request, StreamObserver<GrpcAPI.TransactionListExtention> responseObserver) {
            ByteString thisAddress = request.getAccount().getAddress();
            long offset = request.getOffset();
            long limit = request.getLimit();
            if (null != thisAddress && offset >= 0L && limit >= 0L) {
                GrpcAPI.TransactionList reply = RpcApiService.this.walletSolidity.getTransactionsFromThis(thisAddress, offset, limit);
                responseObserver.onNext((Object)this.transactionList2Extention(reply));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionsToThis(GrpcAPI.AccountPaginated request, StreamObserver<GrpcAPI.TransactionList> responseObserver) {
            ByteString toAddress = request.getAccount().getAddress();
            long offset = request.getOffset();
            long limit = request.getLimit();
            if (null != toAddress && offset >= 0L && limit >= 0L) {
                GrpcAPI.TransactionList reply = RpcApiService.this.walletSolidity.getTransactionsToThis(toAddress, offset, limit);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionsToThis2(GrpcAPI.AccountPaginated request, StreamObserver<GrpcAPI.TransactionListExtention> responseObserver) {
            ByteString toAddress = request.getAccount().getAddress();
            long offset = request.getOffset();
            long limit = request.getLimit();
            if (null != toAddress && offset >= 0L && limit >= 0L) {
                GrpcAPI.TransactionList reply = RpcApiService.this.walletSolidity.getTransactionsToThis(toAddress, offset, limit);
                responseObserver.onNext((Object)this.transactionList2Extention(reply));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }
    }

    private class WalletSolidityApi
    extends WalletSolidityGrpc.WalletSolidityImplBase {
        private WalletSolidityApi() {
        }

        @Override
        public void getAccount(Protocol.Account request, StreamObserver<Protocol.Account> responseObserver) {
            ByteString addressBs = request.getAddress();
            if (addressBs != null) {
                Protocol.Account reply = RpcApiService.this.wallet.getAccount(request);
                if (reply == null) {
                    responseObserver.onNext(null);
                } else {
                    AccountCapsule accountCapsule = new AccountCapsule(reply);
                    BandwidthProcessor processor = new BandwidthProcessor(RpcApiService.this.dbManager);
                    processor.updateUsage(accountCapsule);
                    responseObserver.onNext((Object)accountCapsule.getInstance());
                }
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getAccountById(Protocol.Account request, StreamObserver<Protocol.Account> responseObserver) {
            ByteString id = request.getAccountId();
            if (id != null) {
                Protocol.Account reply = RpcApiService.this.wallet.getAccountById(request);
                if (reply == null) {
                    responseObserver.onNext(null);
                } else {
                    AccountCapsule accountCapsule = new AccountCapsule(reply);
                    BandwidthProcessor processor = new BandwidthProcessor(RpcApiService.this.dbManager);
                    processor.updateUsage(accountCapsule);
                    responseObserver.onNext((Object)accountCapsule.getInstance());
                }
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void listWitnesses(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.WitnessList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getWitnessList());
            responseObserver.onCompleted();
        }

        @Override
        public void getAssetIssueList(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueList());
            responseObserver.onCompleted();
        }

        @Override
        public void getPaginatedAssetIssueList(GrpcAPI.PaginatedMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueList(request.getOffset(), request.getLimit()));
            responseObserver.onCompleted();
        }

        @Override
        public void getAssetIssueByName(GrpcAPI.BytesMessage request, StreamObserver<Contract.AssetIssueContract> responseObserver) {
            ByteString assetName = request.getValue();
            if (assetName != null) {
                try {
                    responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueByName(assetName));
                }
                catch (NonUniqueObjectException e) {
                    responseObserver.onNext(null);
                    logger.error("Solidity NonUniqueObjectException: {}", (Object)e.getMessage());
                }
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getAssetIssueListByName(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            ByteString assetName = request.getValue();
            if (assetName != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueListByName(assetName));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getAssetIssueById(GrpcAPI.BytesMessage request, StreamObserver<Contract.AssetIssueContract> responseObserver) {
            ByteString assetId = request.getValue();
            if (assetId != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueById(assetId.toStringUtf8()));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getNowBlock(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.Block> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getNowBlock());
            responseObserver.onCompleted();
        }

        @Override
        public void getNowBlock2(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.block2Extention(RpcApiService.this.wallet.getNowBlock()));
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockByNum(GrpcAPI.NumberMessage request, StreamObserver<Protocol.Block> responseObserver) {
            long num = request.getNum();
            if (num >= 0L) {
                Protocol.Block reply = RpcApiService.this.wallet.getBlockByNum(num);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockByNum2(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            long num = request.getNum();
            if (num >= 0L) {
                Protocol.Block reply = RpcApiService.this.wallet.getBlockByNum(num);
                responseObserver.onNext((Object)RpcApiService.this.block2Extention(reply));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getDelegatedResource(GrpcAPI.DelegatedResourceMessage request, StreamObserver<GrpcAPI.DelegatedResourceList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getDelegatedResource(request.getFromAddress(), request.getToAddress()));
            responseObserver.onCompleted();
        }

        @Override
        public void getDelegatedResourceAccountIndex(GrpcAPI.BytesMessage request, StreamObserver<Protocol.DelegatedResourceAccountIndex> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getDelegatedResourceAccountIndex(request.getValue()));
            responseObserver.onCompleted();
        }

        @Override
        public void getExchangeById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Exchange> responseObserver) {
            ByteString exchangeId = request.getValue();
            if (Objects.nonNull(exchangeId)) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getExchangeById(exchangeId));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void listExchanges(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.ExchangeList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getExchangeList());
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionCountByBlockNum(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder();
            try {
                Protocol.Block block = RpcApiService.this.dbManager.getBlockByNum(request.getNum()).getInstance();
                builder.setNum(block.getTransactionsCount());
            }
            catch (StoreException e) {
                logger.error(e.getMessage());
                builder.setNum(-1L);
            }
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Transaction> responseObserver) {
            ByteString id = request.getValue();
            if (null != id) {
                Protocol.Transaction reply = RpcApiService.this.wallet.getTransactionById(id);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionInfoById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.TransactionInfo> responseObserver) {
            ByteString id = request.getValue();
            if (null != id) {
                Protocol.TransactionInfo reply = RpcApiService.this.wallet.getTransactionInfoById(id);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void generateAddress(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.AddressPrKeyPairMessage> responseObserver) {
            ECKey ecKey = new ECKey(Utils.getRandom());
            byte[] priKey = ecKey.getPrivKeyBytes();
            byte[] address = ecKey.getAddress();
            String addressStr = Wallet.encode58Check(address);
            String priKeyStr = Hex.encodeHexString((byte[])priKey);
            GrpcAPI.AddressPrKeyPairMessage.Builder builder = GrpcAPI.AddressPrKeyPairMessage.newBuilder();
            builder.setAddress(addressStr);
            builder.setPrivateKey(priKeyStr);
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }
    }

    private class DatabaseApi
    extends DatabaseGrpc.DatabaseImplBase {
        private DatabaseApi() {
        }

        @Override
        public void getBlockReference(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BlockReference> responseObserver) {
            long headBlockNum = RpcApiService.this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
            byte[] blockHeaderHash = RpcApiService.this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderHash().getBytes();
            GrpcAPI.BlockReference ref = GrpcAPI.BlockReference.newBuilder().setBlockHash(ByteString.copyFrom((byte[])blockHeaderHash)).setBlockNum(headBlockNum).build();
            responseObserver.onNext((Object)ref);
            responseObserver.onCompleted();
        }

        @Override
        public void getNowBlock(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.Block> responseObserver) {
            Protocol.Block block = null;
            try {
                block = RpcApiService.this.dbManager.getHead().getInstance();
            }
            catch (StoreException e) {
                logger.error(e.getMessage());
            }
            responseObserver.onNext((Object)block);
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockByNum(GrpcAPI.NumberMessage request, StreamObserver<Protocol.Block> responseObserver) {
            Protocol.Block block = null;
            try {
                block = RpcApiService.this.dbManager.getBlockByNum(request.getNum()).getInstance();
            }
            catch (StoreException e) {
                logger.error(e.getMessage());
            }
            responseObserver.onNext((Object)block);
            responseObserver.onCompleted();
        }

        @Override
        public void getDynamicProperties(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.DynamicProperties> responseObserver) {
            Protocol.DynamicProperties.Builder builder = Protocol.DynamicProperties.newBuilder();
            builder.setLastSolidityBlockNum(RpcApiService.this.dbManager.getDynamicPropertiesStore().getLatestSolidifiedBlockNum());
            Protocol.DynamicProperties dynamicProperties = builder.build();
            responseObserver.onNext((Object)dynamicProperties);
            responseObserver.onCompleted();
        }
    }
}

