/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.entity.NodeInfo;
import org.tron.common.entity.PeerInfo;
import org.tron.common.overlay.discover.node.NodeManager;
import org.tron.common.overlay.server.SyncPool;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.services.WitnessProductBlockService;
import org.tron.program.Version;
import org.tron.protos.Protocol;

@Component
public class NodeInfoService {
    private MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private Args args = Args.getInstance();
    @Autowired
    private SyncPool syncPool;
    @Autowired
    private NodeManager nodeManager;
    @Autowired
    private Manager dbManager;
    @Autowired
    private WitnessProductBlockService witnessProductBlockService;

    public NodeInfo getNodeInfo() {
        NodeInfo nodeInfo = new NodeInfo();
        this.setConnectInfo(nodeInfo);
        this.setMachineInfo(nodeInfo);
        this.setConfigNodeInfo(nodeInfo);
        this.setBlockInfo(nodeInfo);
        this.setCheatWitnessInfo(nodeInfo);
        return nodeInfo;
    }

    private void setMachineInfo(NodeInfo nodeInfo) {
        NodeInfo.MachineInfo machineInfo = new NodeInfo.MachineInfo();
        machineInfo.setThreadCount(this.threadMXBean.getThreadCount());
        machineInfo.setCpuCount(Runtime.getRuntime().availableProcessors());
        machineInfo.setTotalMemory(this.operatingSystemMXBean.getTotalPhysicalMemorySize());
        machineInfo.setFreeMemory(this.operatingSystemMXBean.getFreePhysicalMemorySize());
        machineInfo.setCpuRate(this.operatingSystemMXBean.getSystemCpuLoad());
        machineInfo.setJavaVersion(this.runtimeMXBean.getSystemProperties().get("java.version"));
        machineInfo.setOsName(this.operatingSystemMXBean.getName() + " " + this.operatingSystemMXBean.getVersion());
        machineInfo.setJvmTotalMemoery(this.memoryMXBean.getHeapMemoryUsage().getMax());
        machineInfo.setJvmFreeMemory(this.memoryMXBean.getHeapMemoryUsage().getMax() - this.memoryMXBean.getHeapMemoryUsage().getUsed());
        machineInfo.setProcessCpuRate(this.operatingSystemMXBean.getProcessCpuLoad());
        ArrayList<NodeInfo.MachineInfo.MemoryDescInfo> memoryDescInfoList = new ArrayList<NodeInfo.MachineInfo.MemoryDescInfo>();
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        if (CollectionUtils.isNotEmpty(pools)) {
            for (MemoryPoolMXBean pool : pools) {
                NodeInfo.MachineInfo.MemoryDescInfo memoryDescInfo = new NodeInfo.MachineInfo.MemoryDescInfo();
                memoryDescInfo.setName(pool.getName());
                memoryDescInfo.setInitSize(pool.getUsage().getInit());
                memoryDescInfo.setUseSize(pool.getUsage().getUsed());
                memoryDescInfo.setMaxSize(pool.getUsage().getMax());
                if (pool.getUsage().getMax() > 0L) {
                    memoryDescInfo.setUseRate((double)pool.getUsage().getUsed() / (double)pool.getUsage().getMax());
                } else {
                    memoryDescInfo.setUseRate((double)pool.getUsage().getUsed() / (double)pool.getUsage().getCommitted());
                }
                memoryDescInfoList.add(memoryDescInfo);
            }
        }
        machineInfo.setMemoryDescInfoList(memoryDescInfoList);
        long[] deadlockedIds = this.threadMXBean.findDeadlockedThreads();
        if (ArrayUtils.isNotEmpty((long[])deadlockedIds)) {
            machineInfo.setDeadLockThreadCount(deadlockedIds.length);
            ThreadInfo[] deadlockInfos = this.threadMXBean.getThreadInfo(deadlockedIds);
            ArrayList<NodeInfo.MachineInfo.DeadLockThreadInfo> deadLockThreadInfoList = new ArrayList<NodeInfo.MachineInfo.DeadLockThreadInfo>();
            for (ThreadInfo deadlockInfo : deadlockInfos) {
                NodeInfo.MachineInfo.DeadLockThreadInfo deadLockThreadInfo = new NodeInfo.MachineInfo.DeadLockThreadInfo();
                deadLockThreadInfo.setName(deadlockInfo.getThreadName());
                deadLockThreadInfo.setLockName(deadlockInfo.getLockName());
                deadLockThreadInfo.setLockOwner(deadlockInfo.getLockOwnerName());
                deadLockThreadInfo.setBlockTime(deadlockInfo.getBlockedTime());
                deadLockThreadInfo.setWaitTime(deadlockInfo.getWaitedTime());
                deadLockThreadInfo.setState(deadlockInfo.getThreadState().name());
                deadLockThreadInfo.setStackTrace(Arrays.toString(deadlockInfo.getStackTrace()));
                deadLockThreadInfoList.add(deadLockThreadInfo);
            }
            machineInfo.setDeadLockThreadInfoList(deadLockThreadInfoList);
        }
        nodeInfo.setMachineInfo(machineInfo);
    }

    private void setConnectInfo(NodeInfo nodeInfo) {
        nodeInfo.setCurrentConnectCount(this.syncPool.getActivePeers().size());
        nodeInfo.setActiveConnectCount(this.syncPool.getActivePeersCount().get());
        nodeInfo.setPassiveConnectCount(this.syncPool.getPassivePeersCount().get());
        long totalFlow = 0L;
        ArrayList<PeerInfo> peerInfoList = new ArrayList<PeerInfo>();
        for (PeerConnection peerConnection : this.syncPool.getActivePeers()) {
            PeerInfo peerInfo = new PeerInfo();
            peerInfo.setHeadBlockWeBothHave(peerConnection.getHeadBlockWeBothHave().getString());
            peerInfo.setActive(peerConnection.isActive());
            peerInfo.setAvgLatency(peerConnection.getPeerStats().getAvgLatency());
            peerInfo.setBlockInPorcSize(peerConnection.getBlockInProc().size());
            peerInfo.setConnectTime(peerConnection.getStartTime());
            peerInfo.setDisconnectTimes(peerConnection.getNodeStatistics().getDisconnectTimes());
            peerInfo.setHeadBlockTimeWeBothHave(peerConnection.getHeadBlockTimeWeBothHave());
            peerInfo.setHost(peerConnection.getNode().getHost());
            peerInfo.setInFlow(peerConnection.getNodeStatistics().tcpFlow.getTotalCount());
            peerInfo.setLastBlockUpdateTime(peerConnection.getLastBlockUpdateTime());
            peerInfo.setLastSyncBlock(peerConnection.getLastSyncBlockId() == null ? "" : peerConnection.getLastSyncBlockId().getString());
            Protocol.ReasonCode reasonCode = peerConnection.getNodeStatistics().getTronLastLocalDisconnectReason();
            peerInfo.setLocalDisconnectReason(reasonCode == null ? "" : reasonCode.toString());
            reasonCode = peerConnection.getNodeStatistics().getTronLastRemoteDisconnectReason();
            peerInfo.setRemoteDisconnectReason(reasonCode == null ? "" : reasonCode.toString());
            peerInfo.setNeedSyncFromPeer(peerConnection.isNeedSyncFromPeer());
            peerInfo.setNeedSyncFromUs(peerConnection.isNeedSyncFromUs());
            peerInfo.setNodeCount(this.nodeManager.getTable().getAllNodes().size());
            peerInfo.setNodeId(peerConnection.getNode().getHexId());
            peerInfo.setPort(peerConnection.getNode().getPort());
            peerInfo.setRemainNum(peerConnection.getRemainNum());
            peerInfo.setScore(peerConnection.getNodeStatistics().getReputation());
            peerInfo.setSyncBlockRequestedSize(peerConnection.getSyncBlockRequested().size());
            peerInfo.setSyncFlag(peerConnection.getSyncFlag());
            peerInfo.setSyncToFetchSize(peerConnection.getSyncBlockToFetch().size());
            peerInfo.setSyncToFetchSizePeekNum(peerConnection.getSyncBlockToFetch().size() > 0 ? peerConnection.getSyncBlockToFetch().peek().getNum() : -1L);
            peerInfo.setUnFetchSynNum(peerConnection.getUnfetchSyncNum());
            totalFlow += peerConnection.getNodeStatistics().tcpFlow.getTotalCount();
            peerInfoList.add(peerInfo);
        }
        nodeInfo.setPeerList(peerInfoList);
        nodeInfo.setTotalFlow(totalFlow);
    }

    private void setConfigNodeInfo(NodeInfo nodeInfo) {
        NodeInfo.ConfigNodeInfo configNodeInfo = new NodeInfo.ConfigNodeInfo();
        configNodeInfo.setCodeVersion(Version.getVersion());
        configNodeInfo.setP2pVersion(String.valueOf(this.args.getNodeP2pVersion()));
        configNodeInfo.setListenPort(this.args.getNodeListenPort());
        configNodeInfo.setDiscoverEnable(this.args.isNodeDiscoveryEnable());
        configNodeInfo.setActiveNodeSize(this.args.getActiveNodes().size());
        configNodeInfo.setPassiveNodeSize(this.args.getPassiveNodes().size());
        configNodeInfo.setSendNodeSize(this.args.getSeedNodes().size());
        configNodeInfo.setMaxConnectCount(this.args.getNodeMaxActiveNodes());
        configNodeInfo.setSameIpMaxConnectCount(this.args.getNodeMaxActiveNodesWithSameIp());
        configNodeInfo.setBackupListenPort(this.args.getBackupPort());
        configNodeInfo.setBackupMemberSize(this.args.getBackupMembers().size());
        configNodeInfo.setBackupPriority(this.args.getBackupPriority());
        configNodeInfo.setDbVersion(this.args.getStorage().getDbVersion());
        configNodeInfo.setMinParticipationRate(this.args.getMinParticipationRate());
        configNodeInfo.setSupportConstant(this.args.isSupportConstant());
        configNodeInfo.setMinTimeRatio(this.args.getMinTimeRatio());
        configNodeInfo.setMaxTimeRatio(this.args.getMaxTimeRatio());
        configNodeInfo.setAllowCreationOfContracts(this.args.getAllowCreationOfContracts());
        configNodeInfo.setAllowAdaptiveEnergy(this.args.getAllowAdaptiveEnergy());
        nodeInfo.setConfigNodeInfo(configNodeInfo);
    }

    private void setBlockInfo(NodeInfo nodeInfo) {
        nodeInfo.setBeginSyncNum(this.dbManager.getSyncBeginNumber());
        nodeInfo.setBlock(this.dbManager.getHeadBlockId().getString());
        nodeInfo.setSolidityBlock(this.dbManager.getSolidBlockId().getString());
    }

    private void setCheatWitnessInfo(NodeInfo nodeInfo) {
        for (Map.Entry<String, WitnessProductBlockService.CheatWitnessInfo> entry : this.witnessProductBlockService.queryCheatWitnessInfo().entrySet()) {
            nodeInfo.getCheatWitnessInfoMap().put(entry.getKey(), entry.getValue().toString());
        }
    }
}

