/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.peer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.message.HelloMessage;
import org.tron.common.overlay.message.Message;
import org.tron.common.overlay.server.Channel;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.Time;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.net.node.Item;

@Component
@Scope(value="prototype")
public class PeerConnection
extends Channel {
    private static final Logger logger = LoggerFactory.getLogger(PeerConnection.class);
    private Cache<Sha256Hash, Integer> syncBlockIdCache = CacheBuilder.newBuilder().maximumSize(4000L).build();
    private BlockCapsule.BlockId lastSyncBlockId;
    private long remainNum;
    private long lastBlockUpdateTime = System.currentTimeMillis();
    private volatile boolean syncFlag = true;
    private HelloMessage helloMessage;
    private Queue<Sha256Hash> invToUs = new LinkedBlockingQueue<Sha256Hash>();
    private Queue<Sha256Hash> invWeAdv = new LinkedBlockingQueue<Sha256Hash>();
    private Map<Sha256Hash, Long> advObjSpreadToUs = new ConcurrentHashMap<Sha256Hash, Long>();
    private Map<Sha256Hash, Long> advObjWeSpread = new ConcurrentHashMap<Sha256Hash, Long>();
    private Map<Item, Long> advObjWeRequested = new ConcurrentHashMap<Item, Long>();
    private boolean advInhibit = false;
    private BlockCapsule.BlockId headBlockWeBothHave = new BlockCapsule.BlockId();
    private long headBlockTimeWeBothHave;
    private Deque<BlockCapsule.BlockId> syncBlockToFetch = new ConcurrentLinkedDeque<BlockCapsule.BlockId>();
    private Map<BlockCapsule.BlockId, Long> syncBlockRequested = new ConcurrentHashMap<BlockCapsule.BlockId, Long>();
    private Pair<Deque<BlockCapsule.BlockId>, Long> syncChainRequested = null;
    private long unfetchSyncNum = 0L;
    private boolean needSyncFromPeer;
    private boolean needSyncFromUs;
    private boolean banned;
    private Set<BlockCapsule.BlockId> blockInProc = new HashSet<BlockCapsule.BlockId>();

    public Map<Sha256Hash, Long> getAdvObjSpreadToUs() {
        return this.advObjSpreadToUs;
    }

    public Map<Sha256Hash, Long> getAdvObjWeSpread() {
        return this.advObjWeSpread;
    }

    public boolean isAdvInhibit() {
        return this.advInhibit;
    }

    public void setAdvInhibit(boolean advInhibit) {
        this.advInhibit = advInhibit;
    }

    public Pair<Deque<BlockCapsule.BlockId>, Long> getSyncChainRequested() {
        return this.syncChainRequested;
    }

    public Cache<Sha256Hash, Integer> getSyncBlockIdCache() {
        return this.syncBlockIdCache;
    }

    public void setSyncChainRequested(Pair<Deque<BlockCapsule.BlockId>, Long> syncChainRequested) {
        this.syncChainRequested = syncChainRequested;
    }

    public Map<BlockCapsule.BlockId, Long> getSyncBlockRequested() {
        return this.syncBlockRequested;
    }

    public void setSyncBlockRequested(ConcurrentHashMap<BlockCapsule.BlockId, Long> syncBlockRequested) {
        this.syncBlockRequested = syncBlockRequested;
    }

    public long getUnfetchSyncNum() {
        return this.unfetchSyncNum;
    }

    public void setUnfetchSyncNum(long unfetchSyncNum) {
        this.unfetchSyncNum = unfetchSyncNum;
    }

    public Set<BlockCapsule.BlockId> getBlockInProc() {
        return this.blockInProc;
    }

    public void setBlockInProc(Set<BlockCapsule.BlockId> blockInProc) {
        this.blockInProc = blockInProc;
    }

    public Map<Item, Long> getAdvObjWeRequested() {
        return this.advObjWeRequested;
    }

    public void setAdvObjWeRequested(ConcurrentHashMap<Item, Long> advObjWeRequested) {
        this.advObjWeRequested = advObjWeRequested;
    }

    public void setHelloMessage(HelloMessage helloMessage) {
        this.helloMessage = helloMessage;
    }

    public HelloMessage getHelloMessage() {
        return this.helloMessage;
    }

    public void cleanInvGarbage() {
        long oldestTimestamp = Time.getCurrentMillis() - 120000L;
        Iterator<Map.Entry<Sha256Hash, Long>> iterator = this.advObjSpreadToUs.entrySet().iterator();
        this.removeIterator(iterator, oldestTimestamp);
        iterator = this.advObjWeSpread.entrySet().iterator();
        this.removeIterator(iterator, oldestTimestamp);
    }

    private void removeIterator(Iterator<Map.Entry<Sha256Hash, Long>> iterator, long oldestTimestamp) {
        while (iterator.hasNext()) {
            Map.Entry<Sha256Hash, Long> entry = iterator.next();
            Long ts = entry.getValue();
            if (ts >= oldestTimestamp) continue;
            iterator.remove();
        }
    }

    public boolean isAdvInvFull() {
        return (long)this.advObjSpreadToUs.size() > 120L * Args.getInstance().getNetMaxTrxPerSecond();
    }

    public boolean isBanned() {
        return this.banned;
    }

    public void setBanned(boolean banned) {
        this.banned = banned;
    }

    public BlockCapsule.BlockId getHeadBlockWeBothHave() {
        return this.headBlockWeBothHave;
    }

    public void setHeadBlockWeBothHave(BlockCapsule.BlockId headBlockWeBothHave) {
        this.headBlockWeBothHave = headBlockWeBothHave;
    }

    public long getHeadBlockTimeWeBothHave() {
        return this.headBlockTimeWeBothHave;
    }

    public void setHeadBlockTimeWeBothHave(long headBlockTimeWeBothHave) {
        this.headBlockTimeWeBothHave = headBlockTimeWeBothHave;
    }

    public Deque<BlockCapsule.BlockId> getSyncBlockToFetch() {
        return this.syncBlockToFetch;
    }

    public boolean isNeedSyncFromPeer() {
        return this.needSyncFromPeer;
    }

    public void setNeedSyncFromPeer(boolean needSyncFromPeer) {
        this.needSyncFromPeer = needSyncFromPeer;
    }

    public boolean isNeedSyncFromUs() {
        return this.needSyncFromUs;
    }

    public void setNeedSyncFromUs(boolean needSyncFromUs) {
        this.needSyncFromUs = needSyncFromUs;
    }

    public Queue<Sha256Hash> getInvToUs() {
        return this.invToUs;
    }

    public void setInvToUs(Queue<Sha256Hash> invToUs) {
        this.invToUs = invToUs;
    }

    public Queue<Sha256Hash> getInvWeAdv() {
        return this.invWeAdv;
    }

    public void setInvWeAdv(Queue<Sha256Hash> invWeAdv) {
        this.invWeAdv = invWeAdv;
    }

    public boolean getSyncFlag() {
        return this.syncFlag;
    }

    public void setSyncFlag(boolean syncFlag) {
        this.syncFlag = syncFlag;
    }

    public String logSyncStats() {
        return String.format("Peer %s: [ %18s, ping %6s ms]-----------\nconnect time: %s\nlast know block num: %s\nneedSyncFromPeer:%b\nneedSyncFromUs:%b\nsyncToFetchSize:%d\nsyncToFetchSizePeekNum:%d\nsyncBlockRequestedSize:%d\nunFetchSynNum:%d\nsyncChainRequested:%s\nblockInPorc:%d\n", this.getNode().getHost() + ":" + this.getNode().getPort(), this.getNode().getHexIdShort(), (int)this.getPeerStats().getAvgLatency(), Time.getTimeString(super.getStartTime()), this.headBlockWeBothHave.getNum(), this.isNeedSyncFromPeer(), this.isNeedSyncFromUs(), this.syncBlockToFetch.size(), this.syncBlockToFetch.size() > 0 ? this.syncBlockToFetch.peek().getNum() : -1L, this.syncBlockRequested.size(), this.unfetchSyncNum, this.syncChainRequested == null ? "NULL" : Time.getTimeString((Long)this.syncChainRequested.getValue()), this.blockInProc.size()) + this.nodeStatistics.toString() + "\n";
    }

    public boolean isBusy() {
        return !this.idle();
    }

    public boolean idle() {
        return this.advObjWeRequested.isEmpty() && this.syncBlockRequested.isEmpty() && this.syncChainRequested == null;
    }

    public void sendMessage(Message message) {
        this.msgQueue.sendMessage(message);
    }

    public void setLastSyncBlockId(BlockCapsule.BlockId lastSyncBlockId) {
        this.lastSyncBlockId = lastSyncBlockId;
    }

    public BlockCapsule.BlockId getLastSyncBlockId() {
        return this.lastSyncBlockId;
    }

    public void setRemainNum(long remainNum) {
        this.remainNum = remainNum;
    }

    public long getRemainNum() {
        return this.remainNum;
    }

    public void setLastBlockUpdateTime(long lastBlockUpdateTime) {
        this.lastBlockUpdateTime = lastBlockUpdateTime;
    }

    public long getLastBlockUpdateTime() {
        return this.lastBlockUpdateTime;
    }
}

