/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.message;

import java.util.List;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TronMessage;
import org.tron.protos.Protocol;

public class TransactionsMessage
extends TronMessage {
    private Protocol.Transactions transactions;

    public TransactionsMessage(List<Protocol.Transaction> trxs) {
        Protocol.Transactions.Builder builder = Protocol.Transactions.newBuilder();
        trxs.forEach(trx -> builder.addTransactions((Protocol.Transaction)trx));
        this.transactions = builder.build();
        this.type = MessageTypes.TRXS.asByte();
        this.data = this.transactions.toByteArray();
    }

    public TransactionsMessage(byte[] data) throws Exception {
        this.type = MessageTypes.TRXS.asByte();
        this.data = data;
        this.transactions = Protocol.Transactions.parseFrom(data);
    }

    public Protocol.Transactions getTransactions() {
        return this.transactions;
    }

    @Override
    public String toString() {
        return super.toString() + "trx size: " + this.transactions.getTransactionsList().size();
    }

    @Override
    public Class<?> getAnswerMessage() {
        return null;
    }
}

