/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.api.index;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.disk.DiskIndex;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.disk.DiskPersistence;
import com.googlecode.cqengine.query.QueryFactory;
import java.io.File;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.api.index.AbstractIndex;
import org.tron.core.db.common.WrappedByteArray;
import org.tron.core.db2.core.ITronChainBase;
import org.tron.protos.Protocol;

@Component
public class TransactionIndex
extends AbstractIndex<TransactionCapsule, Protocol.Transaction> {
    private static final Logger logger = LoggerFactory.getLogger(TransactionIndex.class);
    public static SimpleAttribute<WrappedByteArray, String> Transaction_ID;
    public static Attribute<WrappedByteArray, String> OWNERS;
    public static Attribute<WrappedByteArray, String> TOS;
    public static Attribute<WrappedByteArray, Long> TIMESTAMP;

    @Autowired
    public TransactionIndex(@Qualifier(value="transactionStore") ITronChainBase<TransactionCapsule> database) {
        super(database);
    }

    @PostConstruct
    public void init() {
        this.initIndex((Persistence<WrappedByteArray, Comparable>)DiskPersistence.onPrimaryKeyInFile(Transaction_ID, (File)this.indexPath));
        this.index.addIndex((Index)DiskIndex.onAttribute(OWNERS));
        this.index.addIndex((Index)DiskIndex.onAttribute(TOS));
        this.index.addIndex((Index)DiskIndex.onAttribute(TIMESTAMP));
    }

    @Override
    protected void setAttribute() {
        Transaction_ID = QueryFactory.attribute((String)"transaction id", bytes -> new TransactionCapsule((Protocol.Transaction)this.getObject((WrappedByteArray)bytes)).getTransactionId().toString());
        OWNERS = QueryFactory.attribute(String.class, (String)"owner address", bytes -> ((Protocol.Transaction)this.getObject((WrappedByteArray)bytes)).getRawData().getContractList().stream().map(TransactionCapsule::getOwner).filter(Objects::nonNull).map(ByteArray::toHexString).collect(Collectors.toList()));
        TOS = QueryFactory.attribute(String.class, (String)"to address", bytes -> ((Protocol.Transaction)this.getObject((WrappedByteArray)bytes)).getRawData().getContractList().stream().map(TransactionCapsule::getToAddress).filter(Objects::nonNull).map(ByteArray::toHexString).collect(Collectors.toList()));
        TIMESTAMP = QueryFactory.attribute((String)"timestamp", bytes -> ((Protocol.Transaction)this.getObject((WrappedByteArray)bytes)).getRawData().getTimestamp());
    }
}

