/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.api.index;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.disk.DiskIndex;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.disk.DiskPersistence;
import com.googlecode.cqengine.query.QueryFactory;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.api.index.AbstractIndex;
import org.tron.core.db.common.WrappedByteArray;
import org.tron.core.db2.core.ITronChainBase;
import org.tron.protos.Protocol;

@Component
public class BlockIndex
extends AbstractIndex<BlockCapsule, Protocol.Block> {
    private static final Logger logger = LoggerFactory.getLogger(BlockIndex.class);
    public static SimpleAttribute<WrappedByteArray, String> Block_ID;
    public static Attribute<WrappedByteArray, Long> Block_NUMBER;
    public static Attribute<WrappedByteArray, String> TRANSACTIONS;
    public static Attribute<WrappedByteArray, Long> WITNESS_ID;
    public static Attribute<WrappedByteArray, String> WITNESS_ADDRESS;
    public static Attribute<WrappedByteArray, String> OWNERS;
    public static Attribute<WrappedByteArray, String> TOS;

    @Autowired
    public BlockIndex(@Qualifier(value="blockStore") ITronChainBase<BlockCapsule> database) {
        super(database);
    }

    @PostConstruct
    public void init() {
        this.initIndex((Persistence<WrappedByteArray, Comparable>)DiskPersistence.onPrimaryKeyInFile(Block_ID, (File)this.indexPath));
        this.index.addIndex((Index)DiskIndex.onAttribute(Block_NUMBER));
        this.index.addIndex((Index)DiskIndex.onAttribute(TRANSACTIONS));
        this.index.addIndex((Index)DiskIndex.onAttribute(WITNESS_ID));
        this.index.addIndex((Index)DiskIndex.onAttribute(WITNESS_ADDRESS));
        this.index.addIndex((Index)DiskIndex.onAttribute(OWNERS));
        this.index.addIndex((Index)DiskIndex.onAttribute(TOS));
    }

    @Override
    protected void setAttribute() {
        Block_ID = QueryFactory.attribute((String)"block id", bytes -> {
            Protocol.Block block = (Protocol.Block)this.getObject((WrappedByteArray)bytes);
            return new BlockCapsule(block).getBlockId().toString();
        });
        Block_NUMBER = QueryFactory.attribute((String)"block number", bytes -> {
            Protocol.Block block = (Protocol.Block)this.getObject((WrappedByteArray)bytes);
            return block.getBlockHeader().getRawData().getNumber();
        });
        TRANSACTIONS = QueryFactory.attribute(String.class, (String)"transactions", bytes -> {
            Protocol.Block block = (Protocol.Block)this.getObject((WrappedByteArray)bytes);
            return block.getTransactionsList().stream().map(t -> Sha256Hash.of(t.getRawData().toByteArray()).toString()).collect(Collectors.toList());
        });
        WITNESS_ID = QueryFactory.attribute((String)"witness id", bytes -> {
            Protocol.Block block = (Protocol.Block)this.getObject((WrappedByteArray)bytes);
            return block.getBlockHeader().getRawData().getWitnessId();
        });
        WITNESS_ADDRESS = QueryFactory.attribute((String)"witness address", bytes -> {
            Protocol.Block block = (Protocol.Block)this.getObject((WrappedByteArray)bytes);
            return ByteArray.toHexString(block.getBlockHeader().getRawData().getWitnessAddress().toByteArray());
        });
        OWNERS = QueryFactory.attribute(String.class, (String)"owner address", bytes -> {
            Protocol.Block block = (Protocol.Block)this.getObject((WrappedByteArray)bytes);
            return block.getTransactionsList().stream().map(transaction -> transaction.getRawData().getContractList()).flatMap(Collection::stream).map(TransactionCapsule::getOwner).filter(Objects::nonNull).distinct().map(ByteArray::toHexString).collect(Collectors.toList());
        });
        TOS = QueryFactory.attribute(String.class, (String)"to address", bytes -> {
            Protocol.Block block = (Protocol.Block)this.getObject((WrappedByteArray)bytes);
            return block.getTransactionsList().stream().map(transaction -> transaction.getRawData().getContractList()).flatMap(Collection::stream).map(TransactionCapsule::getToAddress).filter(Objects::nonNull).distinct().map(ByteArray::toHexString).collect(Collectors.toList());
        });
    }
}

