/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.api.index;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.disk.DiskIndex;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.disk.DiskPersistence;
import com.googlecode.cqengine.query.QueryFactory;
import java.io.File;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.db.api.index.AbstractIndex;
import org.tron.core.db.common.WrappedByteArray;
import org.tron.core.db2.core.ITronChainBase;
import org.tron.protos.Contract;

@Component
public class AssetIssueIndex
extends AbstractIndex<AssetIssueCapsule, Contract.AssetIssueContract> {
    private static final Logger logger = LoggerFactory.getLogger(AssetIssueIndex.class);
    public static Attribute<WrappedByteArray, String> AssetIssue_OWNER_ADDRESS;
    public static SimpleAttribute<WrappedByteArray, String> AssetIssue_NAME;
    public static Attribute<WrappedByteArray, Long> AssetIssue_START;
    public static Attribute<WrappedByteArray, Long> AssetIssue_END;

    @Autowired
    public AssetIssueIndex(@Qualifier(value="assetIssueStore") ITronChainBase<AssetIssueCapsule> database) {
        super(database);
    }

    @PostConstruct
    public void init() {
        this.initIndex((Persistence<WrappedByteArray, Comparable>)DiskPersistence.onPrimaryKeyInFile(AssetIssue_NAME, (File)this.indexPath));
        this.index.addIndex((Index)DiskIndex.onAttribute(AssetIssue_OWNER_ADDRESS));
        this.index.addIndex((Index)DiskIndex.onAttribute(AssetIssue_START));
        this.index.addIndex((Index)DiskIndex.onAttribute(AssetIssue_END));
    }

    @Override
    protected void setAttribute() {
        AssetIssue_OWNER_ADDRESS = QueryFactory.attribute((String)"assetIssue owner address", bytes -> {
            Contract.AssetIssueContract assetIssue = (Contract.AssetIssueContract)this.getObject((WrappedByteArray)bytes);
            return ByteArray.toHexString(assetIssue.getOwnerAddress().toByteArray());
        });
        AssetIssue_NAME = QueryFactory.attribute((String)"assetIssue name", bytes -> {
            Contract.AssetIssueContract assetIssue = (Contract.AssetIssueContract)this.getObject((WrappedByteArray)bytes);
            return assetIssue.getName().toStringUtf8();
        });
        AssetIssue_START = QueryFactory.attribute((String)"assetIssue start time", bytes -> {
            Contract.AssetIssueContract assetIssue = (Contract.AssetIssueContract)this.getObject((WrappedByteArray)bytes);
            return assetIssue.getStartTime();
        });
        AssetIssue_END = QueryFactory.attribute((String)"assetIssue end time", bytes -> {
            Contract.AssetIssueContract assetIssue = (Contract.AssetIssueContract)this.getObject((WrappedByteArray)bytes);
            return assetIssue.getEndTime();
        });
    }
}

