/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.Manager;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class AssetUpdateHelper {
    private static final Logger logger = LoggerFactory.getLogger(AssetUpdateHelper.class);
    private Manager dbManager;
    private HashMap<String, byte[]> assetNameToIdMap = new HashMap();

    public AssetUpdateHelper(Manager dbManager) {
        this.dbManager = dbManager;
    }

    public void doWork() {
        long start = System.currentTimeMillis();
        logger.info("Start updating the asset");
        this.init();
        this.updateAsset();
        this.updateExchange();
        this.updateAccount();
        this.finish();
        logger.info("Complete the asset update,Total time\uff1a{} milliseconds", (Object)(System.currentTimeMillis() - start));
    }

    public void init() {
        if (this.dbManager.getAssetIssueV2Store().iterator().hasNext()) {
            logger.warn("AssetIssueV2Store is not empty");
        }
        this.dbManager.getAssetIssueV2Store().reset();
        if (this.dbManager.getExchangeV2Store().iterator().hasNext()) {
            logger.warn("ExchangeV2Store is not empty");
        }
        this.dbManager.getExchangeV2Store().reset();
        this.dbManager.getDynamicPropertiesStore().saveTokenIdNum(1000000L);
    }

    public List<AssetIssueCapsule> getAllAssetIssues() {
        long blockNum;
        ArrayList<AssetIssueCapsule> result = new ArrayList<AssetIssueCapsule>();
        long latestBlockHeaderNumber = this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
        for (blockNum = 1L; blockNum <= latestBlockHeaderNumber; ++blockNum) {
            if (blockNum % 100000L == 0L) {
                logger.info("The number of block that have processed\uff1a{}", (Object)blockNum);
            }
            try {
                BlockCapsule block = this.dbManager.getBlockByNum(blockNum);
                for (TransactionCapsule transaction : block.getTransactions()) {
                    if (transaction.getInstance().getRawData().getContract(0).getType() != Protocol.Transaction.Contract.ContractType.AssetIssueContract) continue;
                    Contract.AssetIssueContract obj = (Contract.AssetIssueContract)transaction.getInstance().getRawData().getContract(0).getParameter().unpack(Contract.AssetIssueContract.class);
                    AssetIssueCapsule assetIssueCapsule = new AssetIssueCapsule(obj);
                    result.add(this.dbManager.getAssetIssueStore().get(assetIssueCapsule.createDbKey()));
                }
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Block not exists,num:" + blockNum);
            }
        }
        logger.info("Total block\uff1a{}", (Object)blockNum);
        if (this.dbManager.getAssetIssueStore().getAllAssetIssues().size() != result.size()) {
            throw new RuntimeException("Asset num is wrong!");
        }
        return result;
    }

    public void updateAsset() {
        long tokenIdNum = this.dbManager.getDynamicPropertiesStore().getTokenIdNum();
        long count = 0L;
        List<AssetIssueCapsule> assetIssueCapsuleList = this.getAllAssetIssues();
        for (AssetIssueCapsule assetIssueCapsule : assetIssueCapsuleList) {
            ++count;
            assetIssueCapsule.setId(Long.toString(++tokenIdNum));
            this.dbManager.getAssetIssueStore().put(assetIssueCapsule.createDbKey(), assetIssueCapsule);
            assetIssueCapsule.setPrecision(0);
            this.dbManager.getAssetIssueV2Store().put(assetIssueCapsule.createDbV2Key(), assetIssueCapsule);
            this.assetNameToIdMap.put(ByteArray.toStr(assetIssueCapsule.createDbKey()), assetIssueCapsule.createDbV2Key());
        }
        this.dbManager.getDynamicPropertiesStore().saveTokenIdNum(tokenIdNum);
        logger.info("Complete the asset store update,Total assets\uff1a{}", (Object)count);
    }

    public void updateExchange() {
        long count = 0L;
        for (ExchangeCapsule exchangeCapsule : this.dbManager.getExchangeStore().getAllExchanges()) {
            ++count;
            if (!Arrays.equals(exchangeCapsule.getFirstTokenId(), "_".getBytes())) {
                exchangeCapsule.setFirstTokenId(this.assetNameToIdMap.get(ByteArray.toStr(exchangeCapsule.getFirstTokenId())));
            }
            if (!Arrays.equals(exchangeCapsule.getSecondTokenId(), "_".getBytes())) {
                exchangeCapsule.setSecondTokenId(this.assetNameToIdMap.get(ByteArray.toStr(exchangeCapsule.getSecondTokenId())));
            }
            this.dbManager.getExchangeV2Store().put(exchangeCapsule.createDbKey(), exchangeCapsule);
        }
        logger.info("Complete the exchange store update,Total exchanges\uff1a{}", (Object)count);
    }

    public void updateAccount() {
        long count = 0L;
        Iterator iterator = this.dbManager.getAccountStore().iterator();
        while (iterator.hasNext()) {
            HashMap<String, Long> map;
            AccountCapsule accountCapsule = (AccountCapsule)iterator.next().getValue();
            accountCapsule.clearAssetV2();
            if (accountCapsule.getAssetMap().size() != 0) {
                map = new HashMap<String, Long>();
                for (Map.Entry<String, Long> entry : accountCapsule.getAssetMap().entrySet()) {
                    map.put(ByteArray.toStr(this.assetNameToIdMap.get(entry.getKey())), entry.getValue());
                }
                accountCapsule.addAssetMapV2(map);
            }
            accountCapsule.clearFreeAssetNetUsageV2();
            if (accountCapsule.getAllFreeAssetNetUsage().size() != 0) {
                map = new HashMap();
                for (Map.Entry<String, Long> entry : accountCapsule.getAllFreeAssetNetUsage().entrySet()) {
                    map.put(ByteArray.toStr(this.assetNameToIdMap.get(entry.getKey())), entry.getValue());
                }
                accountCapsule.addAllFreeAssetNetUsageV2(map);
            }
            accountCapsule.clearLatestAssetOperationTimeV2();
            if (accountCapsule.getLatestAssetOperationTimeMap().size() != 0) {
                map = new HashMap();
                for (Map.Entry<String, Long> entry : accountCapsule.getLatestAssetOperationTimeMap().entrySet()) {
                    map.put(ByteArray.toStr(this.assetNameToIdMap.get(entry.getKey())), entry.getValue());
                }
                accountCapsule.addAllLatestAssetOperationTimeV2(map);
            }
            if (!accountCapsule.getAssetIssuedName().isEmpty()) {
                accountCapsule.setAssetIssuedID(this.assetNameToIdMap.get(ByteArray.toStr(accountCapsule.getAssetIssuedName().toByteArray())));
            }
            this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
            if (count % 50000L == 0L) {
                logger.info("The number of accounts that have completed the update \uff1a{}", (Object)count);
            }
            ++count;
        }
        logger.info("Complete the account store update,Total assets\uff1a{}", (Object)count);
    }

    public void finish() {
        this.dbManager.getDynamicPropertiesStore().saveTokenUpdateDone(1L);
        this.assetNameToIdMap.clear();
    }
}

