/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.BlockStore;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.StoreException;

@Component
public class TransactionStore
extends TronStoreWithRevoking<TransactionCapsule> {
    private static final Logger logger = LoggerFactory.getLogger(TransactionStore.class);
    @Autowired
    private BlockStore blockStore;

    @Autowired
    private TransactionStore(@Value(value="trans") String dbName) {
        super(dbName);
    }

    @Override
    public void put(byte[] key, TransactionCapsule item) {
        if (Objects.isNull(item) || item.getBlockNum() == -1L) {
            super.put(key, item);
        } else {
            this.revokingDB.put(key, ByteArray.fromLong(item.getBlockNum()));
        }
        if (Objects.nonNull(this.indexHelper)) {
            this.indexHelper.update(item.getInstance());
        }
    }

    @Override
    public TransactionCapsule get(byte[] key) throws BadItemException {
        List<BlockCapsule> blocksList;
        byte[] value = this.revokingDB.getUnchecked(key);
        if (ArrayUtils.isEmpty((byte[])value)) {
            return null;
        }
        if (value.length == 8 && (blocksList = this.blockStore.getLimitNumber(ByteArray.toLong(value), 1L)).size() != 0) {
            for (TransactionCapsule e : blocksList.get(0).getTransactions()) {
                if (!e.getTransactionId().equals(Sha256Hash.wrap(key))) continue;
                return e;
            }
        }
        return new TransactionCapsule(value);
    }

    @Deprecated
    public long getTotalTransactions() {
        return 0L;
    }

    @Override
    public void delete(byte[] key) {
        this.deleteIndex(key);
        super.delete(key);
    }

    private void deleteIndex(byte[] key) {
        if (Objects.nonNull(this.indexHelper)) {
            try {
                TransactionCapsule item = this.get(key);
                if (Objects.nonNull(item)) {
                    this.indexHelper.remove(item.getInstance());
                }
            }
            catch (StoreException e) {
                return;
            }
        }
    }
}

