/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.Manager;
import org.tron.core.db.TransactionTrace;

public class PendingManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(PendingManager.class);
    static List<TransactionCapsule> tmpTransactions = new ArrayList<TransactionCapsule>();
    Manager dbManager;

    public PendingManager(Manager db) {
        this.dbManager = db;
        tmpTransactions.addAll(db.getPendingTransactions());
        db.getPendingTransactions().clear();
        db.getSession().reset();
    }

    @Override
    public void close() {
        for (TransactionCapsule tx : tmpTransactions) {
            try {
                if (tx.getTrxTrace() == null || !tx.getTrxTrace().getTimeResultType().equals((Object)TransactionTrace.TimeResultType.NORMAL)) continue;
                this.dbManager.getRepushTransactions().put(tx);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        tmpTransactions.clear();
        for (TransactionCapsule tx : this.dbManager.getPoppedTransactions()) {
            try {
                if (tx.getTrxTrace() == null || !tx.getTrxTrace().getTimeResultType().equals((Object)TransactionTrace.TimeResultType.NORMAL)) continue;
                this.dbManager.getRepushTransactions().put(tx);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        this.dbManager.getPoppedTransactions().clear();
    }

    public static List<TransactionCapsule> getTmpTransactions() {
        return tmpTransactions;
    }
}

