/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.util.Pair;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.runtime.config.VMConfig;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ForkController;
import org.tron.common.utils.SessionOptional;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.TransactionInfoCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.capsule.utils.BlockUtil;
import org.tron.core.config.args.Args;
import org.tron.core.config.args.GenesisBlock;
import org.tron.core.db.AccountIdIndexStore;
import org.tron.core.db.AccountIndexStore;
import org.tron.core.db.AccountStore;
import org.tron.core.db.AssetIssueStore;
import org.tron.core.db.AssetIssueV2Store;
import org.tron.core.db.BandwidthProcessor;
import org.tron.core.db.BlockIndexStore;
import org.tron.core.db.BlockStore;
import org.tron.core.db.CodeStore;
import org.tron.core.db.ContractStore;
import org.tron.core.db.DelegatedResourceAccountIndexStore;
import org.tron.core.db.DelegatedResourceStore;
import org.tron.core.db.DynamicPropertiesStore;
import org.tron.core.db.ExchangeStore;
import org.tron.core.db.ExchangeV2Store;
import org.tron.core.db.KhaosDatabase;
import org.tron.core.db.PeersStore;
import org.tron.core.db.PendingManager;
import org.tron.core.db.ProposalStore;
import org.tron.core.db.RecentBlockStore;
import org.tron.core.db.RevokingDatabase;
import org.tron.core.db.StorageRowStore;
import org.tron.core.db.TransactionHistoryStore;
import org.tron.core.db.TransactionStore;
import org.tron.core.db.TransactionTrace;
import org.tron.core.db.VotesStore;
import org.tron.core.db.WitnessScheduleStore;
import org.tron.core.db.WitnessStore;
import org.tron.core.db.api.AssetUpdateHelper;
import org.tron.core.db2.core.ISession;
import org.tron.core.db2.core.ITronChainBase;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.BadBlockException;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.BadNumberBlockException;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractSizeNotEqualToOneException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.DupTransactionException;
import org.tron.core.exception.HeaderNotFound;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.exception.NonCommonBlockException;
import org.tron.core.exception.ReceiptCheckErrException;
import org.tron.core.exception.TaposException;
import org.tron.core.exception.TooBigTransactionException;
import org.tron.core.exception.TooBigTransactionResultException;
import org.tron.core.exception.TransactionExpirationException;
import org.tron.core.exception.UnLinkedBlockException;
import org.tron.core.exception.VMIllegalException;
import org.tron.core.exception.ValidateScheduleException;
import org.tron.core.exception.ValidateSignatureException;
import org.tron.core.services.WitnessService;
import org.tron.core.witness.ProposalController;
import org.tron.core.witness.WitnessController;
import org.tron.protos.Protocol;

@Component
public class Manager {
    private static final Logger logger = LoggerFactory.getLogger(Manager.class);
    @Autowired
    private AccountStore accountStore;
    @Autowired
    private TransactionStore transactionStore;
    @Autowired
    private BlockStore blockStore;
    @Autowired
    private WitnessStore witnessStore;
    @Autowired
    private AssetIssueStore assetIssueStore;
    @Autowired
    private AssetIssueV2Store assetIssueV2Store;
    @Autowired
    private DynamicPropertiesStore dynamicPropertiesStore;
    @Autowired
    private BlockIndexStore blockIndexStore;
    @Autowired
    private AccountIdIndexStore accountIdIndexStore;
    @Autowired
    private AccountIndexStore accountIndexStore;
    @Autowired
    private WitnessScheduleStore witnessScheduleStore;
    @Autowired
    private RecentBlockStore recentBlockStore;
    @Autowired
    private VotesStore votesStore;
    @Autowired
    private ProposalStore proposalStore;
    @Autowired
    private ExchangeStore exchangeStore;
    @Autowired
    private ExchangeV2Store exchangeV2Store;
    @Autowired
    private TransactionHistoryStore transactionHistoryStore;
    @Autowired
    private CodeStore codeStore;
    @Autowired
    private ContractStore contractStore;
    @Autowired
    private DelegatedResourceStore delegatedResourceStore;
    @Autowired
    private DelegatedResourceAccountIndexStore delegatedResourceAccountIndexStore;
    @Autowired
    private StorageRowStore storageRowStore;
    @Autowired
    private PeersStore peersStore;
    @Autowired
    private KhaosDatabase khaosDb;
    private BlockCapsule genesisBlock;
    @Autowired
    private RevokingDatabase revokingStore;
    private SessionOptional session = SessionOptional.instance();
    private boolean isSyncMode;
    private String netType;
    private WitnessService witnessService;
    private WitnessController witnessController;
    private ProposalController proposalController;
    private ExecutorService validateSignService;
    private Thread repushThread;
    private boolean isRunRepushThread = true;
    private Cache<Sha256Hash, Boolean> transactionIdCache = CacheBuilder.newBuilder().maximumSize(100000L).recordStats().build();
    private ForkController forkController = ForkController.instance();
    private List<TransactionCapsule> pendingTransactions;
    private List<TransactionCapsule> popedTransactions = Collections.synchronizedList(Lists.newArrayList());
    private BlockingQueue<TransactionCapsule> repushTransactions;
    private Runnable repushLoop = () -> {
        while (this.isRunRepushThread) {
            try {
                if (this.isGeneratingBlock()) {
                    TimeUnit.MILLISECONDS.sleep(10L);
                    continue;
                }
                TransactionCapsule tx = this.getRepushTransactions().poll(1L, TimeUnit.SECONDS);
                if (tx == null) continue;
                this.rePush(tx);
            }
            catch (InterruptedException ex) {
                logger.info(ex.getMessage());
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                logger.error("unknown exception happened in repush loop", (Throwable)ex);
            }
            catch (Throwable throwable) {
                logger.error("unknown throwable happened in repush loop", throwable);
            }
        }
    };

    public WitnessStore getWitnessStore() {
        return this.witnessStore;
    }

    public boolean needToUpdateAsset() {
        return this.getDynamicPropertiesStore().getTokenUpdateDone() == 0L;
    }

    public DynamicPropertiesStore getDynamicPropertiesStore() {
        return this.dynamicPropertiesStore;
    }

    public void setDynamicPropertiesStore(DynamicPropertiesStore dynamicPropertiesStore) {
        this.dynamicPropertiesStore = dynamicPropertiesStore;
    }

    public WitnessScheduleStore getWitnessScheduleStore() {
        return this.witnessScheduleStore;
    }

    public void setWitnessScheduleStore(WitnessScheduleStore witnessScheduleStore) {
        this.witnessScheduleStore = witnessScheduleStore;
    }

    public DelegatedResourceStore getDelegatedResourceStore() {
        return this.delegatedResourceStore;
    }

    public DelegatedResourceAccountIndexStore getDelegatedResourceAccountIndexStore() {
        return this.delegatedResourceAccountIndexStore;
    }

    public CodeStore getCodeStore() {
        return this.codeStore;
    }

    public ContractStore getContractStore() {
        return this.contractStore;
    }

    public VotesStore getVotesStore() {
        return this.votesStore;
    }

    public ProposalStore getProposalStore() {
        return this.proposalStore;
    }

    public ExchangeStore getExchangeStore() {
        return this.exchangeStore;
    }

    public ExchangeV2Store getExchangeV2Store() {
        return this.exchangeV2Store;
    }

    public ExchangeStore getExchangeStoreFinal() {
        if (this.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            return this.getExchangeStore();
        }
        return this.getExchangeV2Store();
    }

    public void putExchangeCapsule(ExchangeCapsule exchangeCapsule) {
        if (this.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            this.getExchangeStore().put(exchangeCapsule.createDbKey(), exchangeCapsule);
            ExchangeCapsule exchangeCapsuleV2 = new ExchangeCapsule(exchangeCapsule.getData());
            exchangeCapsuleV2.resetTokenWithID(this);
            this.getExchangeV2Store().put(exchangeCapsuleV2.createDbKey(), exchangeCapsuleV2);
        } else {
            this.getExchangeV2Store().put(exchangeCapsule.createDbKey(), exchangeCapsule);
        }
    }

    public List<TransactionCapsule> getPendingTransactions() {
        return this.pendingTransactions;
    }

    public List<TransactionCapsule> getPoppedTransactions() {
        return this.popedTransactions;
    }

    public BlockingQueue<TransactionCapsule> getRepushTransactions() {
        return this.repushTransactions;
    }

    public List<ByteString> getWitnesses() {
        return this.witnessController.getActiveWitnesses();
    }

    public void addWitness(ByteString address) {
        List<ByteString> witnessAddresses = this.witnessController.getActiveWitnesses();
        witnessAddresses.add(address);
        this.witnessController.setActiveWitnesses(witnessAddresses);
    }

    public BlockCapsule getHead() throws HeaderNotFound {
        List<BlockCapsule> blocks = this.getBlockStore().getBlockByLatestNum(1L);
        if (CollectionUtils.isNotEmpty(blocks)) {
            return blocks.get(0);
        }
        logger.info("Header block Not Found");
        throw new HeaderNotFound("Header block Not Found");
    }

    public synchronized BlockCapsule.BlockId getHeadBlockId() {
        return new BlockCapsule.BlockId(this.getDynamicPropertiesStore().getLatestBlockHeaderHash(), this.getDynamicPropertiesStore().getLatestBlockHeaderNumber());
    }

    public long getHeadBlockNum() {
        return this.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
    }

    public long getHeadBlockTimeStamp() {
        return this.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
    }

    public void clearAndWriteNeighbours(Set<Node> nodes) {
        this.peersStore.put("neighbours".getBytes(), nodes);
    }

    public Set<Node> readNeighbours() {
        return this.peersStore.get("neighbours".getBytes());
    }

    public void stopRepushThread() {
        this.isRunRepushThread = false;
    }

    @PostConstruct
    public void init() {
        this.revokingStore.disable();
        this.revokingStore.check();
        this.setWitnessController(WitnessController.createInstance(this));
        this.setProposalController(ProposalController.createInstance(this));
        this.pendingTransactions = Collections.synchronizedList(Lists.newArrayList());
        this.repushTransactions = new LinkedBlockingQueue<TransactionCapsule>();
        this.initGenesis();
        try {
            this.khaosDb.start(this.getBlockById(this.getDynamicPropertiesStore().getLatestBlockHeaderHash()));
        }
        catch (ItemNotFoundException e) {
            logger.error("Can not find Dynamic highest block from DB! \nnumber={} \nhash={}", (Object)this.getDynamicPropertiesStore().getLatestBlockHeaderNumber(), (Object)this.getDynamicPropertiesStore().getLatestBlockHeaderHash());
            logger.error("Please delete database directory({}) and restart", (Object)Args.getInstance().getOutputDirectory());
            System.exit(1);
        }
        catch (BadItemException e) {
            e.printStackTrace();
            logger.error("DB data broken!");
            logger.error("Please delete database directory({}) and restart", (Object)Args.getInstance().getOutputDirectory());
            System.exit(1);
        }
        this.forkController.init(this);
        if (Args.getInstance().isNeedToUpdateAsset() && this.needToUpdateAsset()) {
            new AssetUpdateHelper(this).doWork();
        }
        this.revokingStore.enable();
        this.validateSignService = Executors.newFixedThreadPool(Args.getInstance().getValidateSignThreadNum());
        this.repushThread = new Thread(this.repushLoop);
        this.repushThread.start();
    }

    public BlockCapsule.BlockId getGenesisBlockId() {
        return this.genesisBlock.getBlockId();
    }

    public BlockCapsule getGenesisBlock() {
        return this.genesisBlock;
    }

    public void initGenesis() {
        this.genesisBlock = BlockUtil.newGenesisBlockCapsule();
        if (this.containBlock(this.genesisBlock.getBlockId())) {
            Args.getInstance().setChainId(this.genesisBlock.getBlockId().toString());
        } else if (this.hasBlocks()) {
            logger.error("genesis block modify, please delete database directory({}) and restart", (Object)Args.getInstance().getOutputDirectory());
            System.exit(1);
        } else {
            logger.info("create genesis block");
            Args.getInstance().setChainId(this.genesisBlock.getBlockId().toString());
            this.blockStore.put(this.genesisBlock.getBlockId().getBytes(), this.genesisBlock);
            this.blockIndexStore.put(this.genesisBlock.getBlockId());
            logger.info("save block: " + this.genesisBlock);
            this.dynamicPropertiesStore.saveLatestBlockHeaderNumber(0L);
            this.dynamicPropertiesStore.saveLatestBlockHeaderHash(this.genesisBlock.getBlockId().getByteString());
            this.dynamicPropertiesStore.saveLatestBlockHeaderTimestamp(this.genesisBlock.getTimeStamp());
            this.initAccount();
            this.initWitness();
            this.witnessController.initWits();
            this.khaosDb.start(this.genesisBlock);
            this.updateRecentBlock(this.genesisBlock);
        }
    }

    public void initAccount() {
        Args args = Args.getInstance();
        GenesisBlock genesisBlockArg = args.getGenesisBlock();
        genesisBlockArg.getAssets().forEach(account -> {
            account.setAccountType("Normal");
            AccountCapsule accountCapsule = new AccountCapsule(account.getAccountName(), ByteString.copyFrom((byte[])account.getAddress()), account.getAccountType(), account.getBalance());
            this.accountStore.put(account.getAddress(), accountCapsule);
            this.accountIdIndexStore.put(accountCapsule);
            this.accountIndexStore.put(accountCapsule);
        });
    }

    private void initWitness() {
        Args args = Args.getInstance();
        GenesisBlock genesisBlockArg = args.getGenesisBlock();
        genesisBlockArg.getWitnesses().forEach(key -> {
            byte[] keyAddress = key.getAddress();
            ByteString address = ByteString.copyFrom((byte[])keyAddress);
            AccountCapsule accountCapsule = !this.accountStore.has(keyAddress) ? new AccountCapsule(ByteString.EMPTY, address, Protocol.AccountType.AssetIssue, 0L) : (AccountCapsule)this.accountStore.getUnchecked(keyAddress);
            accountCapsule.setIsWitness(true);
            this.accountStore.put(keyAddress, accountCapsule);
            WitnessCapsule witnessCapsule = new WitnessCapsule(address, key.getVoteCount(), key.getUrl());
            witnessCapsule.setIsJobs(true);
            this.witnessStore.put(keyAddress, witnessCapsule);
        });
    }

    public AccountStore getAccountStore() {
        return this.accountStore;
    }

    public void adjustBalance(byte[] accountAddress, long amount) throws BalanceInsufficientException {
        AccountCapsule account = (AccountCapsule)this.getAccountStore().getUnchecked(accountAddress);
        this.adjustBalance(account, amount);
    }

    public void adjustBalance(AccountCapsule account, long amount) throws BalanceInsufficientException {
        long balance = account.getBalance();
        if (amount == 0L) {
            return;
        }
        if (amount < 0L && balance < -amount) {
            throw new BalanceInsufficientException(StringUtil.createReadableString(account.createDbKey()) + " insufficient balance");
        }
        account.setBalance(Math.addExact(balance, amount));
        this.getAccountStore().put(account.getAddress().toByteArray(), account);
    }

    public void adjustAllowance(byte[] accountAddress, long amount) throws BalanceInsufficientException {
        AccountCapsule account = (AccountCapsule)this.getAccountStore().getUnchecked(accountAddress);
        long allowance = account.getAllowance();
        if (amount == 0L) {
            return;
        }
        if (amount < 0L && allowance < -amount) {
            throw new BalanceInsufficientException(StringUtil.createReadableString(accountAddress) + " insufficient balance");
        }
        account.setAllowance(allowance + amount);
        this.getAccountStore().put(account.createDbKey(), account);
    }

    void validateTapos(TransactionCapsule transactionCapsule) throws TaposException {
        byte[] refBlockHash = transactionCapsule.getInstance().getRawData().getRefBlockHash().toByteArray();
        byte[] refBlockNumBytes = transactionCapsule.getInstance().getRawData().getRefBlockBytes().toByteArray();
        try {
            byte[] blockHash = this.recentBlockStore.get(refBlockNumBytes).getData();
            if (Arrays.equals(blockHash, refBlockHash)) {
                return;
            }
            String str = String.format("Tapos failed, different block hash, %s, %s , recent block %s, solid block %s head block %s", ByteArray.toLong(refBlockNumBytes), Hex.toHexString((byte[])refBlockHash), Hex.toHexString((byte[])blockHash), this.getSolidBlockId().getString(), this.getHeadBlockId().getString()).toString();
            logger.info(str);
            throw new TaposException(str);
        }
        catch (ItemNotFoundException e) {
            String str = String.format("Tapos failed, block not found, ref block %s, %s , solid block %s head block %s", ByteArray.toLong(refBlockNumBytes), Hex.toHexString((byte[])refBlockHash), this.getSolidBlockId().getString(), this.getHeadBlockId().getString()).toString();
            logger.info(str);
            throw new TaposException(str);
        }
    }

    void validateCommon(TransactionCapsule transactionCapsule) throws TransactionExpirationException, TooBigTransactionException {
        long headBlockTime;
        if ((long)transactionCapsule.getData().length > 512000L) {
            throw new TooBigTransactionException("too big transaction, the size is " + transactionCapsule.getData().length + " bytes");
        }
        long transactionExpiration = transactionCapsule.getExpiration();
        if (transactionExpiration <= (headBlockTime = this.getHeadBlockTimeStamp()) || transactionExpiration > headBlockTime + 86400000L) {
            throw new TransactionExpirationException("transaction expiration, transaction expiration time is " + transactionExpiration + ", but headBlockTime is " + headBlockTime);
        }
    }

    void validateDup(TransactionCapsule transactionCapsule) throws DupTransactionException {
        if (this.getTransactionStore().getUnchecked(transactionCapsule.getTransactionId().getBytes()) != null) {
            logger.debug(ByteArray.toHexString(transactionCapsule.getTransactionId().getBytes()));
            throw new DupTransactionException("dup trans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushTransaction(TransactionCapsule trx) throws ValidateSignatureException, ContractValidateException, ContractExeException, AccountResourceInsufficientException, DupTransactionException, TaposException, TooBigTransactionException, TransactionExpirationException, ReceiptCheckErrException, VMIllegalException, TooBigTransactionResultException {
        if (!trx.validateSignature()) {
            throw new ValidateSignatureException("trans sig validate failed");
        }
        Manager manager = this;
        synchronized (manager) {
            if (!this.session.valid()) {
                this.session.setValue(this.revokingStore.buildSession());
            }
            try (ISession tmpSession = this.revokingStore.buildSession();){
                this.processTransaction(trx, null);
                this.pendingTransactions.add(trx);
                tmpSession.merge();
            }
        }
        return true;
    }

    public void consumeBandwidth(TransactionCapsule trx, TransactionTrace trace) throws ContractValidateException, AccountResourceInsufficientException, TooBigTransactionResultException {
        BandwidthProcessor processor = new BandwidthProcessor(this);
        processor.consume(trx, trace);
    }

    public synchronized void eraseBlock() {
        this.session.reset();
        try {
            BlockCapsule oldHeadBlock = this.getBlockById(this.getDynamicPropertiesStore().getLatestBlockHeaderHash());
            logger.info("begin to erase block:" + oldHeadBlock);
            this.khaosDb.pop();
            this.revokingStore.fastPop();
            logger.info("end to erase block:" + oldHeadBlock);
            this.popedTransactions.addAll(oldHeadBlock.getTransactions());
        }
        catch (BadItemException | ItemNotFoundException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void pushVerifiedBlock(BlockCapsule block) throws ContractValidateException, ContractExeException, ValidateSignatureException, AccountResourceInsufficientException, TransactionExpirationException, TooBigTransactionException, DupTransactionException, TaposException, ValidateScheduleException, ReceiptCheckErrException, VMIllegalException, TooBigTransactionResultException, UnLinkedBlockException, NonCommonBlockException, BadNumberBlockException, BadBlockException {
        block.generatedByMyself = true;
        long start = System.currentTimeMillis();
        this.pushBlock(block);
        logger.info("push block cost:{}ms, blockNum:{}, blockHash:{}, trx count:{}", new Object[]{System.currentTimeMillis() - start, block.getNum(), block.getBlockId(), block.getTransactions().size()});
    }

    private void applyBlock(BlockCapsule block) throws ContractValidateException, ContractExeException, ValidateSignatureException, AccountResourceInsufficientException, TransactionExpirationException, TooBigTransactionException, DupTransactionException, TaposException, ValidateScheduleException, ReceiptCheckErrException, VMIllegalException, TooBigTransactionResultException {
        this.processBlock(block);
        this.blockStore.put(block.getBlockId().getBytes(), block);
        this.blockIndexStore.put(block.getBlockId());
        this.updateFork();
        if (System.currentTimeMillis() - block.getTimeStamp() >= 60000L) {
            this.revokingStore.setMaxFlushCount(500);
        } else {
            this.revokingStore.setMaxFlushCount(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void switchFork(BlockCapsule newHead) throws ValidateSignatureException, ContractValidateException, ContractExeException, ValidateScheduleException, AccountResourceInsufficientException, TaposException, TooBigTransactionException, TooBigTransactionResultException, DupTransactionException, TransactionExpirationException, NonCommonBlockException, ReceiptCheckErrException, VMIllegalException {
        Pair<LinkedList<KhaosDatabase.KhaosBlock>, LinkedList<KhaosDatabase.KhaosBlock>> binaryTree;
        try {
            binaryTree = this.khaosDb.getBranch((Sha256Hash)newHead.getBlockId(), this.getDynamicPropertiesStore().getLatestBlockHeaderHash());
        }
        catch (NonCommonBlockException e) {
            logger.info("there is not the most recent common ancestor, need to remove all blocks in the fork chain.");
            BlockCapsule tmp = newHead;
            while (true) {
                if (tmp == null) {
                    throw e;
                }
                this.khaosDb.removeBlk(tmp.getBlockId());
                tmp = this.khaosDb.getBlock(tmp.getParentHash());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)binaryTree.getValue()))) {
            while (!this.getDynamicPropertiesStore().getLatestBlockHeaderHash().equals(((KhaosDatabase.KhaosBlock)((LinkedList)binaryTree.getValue()).peekLast()).getParentHash())) {
                this.eraseBlock();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)binaryTree.getKey()))) {
            ArrayList first = new ArrayList((Collection)binaryTree.getKey());
            Collections.reverse(first);
            for (KhaosDatabase.KhaosBlock item : first) {
                Exception exception = null;
                try {
                    ISession tmpSession = this.revokingStore.buildSession();
                    Object object = null;
                    try {
                        this.applyBlock(item.getBlk());
                        tmpSession.commit();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (tmpSession == null) continue;
                        if (object != null) {
                            try {
                                tmpSession.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        tmpSession.close();
                    }
                }
                catch (AccountResourceInsufficientException | ContractExeException | ContractValidateException | DupTransactionException | ReceiptCheckErrException | TaposException | TooBigTransactionException | TooBigTransactionResultException | TransactionExpirationException | VMIllegalException | ValidateScheduleException | ValidateSignatureException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    exception = e;
                    throw e;
                }
                finally {
                    if (exception == null) continue;
                    logger.warn("switch back because exception thrown while switching forks. " + exception.getMessage(), (Throwable)exception);
                    first.forEach(khaosBlock -> this.khaosDb.removeBlk(khaosBlock.getBlk().getBlockId()));
                    this.khaosDb.setHead((KhaosDatabase.KhaosBlock)((LinkedList)binaryTree.getValue()).peekFirst());
                    while (!this.getDynamicPropertiesStore().getLatestBlockHeaderHash().equals(((KhaosDatabase.KhaosBlock)((LinkedList)binaryTree.getValue()).peekLast()).getParentHash())) {
                        this.eraseBlock();
                    }
                    ArrayList second = new ArrayList((Collection)binaryTree.getValue());
                    Collections.reverse(second);
                    for (KhaosDatabase.KhaosBlock khaosBlock2 : second) {
                        try {
                            ISession tmpSession = this.revokingStore.buildSession();
                            Throwable throwable = null;
                            try {
                                this.applyBlock(khaosBlock2.getBlk());
                                tmpSession.commit();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (tmpSession == null) continue;
                                if (throwable != null) {
                                    try {
                                        tmpSession.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                tmpSession.close();
                            }
                        }
                        catch (AccountResourceInsufficientException | ContractExeException | ContractValidateException | DupTransactionException | TaposException | TooBigTransactionException | TransactionExpirationException | ValidateScheduleException | ValidateSignatureException e) {
                            logger.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public synchronized void pushBlock(BlockCapsule block) throws ValidateSignatureException, ContractValidateException, ContractExeException, UnLinkedBlockException, ValidateScheduleException, AccountResourceInsufficientException, TaposException, TooBigTransactionException, TooBigTransactionResultException, DupTransactionException, TransactionExpirationException, BadNumberBlockException, BadBlockException, NonCommonBlockException, ReceiptCheckErrException, VMIllegalException {
        long start = System.currentTimeMillis();
        try (PendingManager pm = new PendingManager(this);){
            if (!block.generatedByMyself) {
                if (!block.validateSignature()) {
                    logger.warn("The signature is not validated.");
                    throw new BadBlockException("The signature is not validated");
                }
                if (!block.calcMerkleRoot().equals(block.getMerkleRoot())) {
                    logger.warn("The merkle root doesn't match, Calc result is " + block.calcMerkleRoot() + " , the headers is " + block.getMerkleRoot());
                    throw new BadBlockException("The merkle hash is not validated");
                }
            }
            BlockCapsule newBlock = this.khaosDb.push(block);
            if (this.getDynamicPropertiesStore().getLatestBlockHeaderHash() == null) {
                if (newBlock.getNum() != 0L) {
                    return;
                }
            } else {
                if (newBlock.getNum() <= this.getDynamicPropertiesStore().getLatestBlockHeaderNumber()) {
                    return;
                }
                if (!newBlock.getParentHash().equals(this.getDynamicPropertiesStore().getLatestBlockHeaderHash())) {
                    logger.warn("switch fork! new head num = {}, blockid = {}", (Object)newBlock.getNum(), (Object)newBlock.getBlockId());
                    logger.warn("******** before switchFork ******* push block: " + block.toString() + ", new block:" + newBlock.toString() + ", dynamic head num: " + this.dynamicPropertiesStore.getLatestBlockHeaderNumber() + ", dynamic head hash: " + this.dynamicPropertiesStore.getLatestBlockHeaderHash() + ", dynamic head timestamp: " + this.dynamicPropertiesStore.getLatestBlockHeaderTimestamp() + ", khaosDb head: " + this.khaosDb.getHead() + ", khaosDb miniStore size: " + this.khaosDb.getMiniStore().size() + ", khaosDb unlinkMiniStore size: " + this.khaosDb.getMiniUnlinkedStore().size());
                    this.switchFork(newBlock);
                    logger.info("save block: " + newBlock);
                    logger.warn("******** after switchFork ******* push block: " + block.toString() + ", new block:" + newBlock.toString() + ", dynamic head num: " + this.dynamicPropertiesStore.getLatestBlockHeaderNumber() + ", dynamic head hash: " + this.dynamicPropertiesStore.getLatestBlockHeaderHash() + ", dynamic head timestamp: " + this.dynamicPropertiesStore.getLatestBlockHeaderTimestamp() + ", khaosDb head: " + this.khaosDb.getHead() + ", khaosDb miniStore size: " + this.khaosDb.getMiniStore().size() + ", khaosDb unlinkMiniStore size: " + this.khaosDb.getMiniUnlinkedStore().size());
                    return;
                }
                try (ISession tmpSession = this.revokingStore.buildSession();){
                    this.applyBlock(newBlock);
                    tmpSession.commit();
                }
                catch (Throwable throwable) {
                    logger.error(throwable.getMessage(), throwable);
                    this.khaosDb.removeBlk(block.getBlockId());
                    throw throwable;
                }
            }
            logger.info("save block: " + newBlock);
        }
        logger.info("pushBlock block number:{}, cost/txs:{}/{}", new Object[]{block.getNum(), System.currentTimeMillis() - start, block.getTransactions().size()});
    }

    public void updateDynamicProperties(BlockCapsule block) {
        long slot = 1L;
        if (block.getNum() != 1L) {
            slot = this.witnessController.getSlotAtTime(block.getTimeStamp());
        }
        int i = 1;
        while ((long)i < slot) {
            if (!this.witnessController.getScheduledWitness(i).equals((Object)block.getWitnessAddress())) {
                WitnessCapsule w = (WitnessCapsule)this.witnessStore.getUnchecked(StringUtil.createDbKey(this.witnessController.getScheduledWitness(i)));
                w.setTotalMissed(w.getTotalMissed() + 1L);
                this.witnessStore.put(w.createDbKey(), w);
                logger.info("{} miss a block. totalMissed = {}", (Object)w.createReadableString(), (Object)w.getTotalMissed());
            }
            this.dynamicPropertiesStore.applyBlock(false);
            ++i;
        }
        this.dynamicPropertiesStore.applyBlock(true);
        if (slot <= 0L) {
            logger.warn("missedBlocks [" + slot + "] is illegal");
        }
        logger.info("update head, num = {}", (Object)block.getNum());
        this.dynamicPropertiesStore.saveLatestBlockHeaderHash(block.getBlockId().getByteString());
        this.dynamicPropertiesStore.saveLatestBlockHeaderNumber(block.getNum());
        this.dynamicPropertiesStore.saveLatestBlockHeaderTimestamp(block.getTimeStamp());
        this.revokingStore.setMaxSize((int)(this.dynamicPropertiesStore.getLatestBlockHeaderNumber() - this.dynamicPropertiesStore.getLatestSolidifiedBlockNum() + 1L));
        this.khaosDb.setMaxSize((int)(this.dynamicPropertiesStore.getLatestBlockHeaderNumber() - this.dynamicPropertiesStore.getLatestSolidifiedBlockNum() + 1L));
    }

    public LinkedList<BlockCapsule.BlockId> getBlockChainHashesOnFork(BlockCapsule.BlockId forkBlockHash) throws NonCommonBlockException {
        Pair<LinkedList<KhaosDatabase.KhaosBlock>, LinkedList<KhaosDatabase.KhaosBlock>> branch = this.khaosDb.getBranch(this.getDynamicPropertiesStore().getLatestBlockHeaderHash(), (Sha256Hash)forkBlockHash);
        LinkedList blockCapsules = (LinkedList)branch.getValue();
        if (blockCapsules.isEmpty()) {
            logger.info("empty branch {}", (Object)forkBlockHash);
            return Lists.newLinkedList();
        }
        LinkedList result = blockCapsules.stream().map(KhaosDatabase.KhaosBlock::getBlk).map(BlockCapsule::getBlockId).collect(Collectors.toCollection(LinkedList::new));
        result.add(((KhaosDatabase.KhaosBlock)blockCapsules.peekLast()).getBlk().getParentBlockId());
        return result;
    }

    public boolean containBlock(Sha256Hash blockHash) {
        try {
            return this.khaosDb.containBlockInMiniStore(blockHash) != false || this.blockStore.get(blockHash.getBytes()) != null;
        }
        catch (ItemNotFoundException e) {
            return false;
        }
        catch (BadItemException e) {
            return false;
        }
    }

    public boolean containBlockInMainChain(BlockCapsule.BlockId blockId) {
        try {
            return this.blockStore.get(blockId.getBytes()) != null;
        }
        catch (ItemNotFoundException e) {
            return false;
        }
        catch (BadItemException e) {
            return false;
        }
    }

    public void setBlockReference(TransactionCapsule trans) {
        byte[] headHash = this.getDynamicPropertiesStore().getLatestBlockHeaderHash().getBytes();
        long headNum = this.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
        trans.setReference(headNum, headHash);
    }

    public BlockCapsule getBlockById(Sha256Hash hash) throws BadItemException, ItemNotFoundException {
        return this.khaosDb.containBlock(hash) != false ? this.khaosDb.getBlock(hash) : (BlockCapsule)this.blockStore.get(hash.getBytes());
    }

    public boolean hasBlocks() {
        return this.blockStore.iterator().hasNext() || this.khaosDb.hasData();
    }

    public boolean processTransaction(TransactionCapsule trxCap, BlockCapsule blockCap) throws ValidateSignatureException, ContractValidateException, ContractExeException, AccountResourceInsufficientException, TransactionExpirationException, TooBigTransactionException, TooBigTransactionResultException, DupTransactionException, TaposException, ReceiptCheckErrException, VMIllegalException {
        if (trxCap == null) {
            return false;
        }
        this.validateTapos(trxCap);
        this.validateCommon(trxCap);
        if (trxCap.getInstance().getRawData().getContractList().size() != 1) {
            throw new ContractSizeNotEqualToOneException("act size should be exactly 1, this is extend feature");
        }
        this.validateDup(trxCap);
        if (!trxCap.validateSignature()) {
            throw new ValidateSignatureException("trans sig validate failed");
        }
        TransactionTrace trace = new TransactionTrace(trxCap, this);
        trxCap.setTrxTrace(trace);
        this.consumeBandwidth(trxCap, trace);
        VMConfig.initVmHardFork();
        VMConfig.initAllowTvmTransferTrc10(this.dynamicPropertiesStore.getAllowTvmTransferTrc10());
        trace.init(blockCap);
        trace.checkIsConstant();
        trace.exec();
        if (Objects.nonNull(blockCap)) {
            trace.setResult();
            if (!blockCap.getInstance().getBlockHeader().getWitnessSignature().isEmpty()) {
                if (trace.checkNeedRetry()) {
                    String txId = Hex.toHexString((byte[])trxCap.getTransactionId().getBytes());
                    logger.info("Retry for tx id: {}", (Object)txId);
                    trace.init(blockCap);
                    trace.checkIsConstant();
                    trace.exec();
                    trace.setResult();
                    logger.info("Retry result for tx id: {}, tx resultCode in receipt: {}", (Object)txId, (Object)trace.getReceipt().getResult());
                }
                trace.check();
            }
        }
        trace.finalization();
        if (Objects.nonNull(blockCap) && this.getDynamicPropertiesStore().supportVM()) {
            trxCap.setResult(trace.getRuntime());
        }
        this.transactionStore.put(trxCap.getTransactionId().getBytes(), trxCap);
        TransactionInfoCapsule transactionInfo = TransactionInfoCapsule.buildInstance(trxCap, blockCap, trace);
        this.transactionHistoryStore.put(trxCap.getTransactionId().getBytes(), transactionInfo);
        return true;
    }

    public BlockCapsule.BlockId getBlockIdByNum(long num) throws ItemNotFoundException {
        return this.blockIndexStore.get(num);
    }

    public BlockCapsule getBlockByNum(long num) throws ItemNotFoundException, BadItemException {
        return this.getBlockById(this.getBlockIdByNum(num));
    }

    public synchronized BlockCapsule generateBlock(WitnessCapsule witnessCapsule, long when, byte[] privateKey, Boolean lastHeadBlockIsMaintenanceBefore) throws ValidateSignatureException, ContractValidateException, ContractExeException, UnLinkedBlockException, ValidateScheduleException, AccountResourceInsufficientException {
        if (!this.witnessController.validateWitnessSchedule(witnessCapsule.getAddress(), when)) {
            logger.info("It's not my turn, and the first block after the maintenance period has just been processed");
            logger.info("when:{},lastHeadBlockIsMaintenanceBefore:{},lastHeadBlockIsMaintenanceAfter:{}", new Object[]{when, lastHeadBlockIsMaintenanceBefore, this.lastHeadBlockIsMaintenance()});
            return null;
        }
        long timestamp = this.dynamicPropertiesStore.getLatestBlockHeaderTimestamp();
        long number = this.dynamicPropertiesStore.getLatestBlockHeaderNumber();
        Sha256Hash preHash = this.dynamicPropertiesStore.getLatestBlockHeaderHash();
        if (when < timestamp) {
            throw new IllegalArgumentException("generate block timestamp is invalid.");
        }
        long postponedTrxCount = 0L;
        BlockCapsule blockCapsule = new BlockCapsule(number + 1L, preHash, when, witnessCapsule.getAddress());
        blockCapsule.generatedByMyself = true;
        this.session.reset();
        this.session.setValue(this.revokingStore.buildSession());
        Iterator<TransactionCapsule> iterator = this.pendingTransactions.iterator();
        while (iterator.hasNext() || this.repushTransactions.size() > 0) {
            TransactionCapsule trx;
            boolean fromPending = false;
            if (iterator.hasNext()) {
                fromPending = true;
                trx = iterator.next();
            } else {
                trx = (TransactionCapsule)this.repushTransactions.poll();
            }
            if ((double)(DateTime.now().getMillis() - when) > 1500.0 * (double)Args.getInstance().getBlockProducedTimeOut() / 100.0) {
                logger.warn("Processing transaction time exceeds the 50% producing time\u3002");
                break;
            }
            if ((long)blockCapsule.getInstance().getSerializedSize() + trx.getSerializedSize() + 3L > 2000000L) {
                ++postponedTrxCount;
                continue;
            }
            try {
                ISession tmpSeesion = this.revokingStore.buildSession();
                Throwable throwable = null;
                try {
                    this.processTransaction(trx, blockCapsule);
                    tmpSeesion.merge();
                    blockCapsule.addTransaction(trx);
                    if (!fromPending) continue;
                    iterator.remove();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tmpSeesion == null) continue;
                    if (throwable != null) {
                        try {
                            tmpSeesion.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tmpSeesion.close();
                }
            }
            catch (ContractExeException e) {
                logger.info("contract not processed during execute");
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (ContractValidateException e) {
                logger.info("contract not processed during validate");
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (TaposException e) {
                logger.info("contract not processed during TaposException");
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (DupTransactionException e) {
                logger.info("contract not processed during DupTransactionException");
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (TooBigTransactionException e) {
                logger.info("contract not processed during TooBigTransactionException");
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (TooBigTransactionResultException e) {
                logger.info("contract not processed during TooBigTransactionResultException");
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (TransactionExpirationException e) {
                logger.info("contract not processed during TransactionExpirationException");
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (AccountResourceInsufficientException e) {
                logger.info("contract not processed during AccountResourceInsufficientException");
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (ValidateSignatureException e) {
                logger.info("contract not processed during ValidateSignatureException");
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (ReceiptCheckErrException e) {
                logger.info("OutOfSlotTime exception: {}", (Object)e.getMessage());
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (VMIllegalException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        this.session.reset();
        if (postponedTrxCount > 0L) {
            logger.info("{} transactions over the block size limit", (Object)postponedTrxCount);
        }
        logger.info("postponedTrxCount[" + postponedTrxCount + "],TrxLeft[" + this.pendingTransactions.size() + "],repushTrxCount[" + this.repushTransactions.size() + "]");
        blockCapsule.setMerkleRoot();
        blockCapsule.sign(privateKey);
        try {
            this.pushBlock(blockCapsule);
            return blockCapsule;
        }
        catch (TaposException e) {
            logger.info("contract not processed during TaposException");
        }
        catch (TooBigTransactionException e) {
            logger.info("contract not processed during TooBigTransactionException");
        }
        catch (DupTransactionException e) {
            logger.info("contract not processed during DupTransactionException");
        }
        catch (TransactionExpirationException e) {
            logger.info("contract not processed during TransactionExpirationException");
        }
        catch (BadNumberBlockException e) {
            logger.info("generate block using wrong number");
        }
        catch (BadBlockException e) {
            logger.info("block exception");
        }
        catch (NonCommonBlockException e) {
            logger.info("non common exception");
        }
        catch (ReceiptCheckErrException e) {
            logger.info("OutOfSlotTime exception: {}", (Object)e.getMessage());
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (VMIllegalException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (TooBigTransactionResultException e) {
            logger.info("contract not processed during TooBigTransactionResultException");
        }
        return null;
    }

    public TransactionStore getTransactionStore() {
        return this.transactionStore;
    }

    public TransactionHistoryStore getTransactionHistoryStore() {
        return this.transactionHistoryStore;
    }

    public BlockStore getBlockStore() {
        return this.blockStore;
    }

    public void processBlock(BlockCapsule block) throws ValidateSignatureException, ContractValidateException, ContractExeException, AccountResourceInsufficientException, TaposException, TooBigTransactionException, DupTransactionException, TransactionExpirationException, ValidateScheduleException, ReceiptCheckErrException, VMIllegalException, TooBigTransactionResultException {
        if (this.witnessService != null) {
            this.witnessService.processBlock(block);
        }
        if (!this.witnessController.validateWitnessSchedule(block)) {
            throw new ValidateScheduleException("validateWitnessSchedule error");
        }
        for (TransactionCapsule transactionCapsule : block.getTransactions()) {
            transactionCapsule.setBlockNum(block.getNum());
            if (block.generatedByMyself) {
                transactionCapsule.setVerified(true);
            }
            this.processTransaction(transactionCapsule, block);
        }
        boolean needMaint = this.needMaintenance(block.getTimeStamp());
        if (needMaint) {
            if (block.getNum() == 1L) {
                this.dynamicPropertiesStore.updateNextMaintenanceTime(block.getTimeStamp());
            } else {
                this.processMaintenance(block);
            }
        }
        if (this.getDynamicPropertiesStore().getAllowAdaptiveEnergy() == 1L) {
            this.updateAdaptiveTotalEnergyLimit();
        }
        this.updateDynamicProperties(block);
        this.updateSignedWitness(block);
        this.updateLatestSolidifiedBlock();
        this.updateTransHashCache(block);
        this.updateMaintenanceState(needMaint);
        this.updateRecentBlock(block);
    }

    public void updateAdaptiveTotalEnergyLimit() {
        long totalEnergyAverageUsage = this.getDynamicPropertiesStore().getTotalEnergyAverageUsage();
        long targetTotalEnergyLimit = this.getDynamicPropertiesStore().getTotalEnergyTargetLimit();
        long totalEnergyCurrentLimit = this.getDynamicPropertiesStore().getTotalEnergyCurrentLimit();
        long result = totalEnergyAverageUsage > targetTotalEnergyLimit ? totalEnergyCurrentLimit * 99L / 100L : totalEnergyCurrentLimit * 1000L / 999L;
        result = Math.min(Math.max(result, this.getDynamicPropertiesStore().getTotalEnergyLimit()), this.getDynamicPropertiesStore().getTotalEnergyLimit() * 1000L);
        this.getDynamicPropertiesStore().saveTotalEnergyCurrentLimit(result);
        logger.debug("adjust totalEnergyCurrentLimit, old[" + totalEnergyCurrentLimit + "], new[" + result + "]");
    }

    private void updateTransHashCache(BlockCapsule block) {
        for (TransactionCapsule transactionCapsule : block.getTransactions()) {
            this.transactionIdCache.put((Object)transactionCapsule.getTransactionId(), (Object)true);
        }
    }

    public void updateRecentBlock(BlockCapsule block) {
        this.recentBlockStore.put(ByteArray.subArray(ByteArray.fromLong(block.getNum()), 6, 8), new BytesCapsule(ByteArray.subArray(block.getBlockId().getBytes(), 8, 16)));
    }

    public void updateLatestSolidifiedBlock() {
        List numbers = this.witnessController.getActiveWitnesses().stream().map(address -> this.witnessController.getWitnesseByAddress((ByteString)address).getLatestBlockNum()).sorted().collect(Collectors.toList());
        long size = this.witnessController.getActiveWitnesses().size();
        int solidifiedPosition = (int)((double)size * 0.30000000000000004);
        if (solidifiedPosition < 0) {
            logger.warn("updateLatestSolidifiedBlock error, solidifiedPosition:{},wits.size:{}", (Object)solidifiedPosition, (Object)size);
            return;
        }
        long latestSolidifiedBlockNum = (Long)numbers.get(solidifiedPosition);
        if (latestSolidifiedBlockNum < this.getDynamicPropertiesStore().getLatestSolidifiedBlockNum()) {
            logger.warn("latestSolidifiedBlockNum = 0,LatestBlockNum:{}", numbers);
            return;
        }
        this.getDynamicPropertiesStore().saveLatestSolidifiedBlockNum(latestSolidifiedBlockNum);
        logger.info("update solid block, num = {}", (Object)latestSolidifiedBlockNum);
    }

    public void updateFork() {
        try {
            long latestSolidifiedBlockNum = this.dynamicPropertiesStore.getLatestSolidifiedBlockNum();
            BlockCapsule solidifiedBlock = this.getBlockByNum(latestSolidifiedBlockNum);
            this.forkController.update(solidifiedBlock);
        }
        catch (BadItemException | ItemNotFoundException e) {
            logger.error("solidified block not found");
        }
    }

    public long getSyncBeginNumber() {
        logger.info("headNumber:" + this.dynamicPropertiesStore.getLatestBlockHeaderNumber());
        logger.info("syncBeginNumber:" + (this.dynamicPropertiesStore.getLatestBlockHeaderNumber() - (long)this.revokingStore.size()));
        logger.info("solidBlockNumber:" + this.dynamicPropertiesStore.getLatestSolidifiedBlockNum());
        return this.dynamicPropertiesStore.getLatestBlockHeaderNumber() - (long)this.revokingStore.size();
    }

    public BlockCapsule.BlockId getSolidBlockId() {
        try {
            long num = this.dynamicPropertiesStore.getLatestSolidifiedBlockNum();
            return this.getBlockIdByNum(num);
        }
        catch (Exception e) {
            return this.getGenesisBlockId();
        }
    }

    public boolean needMaintenance(long blockTime) {
        return this.dynamicPropertiesStore.getNextMaintenanceTime() <= blockTime;
    }

    private void processMaintenance(BlockCapsule block) {
        this.proposalController.processProposals();
        this.witnessController.updateWitness();
        this.dynamicPropertiesStore.updateNextMaintenanceTime(block.getTimeStamp());
        this.forkController.reset(block);
    }

    public void updateSignedWitness(BlockCapsule block) {
        WitnessCapsule witnessCapsule = (WitnessCapsule)this.witnessStore.getUnchecked(block.getInstance().getBlockHeader().getRawData().getWitnessAddress().toByteArray());
        witnessCapsule.setTotalProduced(witnessCapsule.getTotalProduced() + 1L);
        witnessCapsule.setLatestBlockNum(block.getNum());
        witnessCapsule.setLatestSlotNum(this.witnessController.getAbSlotAtTime(block.getTimeStamp()));
        WitnessCapsule wit = this.witnessController.getWitnesseByAddress(block.getWitnessAddress());
        if (wit != null) {
            wit.setTotalProduced(witnessCapsule.getTotalProduced() + 1L);
            wit.setLatestBlockNum(block.getNum());
            wit.setLatestSlotNum(this.witnessController.getAbSlotAtTime(block.getTimeStamp()));
        }
        this.getWitnessStore().put(witnessCapsule.getAddress().toByteArray(), witnessCapsule);
        try {
            this.adjustAllowance(witnessCapsule.getAddress().toByteArray(), this.getDynamicPropertiesStore().getWitnessPayPerBlock());
        }
        catch (BalanceInsufficientException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        logger.debug("updateSignedWitness. witness address:{}, blockNum:{}, totalProduced:{}", new Object[]{witnessCapsule.createReadableString(), block.getNum(), witnessCapsule.getTotalProduced()});
    }

    public void updateMaintenanceState(boolean needMaint) {
        if (needMaint) {
            this.getDynamicPropertiesStore().saveStateFlag(1);
        } else {
            this.getDynamicPropertiesStore().saveStateFlag(0);
        }
    }

    public boolean lastHeadBlockIsMaintenance() {
        return this.getDynamicPropertiesStore().getStateFlag() == 1;
    }

    public long getSkipSlotInMaintenance() {
        return this.getDynamicPropertiesStore().getMaintenanceSkipSlots();
    }

    public AssetIssueStore getAssetIssueStore() {
        return this.assetIssueStore;
    }

    public AssetIssueV2Store getAssetIssueV2Store() {
        return this.assetIssueV2Store;
    }

    public AssetIssueStore getAssetIssueStoreFinal() {
        if (this.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            return this.getAssetIssueStore();
        }
        return this.getAssetIssueV2Store();
    }

    public void setAssetIssueStore(AssetIssueStore assetIssueStore) {
        this.assetIssueStore = assetIssueStore;
    }

    public void setBlockIndexStore(BlockIndexStore indexStore) {
        this.blockIndexStore = indexStore;
    }

    public AccountIdIndexStore getAccountIdIndexStore() {
        return this.accountIdIndexStore;
    }

    public void setAccountIdIndexStore(AccountIdIndexStore indexStore) {
        this.accountIdIndexStore = indexStore;
    }

    public AccountIndexStore getAccountIndexStore() {
        return this.accountIndexStore;
    }

    public void setAccountIndexStore(AccountIndexStore indexStore) {
        this.accountIndexStore = indexStore;
    }

    public void closeAllStore() {
        logger.info("******** begin to close db ********");
        this.closeOneStore(this.accountStore);
        this.closeOneStore(this.blockStore);
        this.closeOneStore(this.blockIndexStore);
        this.closeOneStore(this.accountIdIndexStore);
        this.closeOneStore(this.accountIndexStore);
        this.closeOneStore(this.witnessStore);
        this.closeOneStore(this.witnessScheduleStore);
        this.closeOneStore(this.assetIssueStore);
        this.closeOneStore(this.dynamicPropertiesStore);
        this.closeOneStore(this.transactionStore);
        this.closeOneStore(this.codeStore);
        this.closeOneStore(this.contractStore);
        this.closeOneStore(this.storageRowStore);
        this.closeOneStore(this.exchangeStore);
        this.closeOneStore(this.peersStore);
        this.closeOneStore(this.proposalStore);
        this.closeOneStore(this.recentBlockStore);
        this.closeOneStore(this.transactionHistoryStore);
        this.closeOneStore(this.votesStore);
        this.closeOneStore(this.delegatedResourceStore);
        this.closeOneStore(this.assetIssueV2Store);
        this.closeOneStore(this.exchangeV2Store);
        logger.info("******** end to close db ********");
    }

    public void closeOneStore(ITronChainBase database) {
        logger.info("******** begin to close " + database.getName() + " ********");
        try {
            database.close();
        }
        catch (Exception e) {
            logger.info("failed to close  " + database.getName() + ". " + e);
        }
        finally {
            logger.info("******** end to close " + database.getName() + " ********");
        }
    }

    public boolean isTooManyPending() {
        return this.getPendingTransactions().size() + this.getRepushTransactions().size() > 2000;
    }

    public boolean isGeneratingBlock() {
        if (Args.getInstance().isWitness()) {
            return this.witnessController.isGeneratingBlock();
        }
        return false;
    }

    public synchronized void preValidateTransactionSign(BlockCapsule block) throws InterruptedException, ValidateSignatureException {
        logger.info("PreValidate Transaction Sign, size:" + block.getTransactions().size() + ",block num:" + block.getNum());
        int transSize = block.getTransactions().size();
        CountDownLatch countDownLatch = new CountDownLatch(transSize);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(transSize);
        for (TransactionCapsule transactionCapsule : block.getTransactions()) {
            Future<Boolean> future = this.validateSignService.submit(new ValidateSignTask(transactionCapsule, countDownLatch));
            futures.add(future);
        }
        countDownLatch.await();
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw new ValidateSignatureException(e.getCause().getMessage());
            }
        }
    }

    public void rePush(TransactionCapsule tx) {
        try {
            if (this.transactionStore.get(tx.getTransactionId().getBytes()) != null) {
                return;
            }
        }
        catch (BadItemException badItemException) {
            // empty catch block
        }
        try {
            this.pushTransaction(tx);
        }
        catch (ValidateSignatureException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (ContractValidateException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (ContractExeException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (AccountResourceInsufficientException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (DupTransactionException e) {
            logger.debug("pending manager: dup trans", (Throwable)e);
        }
        catch (TaposException e) {
            logger.debug("pending manager: tapos exception", (Throwable)e);
        }
        catch (TooBigTransactionException e) {
            logger.debug("too big transaction");
        }
        catch (TransactionExpirationException e) {
            logger.debug("expiration transaction");
        }
        catch (ReceiptCheckErrException e) {
            logger.debug("outOfSlotTime transaction");
        }
        catch (VMIllegalException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (TooBigTransactionResultException e) {
            logger.debug("too big transaction result");
        }
    }

    public BlockIndexStore getBlockIndexStore() {
        return this.blockIndexStore;
    }

    public StorageRowStore getStorageRowStore() {
        return this.storageRowStore;
    }

    public RevokingDatabase getRevokingStore() {
        return this.revokingStore;
    }

    public SessionOptional getSession() {
        return this.session;
    }

    public boolean isSyncMode() {
        return this.isSyncMode;
    }

    public void setSyncMode(boolean isSyncMode) {
        this.isSyncMode = isSyncMode;
    }

    public String getNetType() {
        return this.netType;
    }

    public void setNetType(String netType) {
        this.netType = netType;
    }

    public WitnessService getWitnessService() {
        return this.witnessService;
    }

    public void setWitnessService(WitnessService witnessService) {
        this.witnessService = witnessService;
    }

    public WitnessController getWitnessController() {
        return this.witnessController;
    }

    public void setWitnessController(WitnessController witnessController) {
        this.witnessController = witnessController;
    }

    public ProposalController getProposalController() {
        return this.proposalController;
    }

    public void setProposalController(ProposalController proposalController) {
        this.proposalController = proposalController;
    }

    public Cache<Sha256Hash, Boolean> getTransactionIdCache() {
        return this.transactionIdCache;
    }

    public ForkController getForkController() {
        return this.forkController;
    }

    private static class ValidateSignTask
    implements Callable<Boolean> {
        private TransactionCapsule trx;
        private CountDownLatch countDownLatch;

        ValidateSignTask(TransactionCapsule trx, CountDownLatch countDownLatch) {
            this.trx = trx;
            this.countDownLatch = countDownLatch;
        }

        @Override
        public Boolean call() throws ValidateSignatureException {
            try {
                this.trx.validateSignature();
            }
            catch (ValidateSignatureException e) {
                throw e;
            }
            finally {
                this.countDownLatch.countDown();
            }
            return true;
        }
    }
}

