/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class DynamicPropertiesStore
extends TronStoreWithRevoking<BytesCapsule> {
    private static final Logger logger = LoggerFactory.getLogger(DynamicPropertiesStore.class);
    private static final byte[] LATEST_BLOCK_HEADER_TIMESTAMP = "latest_block_header_timestamp".getBytes();
    private static final byte[] LATEST_BLOCK_HEADER_NUMBER = "latest_block_header_number".getBytes();
    private static final byte[] LATEST_BLOCK_HEADER_HASH = "latest_block_header_hash".getBytes();
    private static final byte[] STATE_FLAG = "state_flag".getBytes();
    private static final byte[] LATEST_SOLIDIFIED_BLOCK_NUM = "LATEST_SOLIDIFIED_BLOCK_NUM".getBytes();
    private static final byte[] LATEST_PROPOSAL_NUM = "LATEST_PROPOSAL_NUM".getBytes();
    private static final byte[] LATEST_EXCHANGE_NUM = "LATEST_EXCHANGE_NUM".getBytes();
    private static final byte[] BLOCK_FILLED_SLOTS = "BLOCK_FILLED_SLOTS".getBytes();
    private static final byte[] BLOCK_FILLED_SLOTS_INDEX = "BLOCK_FILLED_SLOTS_INDEX".getBytes();
    private static final byte[] NEXT_MAINTENANCE_TIME = "NEXT_MAINTENANCE_TIME".getBytes();
    private static final byte[] MAX_FROZEN_TIME = "MAX_FROZEN_TIME".getBytes();
    private static final byte[] MIN_FROZEN_TIME = "MIN_FROZEN_TIME".getBytes();
    private static final byte[] MAX_FROZEN_SUPPLY_NUMBER = "MAX_FROZEN_SUPPLY_NUMBER".getBytes();
    private static final byte[] MAX_FROZEN_SUPPLY_TIME = "MAX_FROZEN_SUPPLY_TIME".getBytes();
    private static final byte[] MIN_FROZEN_SUPPLY_TIME = "MIN_FROZEN_SUPPLY_TIME".getBytes();
    private static final byte[] WITNESS_ALLOWANCE_FROZEN_TIME = "WITNESS_ALLOWANCE_FROZEN_TIME".getBytes();
    private static final byte[] MAINTENANCE_TIME_INTERVAL = "MAINTENANCE_TIME_INTERVAL".getBytes();
    private static final byte[] ACCOUNT_UPGRADE_COST = "ACCOUNT_UPGRADE_COST".getBytes();
    private static final byte[] WITNESS_PAY_PER_BLOCK = "WITNESS_PAY_PER_BLOCK".getBytes();
    private static final byte[] WITNESS_STANDBY_ALLOWANCE = "WITNESS_STANDBY_ALLOWANCE".getBytes();
    private static final byte[] ENERGY_FEE = "ENERGY_FEE".getBytes();
    private static final byte[] MAX_CPU_TIME_OF_ONE_TX = "MAX_CPU_TIME_OF_ONE_TX".getBytes();
    private static final byte[] CREATE_ACCOUNT_FEE = "CREATE_ACCOUNT_FEE".getBytes();
    private static final byte[] CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT = "CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT".getBytes();
    private static final byte[] CREATE_NEW_ACCOUNT_BANDWIDTH_RATE = "CREATE_NEW_ACCOUNT_BANDWIDTH_RATE".getBytes();
    private static final byte[] TRANSACTION_FEE = "TRANSACTION_FEE".getBytes();
    private static final byte[] ASSET_ISSUE_FEE = "ASSET_ISSUE_FEE".getBytes();
    private static final byte[] EXCHANGE_CREATE_FEE = "EXCHANGE_CREATE_FEE".getBytes();
    private static final byte[] EXCHANGE_BALANCE_LIMIT = "EXCHANGE_BALANCE_LIMIT".getBytes();
    private static final byte[] TOTAL_TRANSACTION_COST = "TOTAL_TRANSACTION_COST".getBytes();
    private static final byte[] TOTAL_CREATE_ACCOUNT_COST = "TOTAL_CREATE_ACCOUNT_COST".getBytes();
    private static final byte[] TOTAL_CREATE_WITNESS_COST = "TOTAL_CREATE_WITNESS_FEE".getBytes();
    private static final byte[] TOTAL_STORAGE_POOL = "TOTAL_STORAGE_POOL".getBytes();
    private static final byte[] TOTAL_STORAGE_TAX = "TOTAL_STORAGE_TAX".getBytes();
    private static final byte[] TOTAL_STORAGE_RESERVED = "TOTAL_STORAGE_RESERVED".getBytes();
    private static final byte[] STORAGE_EXCHANGE_TAX_RATE = "STORAGE_EXCHANGE_TAX_RATE".getBytes();
    private static final byte[] FORK_CONTROLLER = "FORK_CONTROLLER".getBytes();
    private static final String FORK_PREFIX = "FORK_VERSION_";
    private static final byte[] REMOVE_THE_POWER_OF_THE_GR = "REMOVE_THE_POWER_OF_THE_GR".getBytes();
    private static final byte[] ALLOW_DELEGATE_RESOURCE = "ALLOW_DELEGATE_RESOURCE".getBytes();
    private static final byte[] ALLOW_ADAPTIVE_ENERGY = "ALLOW_ADAPTIVE_ENERGY".getBytes();
    private static final byte[] ALLOW_UPDATE_ACCOUNT_NAME = "ALLOW_UPDATE_ACCOUNT_NAME".getBytes();
    private static final byte[] ALLOW_SAME_TOKEN_NAME = " ALLOW_SAME_TOKEN_NAME".getBytes();
    private static final byte[] ALLOW_CREATION_OF_CONTRACTS = "ALLOW_CREATION_OF_CONTRACTS".getBytes();
    private static final byte[] TOKEN_ID_NUM = "TOKEN_ID_NUM".getBytes();
    private static final byte[] TOKEN_UPDATE_DONE = "TOKEN_UPDATE_DONE".getBytes();
    private static final byte[] ALLOW_TVM_TRANSFER_TRC10 = "ALLOW_TVM_TRANSFER_TRC10".getBytes();

    @Autowired
    private DynamicPropertiesStore(@Value(value="properties") String dbName) {
        super(dbName);
        try {
            this.getLatestBlockHeaderTimestamp();
        }
        catch (IllegalArgumentException e) {
            this.saveLatestBlockHeaderTimestamp(0L);
        }
        try {
            this.getLatestBlockHeaderNumber();
        }
        catch (IllegalArgumentException e) {
            this.saveLatestBlockHeaderNumber(0L);
        }
        try {
            this.getLatestBlockHeaderHash();
        }
        catch (IllegalArgumentException e) {
            this.saveLatestBlockHeaderHash(ByteString.copyFrom((byte[])ByteArray.fromHexString("00")));
        }
        try {
            this.getStateFlag();
        }
        catch (IllegalArgumentException e) {
            this.saveStateFlag(0);
        }
        try {
            this.getLatestSolidifiedBlockNum();
        }
        catch (IllegalArgumentException e) {
            this.saveLatestSolidifiedBlockNum(0L);
        }
        try {
            this.getLatestProposalNum();
        }
        catch (IllegalArgumentException e) {
            this.saveLatestProposalNum(0L);
        }
        try {
            this.getLatestExchangeNum();
        }
        catch (IllegalArgumentException e) {
            this.saveLatestExchangeNum(0L);
        }
        try {
            this.getBlockFilledSlotsIndex();
        }
        catch (IllegalArgumentException e) {
            this.saveBlockFilledSlotsIndex(0);
        }
        try {
            this.getTokenIdNum();
        }
        catch (IllegalArgumentException e) {
            this.saveTokenIdNum(1000000L);
        }
        try {
            this.getTokenUpdateDone();
        }
        catch (IllegalArgumentException e) {
            this.saveTokenUpdateDone(0L);
        }
        try {
            this.getMaxFrozenTime();
        }
        catch (IllegalArgumentException e) {
            this.saveMaxFrozenTime(3);
        }
        try {
            this.getMinFrozenTime();
        }
        catch (IllegalArgumentException e) {
            this.saveMinFrozenTime(3);
        }
        try {
            this.getMaxFrozenSupplyNumber();
        }
        catch (IllegalArgumentException e) {
            this.saveMaxFrozenSupplyNumber(10);
        }
        try {
            this.getMaxFrozenSupplyTime();
        }
        catch (IllegalArgumentException e) {
            this.saveMaxFrozenSupplyTime(3652);
        }
        try {
            this.getMinFrozenSupplyTime();
        }
        catch (IllegalArgumentException e) {
            this.saveMinFrozenSupplyTime(1);
        }
        try {
            this.getWitnessAllowanceFrozenTime();
        }
        catch (IllegalArgumentException e) {
            this.saveWitnessAllowanceFrozenTime(1);
        }
        try {
            this.getWitnessPayPerBlock();
        }
        catch (IllegalArgumentException e) {
            this.saveWitnessPayPerBlock(32000000L);
        }
        try {
            this.getWitnessStandbyAllowance();
        }
        catch (IllegalArgumentException e) {
            this.saveWitnessStandbyAllowance(115200000000L);
        }
        try {
            this.getMaintenanceTimeInterval();
        }
        catch (IllegalArgumentException e) {
            this.saveMaintenanceTimeInterval(Args.getInstance().getMaintenanceTimeInterval());
        }
        try {
            this.getAccountUpgradeCost();
        }
        catch (IllegalArgumentException e) {
            this.saveAccountUpgradeCost(9999000000L);
        }
        try {
            this.getPublicNetUsage();
        }
        catch (IllegalArgumentException e) {
            this.savePublicNetUsage(0L);
        }
        try {
            this.getOneDayNetLimit();
        }
        catch (IllegalArgumentException e) {
            this.saveOneDayNetLimit(57600000000L);
        }
        try {
            this.getPublicNetLimit();
        }
        catch (IllegalArgumentException e) {
            this.savePublicNetLimit(14400000000L);
        }
        try {
            this.getPublicNetTime();
        }
        catch (IllegalArgumentException e) {
            this.savePublicNetTime(0L);
        }
        try {
            this.getFreeNetLimit();
        }
        catch (IllegalArgumentException e) {
            this.saveFreeNetLimit(5000L);
        }
        try {
            this.getTotalNetWeight();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalNetWeight(0L);
        }
        try {
            this.getTotalNetLimit();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalNetLimit(43200000000L);
        }
        try {
            this.getTotalEnergyWeight();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalEnergyWeight(0L);
        }
        try {
            this.getTotalEnergyLimit();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalEnergyLimit(50000000000L);
        }
        try {
            this.getEnergyFee();
        }
        catch (IllegalArgumentException e) {
            this.saveEnergyFee(100L);
        }
        try {
            this.getMaxCpuTimeOfOneTx();
        }
        catch (IllegalArgumentException e) {
            this.saveMaxCpuTimeOfOneTx(50L);
        }
        try {
            this.getCreateAccountFee();
        }
        catch (IllegalArgumentException e) {
            this.saveCreateAccountFee(100000L);
        }
        try {
            this.getCreateNewAccountFeeInSystemContract();
        }
        catch (IllegalArgumentException e) {
            this.saveCreateNewAccountFeeInSystemContract(0L);
        }
        try {
            this.getCreateNewAccountBandwidthRate();
        }
        catch (IllegalArgumentException e) {
            this.saveCreateNewAccountBandwidthRate(1L);
        }
        try {
            this.getTransactionFee();
        }
        catch (IllegalArgumentException e) {
            this.saveTransactionFee(10L);
        }
        try {
            this.getAssetIssueFee();
        }
        catch (IllegalArgumentException e) {
            this.saveAssetIssueFee(1024000000L);
        }
        try {
            this.getExchangeCreateFee();
        }
        catch (IllegalArgumentException e) {
            this.saveExchangeCreateFee(1024000000L);
        }
        try {
            this.getExchangeBalanceLimit();
        }
        catch (IllegalArgumentException e) {
            this.saveExchangeBalanceLimit(1000000000000000L);
        }
        try {
            this.getTotalTransactionCost();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalTransactionCost(0L);
        }
        try {
            this.getTotalCreateWitnessCost();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalCreateWitnessFee(0L);
        }
        try {
            this.getTotalCreateAccountCost();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalCreateAccountFee(0L);
        }
        try {
            this.getTotalStoragePool();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalStoragePool(100000000000000L);
        }
        try {
            this.getTotalStorageTax();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalStorageTax(0L);
        }
        try {
            this.getTotalStorageReserved();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalStorageReserved(0x2000000000L);
        }
        try {
            this.getStorageExchangeTaxRate();
        }
        catch (IllegalArgumentException e) {
            this.saveStorageExchangeTaxRate(10L);
        }
        try {
            this.getRemoveThePowerOfTheGr();
        }
        catch (IllegalArgumentException e) {
            this.saveRemoveThePowerOfTheGr(0L);
        }
        try {
            this.getAllowDelegateResource();
        }
        catch (IllegalArgumentException e) {
            this.saveAllowDelegateResource(Args.getInstance().getAllowDelegateResource());
        }
        try {
            this.getAllowAdaptiveEnergy();
        }
        catch (IllegalArgumentException e) {
            this.saveAllowAdaptiveEnergy(Args.getInstance().getAllowAdaptiveEnergy());
        }
        try {
            this.getAllowTvmTransferTrc10();
        }
        catch (IllegalArgumentException e) {
            this.saveAllowTvmTransferTrc10(Args.getInstance().getAllowTvmTransferTrc10());
        }
        try {
            this.getAllowSameTokenName();
        }
        catch (IllegalArgumentException e) {
            this.saveAllowSameTokenName(Args.getInstance().getAllowSameTokenName());
        }
        try {
            this.getAllowUpdateAccountName();
        }
        catch (IllegalArgumentException e) {
            this.saveAllowUpdateAccountName(0L);
        }
        try {
            this.getAllowCreationOfContracts();
        }
        catch (IllegalArgumentException e) {
            this.saveAllowCreationOfContracts(Args.getInstance().getAllowCreationOfContracts());
        }
        try {
            this.getBlockFilledSlots();
        }
        catch (IllegalArgumentException e) {
            int[] blockFilledSlots = new int[this.getBlockFilledSlotsNumber()];
            Arrays.fill(blockFilledSlots, 1);
            this.saveBlockFilledSlots(blockFilledSlots);
        }
        try {
            this.getNextMaintenanceTime();
        }
        catch (IllegalArgumentException e) {
            this.saveNextMaintenanceTime(Long.parseLong(Args.getInstance().getGenesisBlock().getTimestamp()));
        }
        try {
            this.getTotalEnergyCurrentLimit();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalEnergyCurrentLimit(this.getTotalEnergyLimit());
        }
        try {
            this.getTotalEnergyTargetLimit();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalEnergyTargetLimit(this.getTotalEnergyLimit() / 14400L);
        }
        try {
            this.getTotalEnergyAverageUsage();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalEnergyAverageUsage(0L);
        }
        try {
            this.getTotalEnergyAverageTime();
        }
        catch (IllegalArgumentException e) {
            this.saveTotalEnergyAverageTime(0L);
        }
    }

    public String intArrayToString(int[] a) {
        StringBuilder sb = new StringBuilder();
        for (int i : a) {
            sb.append(i);
        }
        return sb.toString();
    }

    public int[] stringToIntArray(String s) {
        int length = s.length();
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Integer.parseInt(s.substring(i, i + 1));
        }
        return result;
    }

    public void saveTokenIdNum(long num) {
        this.put(TOKEN_ID_NUM, new BytesCapsule(ByteArray.fromLong(num)));
    }

    public long getTokenIdNum() {
        return Optional.ofNullable(this.getUnchecked(TOKEN_ID_NUM)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOKEN_ID_NUM"));
    }

    public void saveTokenUpdateDone(long num) {
        this.put(TOKEN_UPDATE_DONE, new BytesCapsule(ByteArray.fromLong(num)));
    }

    public long getTokenUpdateDone() {
        return Optional.ofNullable(this.getUnchecked(TOKEN_UPDATE_DONE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOKEN_UPDATE_DONE"));
    }

    public void saveBlockFilledSlotsIndex(int blockFilledSlotsIndex) {
        logger.debug("blockFilledSlotsIndex:" + blockFilledSlotsIndex);
        this.put(BLOCK_FILLED_SLOTS_INDEX, new BytesCapsule(ByteArray.fromInt(blockFilledSlotsIndex)));
    }

    public int getBlockFilledSlotsIndex() {
        return Optional.ofNullable(this.getUnchecked(BLOCK_FILLED_SLOTS_INDEX)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found BLOCK_FILLED_SLOTS_INDEX"));
    }

    public void saveMaxFrozenTime(int maxFrozenTime) {
        logger.debug("MAX_FROZEN_NUMBER:" + maxFrozenTime);
        this.put(MAX_FROZEN_TIME, new BytesCapsule(ByteArray.fromInt(maxFrozenTime)));
    }

    public int getMaxFrozenTime() {
        return Optional.ofNullable(this.getUnchecked(MAX_FROZEN_TIME)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found MAX_FROZEN_TIME"));
    }

    public void saveMinFrozenTime(int minFrozenTime) {
        logger.debug("MIN_FROZEN_NUMBER:" + minFrozenTime);
        this.put(MIN_FROZEN_TIME, new BytesCapsule(ByteArray.fromInt(minFrozenTime)));
    }

    public int getMinFrozenTime() {
        return Optional.ofNullable(this.getUnchecked(MIN_FROZEN_TIME)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found MIN_FROZEN_TIME"));
    }

    public void saveMaxFrozenSupplyNumber(int maxFrozenSupplyNumber) {
        logger.debug("MAX_FROZEN_SUPPLY_NUMBER:" + maxFrozenSupplyNumber);
        this.put(MAX_FROZEN_SUPPLY_NUMBER, new BytesCapsule(ByteArray.fromInt(maxFrozenSupplyNumber)));
    }

    public int getMaxFrozenSupplyNumber() {
        return Optional.ofNullable(this.getUnchecked(MAX_FROZEN_SUPPLY_NUMBER)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found MAX_FROZEN_SUPPLY_NUMBER"));
    }

    public void saveMaxFrozenSupplyTime(int maxFrozenSupplyTime) {
        logger.debug("MAX_FROZEN_SUPPLY_NUMBER:" + maxFrozenSupplyTime);
        this.put(MAX_FROZEN_SUPPLY_TIME, new BytesCapsule(ByteArray.fromInt(maxFrozenSupplyTime)));
    }

    public int getMaxFrozenSupplyTime() {
        return Optional.ofNullable(this.getUnchecked(MAX_FROZEN_SUPPLY_TIME)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found MAX_FROZEN_SUPPLY_TIME"));
    }

    public void saveMinFrozenSupplyTime(int minFrozenSupplyTime) {
        logger.debug("MIN_FROZEN_SUPPLY_NUMBER:" + minFrozenSupplyTime);
        this.put(MIN_FROZEN_SUPPLY_TIME, new BytesCapsule(ByteArray.fromInt(minFrozenSupplyTime)));
    }

    public int getMinFrozenSupplyTime() {
        return Optional.ofNullable(this.getUnchecked(MIN_FROZEN_SUPPLY_TIME)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found MIN_FROZEN_SUPPLY_TIME"));
    }

    public void saveWitnessAllowanceFrozenTime(int witnessAllowanceFrozenTime) {
        logger.debug("WITNESS_ALLOWANCE_FROZEN_TIME:" + witnessAllowanceFrozenTime);
        this.put(WITNESS_ALLOWANCE_FROZEN_TIME, new BytesCapsule(ByteArray.fromInt(witnessAllowanceFrozenTime)));
    }

    public int getWitnessAllowanceFrozenTime() {
        return Optional.ofNullable(this.getUnchecked(WITNESS_ALLOWANCE_FROZEN_TIME)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found WITNESS_ALLOWANCE_FROZEN_TIME"));
    }

    public void saveMaintenanceTimeInterval(long timeInterval) {
        logger.debug("MAINTENANCE_TIME_INTERVAL:" + timeInterval);
        this.put(MAINTENANCE_TIME_INTERVAL, new BytesCapsule(ByteArray.fromLong(timeInterval)));
    }

    public long getMaintenanceTimeInterval() {
        return Optional.ofNullable(this.getUnchecked(MAINTENANCE_TIME_INTERVAL)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found MAINTENANCE_TIME_INTERVAL"));
    }

    public void saveAccountUpgradeCost(long accountUpgradeCost) {
        logger.debug("ACCOUNT_UPGRADE_COST:" + accountUpgradeCost);
        this.put(ACCOUNT_UPGRADE_COST, new BytesCapsule(ByteArray.fromLong(accountUpgradeCost)));
    }

    public long getAccountUpgradeCost() {
        return Optional.ofNullable(this.getUnchecked(ACCOUNT_UPGRADE_COST)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ACCOUNT_UPGRADE_COST"));
    }

    public void saveWitnessPayPerBlock(long pay) {
        logger.debug("WITNESS_PAY_PER_BLOCK:" + pay);
        this.put(WITNESS_PAY_PER_BLOCK, new BytesCapsule(ByteArray.fromLong(pay)));
    }

    public long getWitnessPayPerBlock() {
        return Optional.ofNullable(this.getUnchecked(WITNESS_PAY_PER_BLOCK)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found WITNESS_PAY_PER_BLOCK"));
    }

    public void saveWitnessStandbyAllowance(long allowance) {
        logger.debug("WITNESS_STANDBY_ALLOWANCE:" + allowance);
        this.put(WITNESS_STANDBY_ALLOWANCE, new BytesCapsule(ByteArray.fromLong(allowance)));
    }

    public long getWitnessStandbyAllowance() {
        return Optional.ofNullable(this.getUnchecked(WITNESS_STANDBY_ALLOWANCE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found WITNESS_STANDBY_ALLOWANCE"));
    }

    public void saveOneDayNetLimit(long oneDayNetLimit) {
        this.put(DynamicResourceProperties.ONE_DAY_NET_LIMIT, new BytesCapsule(ByteArray.fromLong(oneDayNetLimit)));
    }

    public long getOneDayNetLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.ONE_DAY_NET_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ONE_DAY_NET_LIMIT"));
    }

    public void savePublicNetUsage(long publicNetUsage) {
        this.put(DynamicResourceProperties.PUBLIC_NET_USAGE, new BytesCapsule(ByteArray.fromLong(publicNetUsage)));
    }

    public long getPublicNetUsage() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.PUBLIC_NET_USAGE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found PUBLIC_NET_USAGE"));
    }

    public void savePublicNetLimit(long publicNetLimit) {
        this.put(DynamicResourceProperties.PUBLIC_NET_LIMIT, new BytesCapsule(ByteArray.fromLong(publicNetLimit)));
    }

    public long getPublicNetLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.PUBLIC_NET_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found PUBLIC_NET_LIMIT"));
    }

    public void savePublicNetTime(long publicNetTime) {
        this.put(DynamicResourceProperties.PUBLIC_NET_TIME, new BytesCapsule(ByteArray.fromLong(publicNetTime)));
    }

    public long getPublicNetTime() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.PUBLIC_NET_TIME)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found PUBLIC_NET_TIME"));
    }

    public void saveFreeNetLimit(long freeNetLimit) {
        this.put(DynamicResourceProperties.FREE_NET_LIMIT, new BytesCapsule(ByteArray.fromLong(freeNetLimit)));
    }

    public long getFreeNetLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.FREE_NET_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found FREE_NET_LIMIT"));
    }

    public void saveTotalNetWeight(long totalNetWeight) {
        this.put(DynamicResourceProperties.TOTAL_NET_WEIGHT, new BytesCapsule(ByteArray.fromLong(totalNetWeight)));
    }

    public long getTotalNetWeight() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_NET_WEIGHT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_NET_WEIGHT"));
    }

    public void saveTotalEnergyWeight(long totalEnergyWeight) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_WEIGHT, new BytesCapsule(ByteArray.fromLong(totalEnergyWeight)));
    }

    public long getTotalEnergyWeight() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_ENERGY_WEIGHT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_ENERGY_WEIGHT"));
    }

    public void saveTotalNetLimit(long totalNetLimit) {
        this.put(DynamicResourceProperties.TOTAL_NET_LIMIT, new BytesCapsule(ByteArray.fromLong(totalNetLimit)));
    }

    public long getTotalNetLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_NET_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_NET_LIMIT"));
    }

    public void saveTotalEnergyLimit(long totalEnergyLimit) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_LIMIT, new BytesCapsule(ByteArray.fromLong(totalEnergyLimit)));
        this.saveTotalEnergyTargetLimit(totalEnergyLimit / 14400L);
    }

    public long getTotalEnergyLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_ENERGY_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_ENERGY_LIMIT"));
    }

    public void saveTotalEnergyCurrentLimit(long totalEnergyCurrentLimit) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_CURRENT_LIMIT, new BytesCapsule(ByteArray.fromLong(totalEnergyCurrentLimit)));
    }

    public long getTotalEnergyCurrentLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_ENERGY_CURRENT_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_ENERGY_CURRENT_LIMIT"));
    }

    public void saveTotalEnergyTargetLimit(long targetTotalEnergyLimit) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_TARGET_LIMIT, new BytesCapsule(ByteArray.fromLong(targetTotalEnergyLimit)));
    }

    public long getTotalEnergyTargetLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_ENERGY_TARGET_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_ENERGY_TARGET_LIMIT"));
    }

    public void saveTotalEnergyAverageUsage(long totalEnergyAverageUsage) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_AVERAGE_USAGE, new BytesCapsule(ByteArray.fromLong(totalEnergyAverageUsage)));
    }

    public long getTotalEnergyAverageUsage() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_ENERGY_AVERAGE_USAGE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_ENERGY_AVERAGE_USAGE"));
    }

    public void saveTotalEnergyAverageTime(long totalEnergyAverageTime) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_AVERAGE_TIME, new BytesCapsule(ByteArray.fromLong(totalEnergyAverageTime)));
    }

    public long getTotalEnergyAverageTime() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_ENERGY_AVERAGE_TIME)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_NET_AVERAGE_TIME"));
    }

    public void saveEnergyFee(long totalEnergyFee) {
        this.put(ENERGY_FEE, new BytesCapsule(ByteArray.fromLong(totalEnergyFee)));
    }

    public long getEnergyFee() {
        return Optional.ofNullable(this.getUnchecked(ENERGY_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ENERGY_FEE"));
    }

    public void saveMaxCpuTimeOfOneTx(long time) {
        this.put(MAX_CPU_TIME_OF_ONE_TX, new BytesCapsule(ByteArray.fromLong(time)));
    }

    public long getMaxCpuTimeOfOneTx() {
        return Optional.ofNullable(this.getUnchecked(MAX_CPU_TIME_OF_ONE_TX)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found MAX_CPU_TIME_OF_ONE_TX"));
    }

    public void saveCreateAccountFee(long fee) {
        this.put(CREATE_ACCOUNT_FEE, new BytesCapsule(ByteArray.fromLong(fee)));
    }

    public long getCreateAccountFee() {
        return Optional.ofNullable(this.getUnchecked(CREATE_ACCOUNT_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found CREATE_ACCOUNT_FEE"));
    }

    public void saveCreateNewAccountFeeInSystemContract(long fee) {
        this.put(CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT, new BytesCapsule(ByteArray.fromLong(fee)));
    }

    public long getCreateNewAccountFeeInSystemContract() {
        return Optional.ofNullable(this.getUnchecked(CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT"));
    }

    public void saveCreateNewAccountBandwidthRate(long rate) {
        this.put(CREATE_NEW_ACCOUNT_BANDWIDTH_RATE, new BytesCapsule(ByteArray.fromLong(rate)));
    }

    public long getCreateNewAccountBandwidthRate() {
        return Optional.ofNullable(this.getUnchecked(CREATE_NEW_ACCOUNT_BANDWIDTH_RATE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found CREATE_NsEW_ACCOUNT_BANDWIDTH_RATE2"));
    }

    public void saveTransactionFee(long fee) {
        this.put(TRANSACTION_FEE, new BytesCapsule(ByteArray.fromLong(fee)));
    }

    public long getTransactionFee() {
        return Optional.ofNullable(this.getUnchecked(TRANSACTION_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TRANSACTION_FEE"));
    }

    public void saveAssetIssueFee(long fee) {
        this.put(ASSET_ISSUE_FEE, new BytesCapsule(ByteArray.fromLong(fee)));
    }

    public long getAssetIssueFee() {
        return Optional.ofNullable(this.getUnchecked(ASSET_ISSUE_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ASSET_ISSUE_FEE"));
    }

    public void saveExchangeCreateFee(long fee) {
        this.put(EXCHANGE_CREATE_FEE, new BytesCapsule(ByteArray.fromLong(fee)));
    }

    public long getExchangeCreateFee() {
        return Optional.ofNullable(this.getUnchecked(EXCHANGE_CREATE_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found EXCHANGE_CREATE_FEE"));
    }

    public void saveExchangeBalanceLimit(long limit) {
        this.put(EXCHANGE_BALANCE_LIMIT, new BytesCapsule(ByteArray.fromLong(limit)));
    }

    public long getExchangeBalanceLimit() {
        return Optional.ofNullable(this.getUnchecked(EXCHANGE_BALANCE_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found EXCHANGE_BALANCE_LIMIT"));
    }

    public void saveTotalTransactionCost(long value) {
        this.put(TOTAL_TRANSACTION_COST, new BytesCapsule(ByteArray.fromLong(value)));
    }

    public long getTotalTransactionCost() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_TRANSACTION_COST)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_TRANSACTION_COST"));
    }

    public void saveTotalCreateAccountFee(long value) {
        this.put(TOTAL_CREATE_ACCOUNT_COST, new BytesCapsule(ByteArray.fromLong(value)));
    }

    public long getTotalCreateAccountCost() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_CREATE_ACCOUNT_COST)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_CREATE_ACCOUNT_COST"));
    }

    public void saveTotalCreateWitnessFee(long value) {
        this.put(TOTAL_CREATE_WITNESS_COST, new BytesCapsule(ByteArray.fromLong(value)));
    }

    public long getTotalCreateWitnessCost() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_CREATE_WITNESS_COST)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_CREATE_WITNESS_COST"));
    }

    public void saveTotalStoragePool(long trx) {
        this.put(TOTAL_STORAGE_POOL, new BytesCapsule(ByteArray.fromLong(trx)));
    }

    public long getTotalStoragePool() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_STORAGE_POOL)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_STORAGE_POOL"));
    }

    public void saveTotalStorageTax(long trx) {
        this.put(TOTAL_STORAGE_TAX, new BytesCapsule(ByteArray.fromLong(trx)));
    }

    public long getTotalStorageTax() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_STORAGE_TAX)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_STORAGE_TAX"));
    }

    public void saveTotalStorageReserved(long bytes) {
        this.put(TOTAL_STORAGE_RESERVED, new BytesCapsule(ByteArray.fromLong(bytes)));
    }

    public long getTotalStorageReserved() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_STORAGE_RESERVED)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_STORAGE_RESERVED"));
    }

    public void saveStorageExchangeTaxRate(long rate) {
        this.put(STORAGE_EXCHANGE_TAX_RATE, new BytesCapsule(ByteArray.fromLong(rate)));
    }

    public long getStorageExchangeTaxRate() {
        return Optional.ofNullable(this.getUnchecked(STORAGE_EXCHANGE_TAX_RATE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found STORAGE_EXCHANGE_TAX_RATE"));
    }

    public void saveRemoveThePowerOfTheGr(long rate) {
        this.put(REMOVE_THE_POWER_OF_THE_GR, new BytesCapsule(ByteArray.fromLong(rate)));
    }

    public long getRemoveThePowerOfTheGr() {
        return Optional.ofNullable(this.getUnchecked(REMOVE_THE_POWER_OF_THE_GR)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found REMOVE_THE_POWER_OF_THE_GR"));
    }

    public void saveAllowDelegateResource(long value) {
        this.put(ALLOW_DELEGATE_RESOURCE, new BytesCapsule(ByteArray.fromLong(value)));
    }

    public long getAllowDelegateResource() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_DELEGATE_RESOURCE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_DELEGATE_RESOURCE"));
    }

    public void saveAllowAdaptiveEnergy(long value) {
        this.put(ALLOW_ADAPTIVE_ENERGY, new BytesCapsule(ByteArray.fromLong(value)));
    }

    public long getAllowAdaptiveEnergy() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_ADAPTIVE_ENERGY)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_ADAPTIVE_ENERGY"));
    }

    public void saveAllowTvmTransferTrc10(long value) {
        this.put(ALLOW_TVM_TRANSFER_TRC10, new BytesCapsule(ByteArray.fromLong(value)));
    }

    public long getAllowTvmTransferTrc10() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_TVM_TRANSFER_TRC10)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_TVM_TRANSFER_TRC10"));
    }

    public boolean supportDR() {
        return this.getAllowDelegateResource() == 1L;
    }

    public void saveAllowUpdateAccountName(long rate) {
        this.put(ALLOW_UPDATE_ACCOUNT_NAME, new BytesCapsule(ByteArray.fromLong(rate)));
    }

    public long getAllowUpdateAccountName() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_UPDATE_ACCOUNT_NAME)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_UPDATE_ACCOUNT_NAME"));
    }

    public void saveAllowSameTokenName(long rate) {
        this.put(ALLOW_SAME_TOKEN_NAME, new BytesCapsule(ByteArray.fromLong(rate)));
    }

    public long getAllowSameTokenName() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_SAME_TOKEN_NAME)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_SAME_TOKEN_NAME"));
    }

    public void saveAllowCreationOfContracts(long allowCreationOfContracts) {
        this.put(ALLOW_CREATION_OF_CONTRACTS, new BytesCapsule(ByteArray.fromLong(allowCreationOfContracts)));
    }

    public long getAllowCreationOfContracts() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_CREATION_OF_CONTRACTS)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_CREATION_OF_CONTRACTS"));
    }

    public boolean supportVM() {
        return this.getAllowCreationOfContracts() == 1L;
    }

    public void saveBlockFilledSlots(int[] blockFilledSlots) {
        logger.debug("blockFilledSlots:" + this.intArrayToString(blockFilledSlots));
        this.put(BLOCK_FILLED_SLOTS, new BytesCapsule(ByteArray.fromString(this.intArrayToString(blockFilledSlots))));
    }

    public int[] getBlockFilledSlots() {
        return Optional.ofNullable(this.getUnchecked(BLOCK_FILLED_SLOTS)).map(BytesCapsule::getData).map(ByteArray::toStr).map(this::stringToIntArray).orElseThrow(() -> new IllegalArgumentException("not found latest SOLIDIFIED_BLOCK_NUM timestamp"));
    }

    public int getBlockFilledSlotsNumber() {
        return 128;
    }

    public void applyBlock(boolean fillBlock) {
        int[] blockFilledSlots = this.getBlockFilledSlots();
        int blockFilledSlotsIndex = this.getBlockFilledSlotsIndex();
        blockFilledSlots[blockFilledSlotsIndex] = fillBlock ? 1 : 0;
        this.saveBlockFilledSlotsIndex((blockFilledSlotsIndex + 1) % this.getBlockFilledSlotsNumber());
        this.saveBlockFilledSlots(blockFilledSlots);
    }

    public int calculateFilledSlotsCount() {
        int[] blockFilledSlots = this.getBlockFilledSlots();
        return 100 * IntStream.of(blockFilledSlots).sum() / this.getBlockFilledSlotsNumber();
    }

    public void saveLatestSolidifiedBlockNum(long number) {
        this.put(LATEST_SOLIDIFIED_BLOCK_NUM, new BytesCapsule(ByteArray.fromLong(number)));
    }

    public long getLatestSolidifiedBlockNum() {
        return Optional.ofNullable(this.getUnchecked(LATEST_SOLIDIFIED_BLOCK_NUM)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found latest SOLIDIFIED_BLOCK_NUM"));
    }

    public void saveLatestProposalNum(long number) {
        this.put(LATEST_PROPOSAL_NUM, new BytesCapsule(ByteArray.fromLong(number)));
    }

    public long getLatestProposalNum() {
        return Optional.ofNullable(this.getUnchecked(LATEST_PROPOSAL_NUM)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found latest PROPOSAL_NUM"));
    }

    public void saveLatestExchangeNum(long number) {
        this.put(LATEST_EXCHANGE_NUM, new BytesCapsule(ByteArray.fromLong(number)));
    }

    public long getLatestExchangeNum() {
        return Optional.ofNullable(this.getUnchecked(LATEST_EXCHANGE_NUM)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found latest EXCHANGE_NUM"));
    }

    public long getLatestBlockHeaderTimestamp() {
        return Optional.ofNullable(this.getUnchecked(LATEST_BLOCK_HEADER_TIMESTAMP)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found latest block header timestamp"));
    }

    public long getLatestBlockHeaderNumber() {
        return Optional.ofNullable(this.getUnchecked(LATEST_BLOCK_HEADER_NUMBER)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found latest block header number"));
    }

    public long getLatestBlockHeaderNumberOnSolidity() {
        return Optional.ofNullable(this.revokingDB.getUncheckedOnSolidity(LATEST_BLOCK_HEADER_NUMBER)).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found latest block header number"));
    }

    public int getStateFlag() {
        return Optional.ofNullable(this.getUnchecked(STATE_FLAG)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found maintenance flag"));
    }

    public Sha256Hash getLatestBlockHeaderHash() {
        byte[] blockHash = Optional.ofNullable(this.getUnchecked(LATEST_BLOCK_HEADER_HASH)).map(BytesCapsule::getData).orElseThrow(() -> new IllegalArgumentException("not found block hash"));
        return Sha256Hash.wrap(blockHash);
    }

    public Sha256Hash getLatestBlockHeaderHashOnSolidity() {
        byte[] blockHash = Optional.ofNullable(this.revokingDB.getUncheckedOnSolidity(LATEST_BLOCK_HEADER_HASH)).orElseThrow(() -> new IllegalArgumentException("not found block hash"));
        return Sha256Hash.wrap(blockHash);
    }

    public void saveLatestBlockHeaderTimestamp(long t) {
        logger.info("update latest block header timestamp = {}", (Object)t);
        this.put(LATEST_BLOCK_HEADER_TIMESTAMP, new BytesCapsule(ByteArray.fromLong(t)));
    }

    public void saveLatestBlockHeaderNumber(long n) {
        logger.info("update latest block header number = {}", (Object)n);
        this.put(LATEST_BLOCK_HEADER_NUMBER, new BytesCapsule(ByteArray.fromLong(n)));
    }

    public void saveLatestBlockHeaderHash(ByteString h) {
        logger.info("update latest block header id = {}", (Object)ByteArray.toHexString(h.toByteArray()));
        this.put(LATEST_BLOCK_HEADER_HASH, new BytesCapsule(h.toByteArray()));
        if (this.revokingDB.getUnchecked(LATEST_BLOCK_HEADER_HASH).length == 32) {
            // empty if block
        }
    }

    public void saveStateFlag(int n) {
        logger.info("update state flag = {}", (Object)n);
        this.put(STATE_FLAG, new BytesCapsule(ByteArray.fromInt(n)));
    }

    public long getNextMaintenanceTime() {
        return Optional.ofNullable(this.getUnchecked(NEXT_MAINTENANCE_TIME)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found NEXT_MAINTENANCE_TIME"));
    }

    public long getMaintenanceSkipSlots() {
        return 2L;
    }

    public void saveNextMaintenanceTime(long nextMaintenanceTime) {
        this.put(NEXT_MAINTENANCE_TIME, new BytesCapsule(ByteArray.fromLong(nextMaintenanceTime)));
    }

    public void updateNextMaintenanceTime(long blockTime) {
        long maintenanceTimeInterval = this.getMaintenanceTimeInterval();
        long currentMaintenanceTime = this.getNextMaintenanceTime();
        long round = (blockTime - currentMaintenanceTime) / maintenanceTimeInterval;
        long nextMaintenanceTime = currentMaintenanceTime + (round + 1L) * maintenanceTimeInterval;
        this.saveNextMaintenanceTime(nextMaintenanceTime);
        logger.info("do update nextMaintenanceTime,currentMaintenanceTime:{}, blockTime:{},nextMaintenanceTime:{}", new Object[]{new DateTime(currentMaintenanceTime), new DateTime(blockTime), new DateTime(nextMaintenanceTime)});
    }

    public void addTotalNetWeight(long amount) {
        long totalNetWeight = this.getTotalNetWeight();
        this.saveTotalNetWeight(totalNetWeight += amount);
    }

    public void addTotalEnergyWeight(long amount) {
        long totalEnergyWeight = this.getTotalEnergyWeight();
        this.saveTotalEnergyWeight(totalEnergyWeight += amount);
    }

    public void addTotalCreateAccountCost(long fee) {
        long newValue = this.getTotalCreateAccountCost() + fee;
        this.saveTotalCreateAccountFee(newValue);
    }

    public void addTotalCreateWitnessCost(long fee) {
        long newValue = this.getTotalCreateWitnessCost() + fee;
        this.saveTotalCreateWitnessFee(newValue);
    }

    public void addTotalTransactionCost(long fee) {
        long newValue = this.getTotalTransactionCost() + fee;
        this.saveTotalTransactionCost(newValue);
    }

    public void forked() {
        this.put(FORK_CONTROLLER, new BytesCapsule(Boolean.toString(true).getBytes()));
    }

    public void statsByVersion(int version, byte[] stats) {
        String statsKey = FORK_PREFIX + version;
        this.put(statsKey.getBytes(), new BytesCapsule(stats));
    }

    public byte[] statsByVersion(int version) {
        String statsKey = FORK_PREFIX + version;
        return this.revokingDB.getUnchecked(statsKey.getBytes());
    }

    public boolean getForked() {
        byte[] value = this.revokingDB.getUnchecked(FORK_CONTROLLER);
        return value == null ? Boolean.FALSE : Boolean.valueOf(new String(value));
    }

    private static class DynamicResourceProperties {
        private static final byte[] ONE_DAY_NET_LIMIT = "ONE_DAY_NET_LIMIT".getBytes();
        private static final byte[] PUBLIC_NET_USAGE = "PUBLIC_NET_USAGE".getBytes();
        private static final byte[] PUBLIC_NET_LIMIT = "PUBLIC_NET_LIMIT".getBytes();
        private static final byte[] PUBLIC_NET_TIME = "PUBLIC_NET_TIME".getBytes();
        private static final byte[] FREE_NET_LIMIT = "FREE_NET_LIMIT".getBytes();
        private static final byte[] TOTAL_NET_WEIGHT = "TOTAL_NET_WEIGHT".getBytes();
        private static final byte[] TOTAL_NET_LIMIT = "TOTAL_NET_LIMIT".getBytes();
        private static final byte[] TOTAL_ENERGY_TARGET_LIMIT = "TOTAL_ENERGY_TARGET_LIMIT".getBytes();
        private static final byte[] TOTAL_ENERGY_CURRENT_LIMIT = "TOTAL_ENERGY_CURRENT_LIMIT".getBytes();
        private static final byte[] TOTAL_ENERGY_AVERAGE_USAGE = "TOTAL_ENERGY_AVERAGE_USAGE".getBytes();
        private static final byte[] TOTAL_ENERGY_AVERAGE_TIME = "TOTAL_ENERGY_AVERAGE_TIME".getBytes();
        private static final byte[] TOTAL_ENERGY_WEIGHT = "TOTAL_ENERGY_WEIGHT".getBytes();
        private static final byte[] TOTAL_ENERGY_LIMIT = "TOTAL_ENERGY_LIMIT".getBytes();

        private DynamicResourceProperties() {
        }
    }
}

