/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.config.args;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.io.File;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.Options;
import org.tron.common.utils.FileUtil;

public class Storage {
    private static final String DB_DIRECTORY_CONFIG_KEY = "storage.db.directory";
    private static final String DB_VERSION_CONFIG_KEY = "storage.db.version";
    private static final String DB_SYNC_CONFIG_KEY = "storage.db.sync";
    private static final String INDEX_DIRECTORY_CONFIG_KEY = "storage.index.directory";
    private static final String INDEX_SWITCH_CONFIG_KEY = "storage.index.switch";
    private static final String PROPERTIES_CONFIG_KEY = "storage.properties";
    private static final String NAME_CONFIG_KEY = "name";
    private static final String PATH_CONFIG_KEY = "path";
    private static final String CREATE_IF_MISSING_CONFIG_KEY = "createIfMissing";
    private static final String PARANOID_CHECKS_CONFIG_KEY = "paranoidChecks";
    private static final String VERITY_CHECK_SUMS_CONFIG_KEY = "verifyChecksums";
    private static final String COMPRESSION_TYPE_CONFIG_KEY = "compressionType";
    private static final String BLOCK_SIZE_CONFIG_KEY = "blockSize";
    private static final String WRITE_BUFFER_SIZE_CONFIG_KEY = "writeBufferSize";
    private static final String CACHE_SIZE_CONFIG_KEY = "cacheSize";
    private static final String MAX_OPEN_FILES_CONFIG_KEY = "maxOpenFiles";
    private static final int DEFAULT_DB_VERSION = 2;
    private static final boolean DEFAULT_DB_SYNC = false;
    private static final String DEFAULT_DB_DIRECTORY = "database";
    private static final String DEFAULT_INDEX_DIRECTORY = "index";
    private static final String DEFAULT_INDEX_SWTICH = "on";
    private static final CompressionType DEFAULT_COMPRESSION_TYPE = CompressionType.SNAPPY;
    private static final int DEFAULT_BLOCK_SIZE = 4096;
    private static final int DEFAULT_WRITE_BUFFER_SIZE = 0xA00000;
    private static final long DEFAULT_CACHE_SIZE = 0xA00000L;
    private static final int DEFAULT_MAX_OPEN_FILES = 100;
    private String dbDirectory;
    private int dbVersion;
    private boolean dbSync;
    private String indexDirectory;
    private String indexSwitch;
    private Map<String, Property> propertyMap;

    public static int getDbVersionFromConfig(Config config) {
        return config.hasPath(DB_VERSION_CONFIG_KEY) ? config.getInt(DB_VERSION_CONFIG_KEY) : 2;
    }

    public static Boolean getDbVersionSyncFromConfig(Config config) {
        return config.hasPath(DB_SYNC_CONFIG_KEY) ? config.getBoolean(DB_SYNC_CONFIG_KEY) : false;
    }

    public static String getDbDirectoryFromConfig(Config config) {
        return config.hasPath(DB_DIRECTORY_CONFIG_KEY) ? config.getString(DB_DIRECTORY_CONFIG_KEY) : DEFAULT_DB_DIRECTORY;
    }

    public static String getIndexDirectoryFromConfig(Config config) {
        return config.hasPath(INDEX_DIRECTORY_CONFIG_KEY) ? config.getString(INDEX_DIRECTORY_CONFIG_KEY) : DEFAULT_INDEX_DIRECTORY;
    }

    public static String getIndexSwitchFromConfig(Config config) {
        return config.hasPath(INDEX_SWITCH_CONFIG_KEY) && StringUtils.isNotEmpty((CharSequence)config.getString(INDEX_SWITCH_CONFIG_KEY)) ? config.getString(INDEX_SWITCH_CONFIG_KEY) : DEFAULT_INDEX_SWTICH;
    }

    public void setPropertyMapFromConfig(Config config) {
        if (config.hasPath(PROPERTIES_CONFIG_KEY)) {
            this.propertyMap = config.getObjectList(PROPERTIES_CONFIG_KEY).stream().map(Storage::createProperty).collect(Collectors.toMap(Property::getName, p -> p));
        }
    }

    public String getPathByDbName(String dbName) {
        if (this.hasProperty(dbName)) {
            return this.getProperty(dbName).getPath();
        }
        return null;
    }

    public Options getOptionsByDbName(String dbName) {
        if (this.hasProperty(dbName)) {
            return this.getProperty(dbName).getDbOptions();
        }
        return Storage.createDefaultDbOptions();
    }

    public void deleteAllStoragePaths() {
        if (this.propertyMap == null) {
            return;
        }
        for (Property property : this.propertyMap.values()) {
            String path = property.getPath();
            if (path == null) continue;
            FileUtil.recursiveDelete(path);
        }
    }

    private boolean hasProperty(String dbName) {
        if (this.propertyMap != null) {
            return this.propertyMap.containsKey(dbName);
        }
        return false;
    }

    private Property getProperty(String dbName) {
        return this.propertyMap.get(dbName);
    }

    private static Property createProperty(ConfigObject conf) {
        Property property = new Property();
        if (!conf.containsKey((Object)NAME_CONFIG_KEY)) {
            throw new IllegalArgumentException("[storage.properties] database name must be set.");
        }
        property.setName(conf.get((Object)NAME_CONFIG_KEY).unwrapped().toString());
        if (conf.containsKey((Object)PATH_CONFIG_KEY)) {
            String path = conf.get((Object)PATH_CONFIG_KEY).unwrapped().toString();
            File file = new File(path);
            if (!file.exists() && !file.mkdirs()) {
                throw new IllegalArgumentException("[storage.properties] can not create storage path: " + path);
            }
            if (!file.canWrite()) {
                throw new IllegalArgumentException("[storage.properties] permission denied to write to: " + path);
            }
            property.setPath(path);
        }
        Options dbOptions = Storage.createDefaultDbOptions();
        if (conf.containsKey((Object)CREATE_IF_MISSING_CONFIG_KEY)) {
            dbOptions.createIfMissing(Boolean.parseBoolean(conf.get((Object)CREATE_IF_MISSING_CONFIG_KEY).unwrapped().toString()));
        }
        if (conf.containsKey((Object)PARANOID_CHECKS_CONFIG_KEY)) {
            dbOptions.paranoidChecks(Boolean.parseBoolean(conf.get((Object)PARANOID_CHECKS_CONFIG_KEY).unwrapped().toString()));
        }
        if (conf.containsKey((Object)VERITY_CHECK_SUMS_CONFIG_KEY)) {
            dbOptions.verifyChecksums(Boolean.parseBoolean(conf.get((Object)VERITY_CHECK_SUMS_CONFIG_KEY).unwrapped().toString()));
        }
        if (conf.containsKey((Object)COMPRESSION_TYPE_CONFIG_KEY)) {
            try {
                dbOptions.compressionType(CompressionType.getCompressionTypeByPersistentId((int)Integer.parseInt(conf.get((Object)COMPRESSION_TYPE_CONFIG_KEY).unwrapped().toString())));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[storage.properties] compressionType must be Integer type.");
            }
        }
        if (conf.containsKey((Object)BLOCK_SIZE_CONFIG_KEY)) {
            try {
                dbOptions.blockSize(Integer.parseInt(conf.get((Object)BLOCK_SIZE_CONFIG_KEY).unwrapped().toString()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[storage.properties] blockSize must be Integer type.");
            }
        }
        if (conf.containsKey((Object)WRITE_BUFFER_SIZE_CONFIG_KEY)) {
            try {
                dbOptions.writeBufferSize(Integer.parseInt(conf.get((Object)WRITE_BUFFER_SIZE_CONFIG_KEY).unwrapped().toString()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[storage.properties] writeBufferSize must be Integer type.");
            }
        }
        if (conf.containsKey((Object)CACHE_SIZE_CONFIG_KEY)) {
            try {
                dbOptions.cacheSize(Long.parseLong(conf.get((Object)CACHE_SIZE_CONFIG_KEY).unwrapped().toString()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[storage.properties] cacheSize must be Long type.");
            }
        }
        if (conf.containsKey((Object)MAX_OPEN_FILES_CONFIG_KEY)) {
            try {
                dbOptions.maxOpenFiles(Integer.parseInt(conf.get((Object)MAX_OPEN_FILES_CONFIG_KEY).unwrapped().toString()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[storage.properties] maxOpenFiles must be Integer type.");
            }
        }
        property.setDbOptions(dbOptions);
        return property;
    }

    private static Options createDefaultDbOptions() {
        Options dbOptions = new Options();
        dbOptions.createIfMissing(true);
        dbOptions.paranoidChecks(true);
        dbOptions.verifyChecksums(true);
        dbOptions.compressionType(DEFAULT_COMPRESSION_TYPE);
        dbOptions.blockSize(4096);
        dbOptions.writeBufferSize(0xA00000);
        dbOptions.cacheSize(0xA00000L);
        dbOptions.maxOpenFiles(100);
        return dbOptions;
    }

    public String getDbDirectory() {
        return this.dbDirectory;
    }

    public void setDbDirectory(String dbDirectory) {
        this.dbDirectory = dbDirectory;
    }

    public int getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(int dbVersion) {
        this.dbVersion = dbVersion;
    }

    public boolean isDbSync() {
        return this.dbSync;
    }

    public void setDbSync(boolean dbSync) {
        this.dbSync = dbSync;
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(String indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public String getIndexSwitch() {
        return this.indexSwitch;
    }

    public void setIndexSwitch(String indexSwitch) {
        this.indexSwitch = indexSwitch;
    }

    private static class Property {
        private String name;
        private String path;
        private Options dbOptions;

        private Property() {
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public Options getDbOptions() {
            return this.dbOptions;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setDbOptions(Options dbOptions) {
            this.dbOptions = dbOptions;
        }
    }
}

