/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.tron.common.utils.Sha256Hash;

public class MerkleTree {
    private static volatile MerkleTree instance;
    private List<Sha256Hash> hashList;
    private List<Leaf> leaves;
    private Leaf root;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MerkleTree getInstance() {
        if (instance != null) return instance;
        Class<MerkleTree> clazz = MerkleTree.class;
        synchronized (MerkleTree.class) {
            if (instance != null) return instance;
            instance = new MerkleTree();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public MerkleTree createTree(List<Sha256Hash> hashList) {
        this.leaves = new ArrayList<Leaf>();
        this.hashList = hashList;
        List<Leaf> leaves = this.createLeaves(hashList);
        while (leaves.size() > 1) {
            leaves = this.createParentLeaves(leaves);
        }
        this.root = leaves.get(0);
        return this;
    }

    private List<Leaf> createParentLeaves(List<Leaf> leaves) {
        int step = 2;
        int len = leaves.size();
        return IntStream.iterate(0, i -> i + step).limit(len).filter(i -> i < len).mapToObj(i -> {
            Leaf right = i + 1 < len ? (Leaf)leaves.get(i + 1) : null;
            return this.createLeaf((Leaf)leaves.get(i), right);
        }).collect(Collectors.toList());
    }

    private List<Leaf> createLeaves(List<Sha256Hash> hashList) {
        int step = 2;
        int len = hashList.size();
        return IntStream.iterate(0, i -> i + step).limit(len).filter(i -> i < len).mapToObj(i -> {
            Leaf right = i + 1 < len ? this.createLeaf((Sha256Hash)hashList.get(i + 1)) : null;
            return this.createLeaf(this.createLeaf((Sha256Hash)hashList.get(i)), right);
        }).collect(Collectors.toList());
    }

    private Leaf createLeaf(Leaf left, Leaf right) {
        Leaf leaf = new Leaf();
        leaf.hash = right == null ? left.hash : this.computeHash(left.hash, right.hash);
        leaf.left = left;
        leaf.right = right;
        this.leaves.add(leaf);
        return leaf;
    }

    private Leaf createLeaf(Sha256Hash hash) {
        Leaf leaf = new Leaf();
        leaf.hash = hash;
        this.leaves.add(leaf);
        return leaf;
    }

    private Sha256Hash computeHash(Sha256Hash leftHash, Sha256Hash rightHash) {
        return Sha256Hash.of(leftHash.getByteString().concat(rightHash.getByteString()).toByteArray());
    }

    public List<Sha256Hash> getHashList() {
        return this.hashList;
    }

    public List<Leaf> getLeaves() {
        return this.leaves;
    }

    public Leaf getRoot() {
        return this.root;
    }

    public class Leaf {
        private Sha256Hash hash;
        private Leaf left;
        private Leaf right;

        public Sha256Hash getHash() {
            return this.hash;
        }

        public Leaf getLeft() {
            return this.left;
        }

        public Leaf getRight() {
            return this.right;
        }
    }
}

