/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.ProtoCapsule;

public class StorageRowCapsule
implements ProtoCapsule<byte[]> {
    private static final Logger logger = LoggerFactory.getLogger(StorageRowCapsule.class);
    private byte[] rowValue;
    private byte[] rowKey;
    private boolean dirty = false;

    public StorageRowCapsule(StorageRowCapsule rowCapsule) {
        this.rowKey = (byte[])rowCapsule.getRowKey().clone();
        this.rowValue = (byte[])rowCapsule.getRowValue().clone();
        this.dirty = rowCapsule.isDirty();
    }

    public StorageRowCapsule(byte[] rowKey, byte[] rowValue) {
        this.rowKey = rowKey;
        this.rowValue = rowValue;
        this.markDirty();
    }

    public StorageRowCapsule(byte[] rowValue) {
        this.rowValue = rowValue;
    }

    private void markDirty() {
        this.dirty = true;
    }

    public Sha256Hash getHash() {
        return Sha256Hash.of(this.rowValue);
    }

    public DataWord getValue() {
        return new DataWord(this.rowValue);
    }

    public void setValue(DataWord value) {
        this.rowValue = value.getData();
        this.markDirty();
    }

    @Override
    public byte[] getData() {
        return this.rowValue;
    }

    @Override
    public byte[] getInstance() {
        return this.rowValue;
    }

    public String toString() {
        return Arrays.toString(this.rowValue);
    }

    public byte[] getRowValue() {
        return this.rowValue;
    }

    public void setRowKey(byte[] rowKey) {
        this.rowKey = rowKey;
    }

    public byte[] getRowKey() {
        return this.rowKey;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

