/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.protos.Protocol;

public class DelegatedResourceCapsule
implements ProtoCapsule<Protocol.DelegatedResource> {
    private static final Logger logger = LoggerFactory.getLogger(DelegatedResourceCapsule.class);
    private Protocol.DelegatedResource delegatedResource;

    public DelegatedResourceCapsule(Protocol.DelegatedResource delegatedResource) {
        this.delegatedResource = delegatedResource;
    }

    public DelegatedResourceCapsule(byte[] data) {
        try {
            this.delegatedResource = Protocol.DelegatedResource.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public DelegatedResourceCapsule(ByteString from, ByteString to) {
        this.delegatedResource = Protocol.DelegatedResource.newBuilder().setFrom(from).setTo(to).build();
    }

    public ByteString getFrom() {
        return this.delegatedResource.getFrom();
    }

    public ByteString getTo() {
        return this.delegatedResource.getTo();
    }

    public long getFrozenBalanceForEnergy() {
        return this.delegatedResource.getFrozenBalanceForEnergy();
    }

    public void setFrozenBalanceForEnergy(long energy, long expireTime) {
        this.delegatedResource = this.delegatedResource.toBuilder().setFrozenBalanceForEnergy(energy).setExpireTimeForEnergy(expireTime).build();
    }

    public void addFrozenBalanceForEnergy(long energy, long expireTime) {
        this.delegatedResource = this.delegatedResource.toBuilder().setFrozenBalanceForEnergy(this.delegatedResource.getFrozenBalanceForEnergy() + energy).setExpireTimeForEnergy(expireTime).build();
    }

    public long getFrozenBalanceForBandwidth() {
        return this.delegatedResource.getFrozenBalanceForBandwidth();
    }

    public void setFrozenBalanceForBandwidth(long Bandwidth, long expireTime) {
        this.delegatedResource = this.delegatedResource.toBuilder().setFrozenBalanceForBandwidth(Bandwidth).setExpireTimeForBandwidth(expireTime).build();
    }

    public void addFrozenBalanceForBandwidth(long Bandwidth, long expireTime) {
        this.delegatedResource = this.delegatedResource.toBuilder().setFrozenBalanceForBandwidth(this.delegatedResource.getFrozenBalanceForBandwidth() + Bandwidth).setExpireTimeForBandwidth(expireTime).build();
    }

    public long getExpireTimeForBandwidth() {
        return this.delegatedResource.getExpireTimeForBandwidth();
    }

    public long getExpireTimeForEnergy() {
        return this.delegatedResource.getExpireTimeForBandwidth();
    }

    public void setExpireTimeForBandwidth(long ExpireTime) {
        this.delegatedResource = this.delegatedResource.toBuilder().setExpireTimeForBandwidth(ExpireTime).build();
    }

    public void setExpireTimeForEnergy(long ExpireTime) {
        this.delegatedResource = this.delegatedResource.toBuilder().setExpireTimeForEnergy(ExpireTime).build();
    }

    public byte[] createDbKey() {
        return DelegatedResourceCapsule.createDbKey(this.delegatedResource.getFrom().toByteArray(), this.delegatedResource.getTo().toByteArray());
    }

    public static byte[] createDbKey(byte[] from, byte[] to) {
        byte[] key = new byte[from.length + to.length];
        System.arraycopy(from, 0, key, 0, from.length);
        System.arraycopy(to, 0, key, from.length, to.length);
        return key;
    }

    @Override
    public byte[] getData() {
        return this.delegatedResource.toByteArray();
    }

    @Override
    public Protocol.DelegatedResource getInstance() {
        return this.delegatedResource;
    }
}

