/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.math.LongMath;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class WithdrawBalanceActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(WithdrawBalanceActuator.class);

    WithdrawBalanceActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        Contract.WithdrawBalanceContract withdrawBalanceContract;
        long fee = this.calcFee();
        try {
            withdrawBalanceContract = (Contract.WithdrawBalanceContract)this.contract.unpack(Contract.WithdrawBalanceContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        AccountCapsule accountCapsule = Objects.isNull(this.getDeposit()) ? this.dbManager.getAccountStore().get(withdrawBalanceContract.getOwnerAddress().toByteArray()) : this.getDeposit().getAccount(withdrawBalanceContract.getOwnerAddress().toByteArray());
        long oldBalance = accountCapsule.getBalance();
        long allowance = accountCapsule.getAllowance();
        long now = this.dbManager.getHeadBlockTimeStamp();
        accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(oldBalance + allowance).setAllowance(0L).setLatestWithdrawTime(now).build());
        if (Objects.isNull(this.getDeposit())) {
            this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        } else {
            this.deposit.putAccountValue(accountCapsule.createDbKey(), accountCapsule);
        }
        ret.setWithdrawAmount(allowance);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        long witnessAllowanceFrozenTime;
        AccountCapsule accountCapsule;
        Contract.WithdrawBalanceContract withdrawBalanceContract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null && (this.getDeposit() == null || this.getDeposit().getDbManager() == null)) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.WithdrawBalanceContract.class)) {
            throw new ContractValidateException("contract type error,expected type [WithdrawBalanceContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            withdrawBalanceContract = (Contract.WithdrawBalanceContract)this.contract.unpack(Contract.WithdrawBalanceContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = withdrawBalanceContract.getOwnerAddress().toByteArray();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule2 = accountCapsule = Objects.isNull(this.getDeposit()) ? this.dbManager.getAccountStore().get(ownerAddress) : this.getDeposit().getAccount(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
        if (!this.dbManager.getWitnessStore().has(ownerAddress)) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] is not a witnessAccount");
        }
        boolean isGP = Args.getInstance().getGenesisBlock().getWitnesses().stream().anyMatch(witness -> Arrays.equals(ownerAddress, witness.getAddress()));
        if (isGP) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] is a guard representative and is not allowed to withdraw Balance");
        }
        long latestWithdrawTime = accountCapsule.getLatestWithdrawTime();
        long now = this.dbManager.getHeadBlockTimeStamp();
        long l = witnessAllowanceFrozenTime = Objects.isNull(this.getDeposit()) ? (long)this.dbManager.getDynamicPropertiesStore().getWitnessAllowanceFrozenTime() * 86400000L : this.getDeposit().getWitnessAllowanceFrozenTime() * 86400000L;
        if (now - latestWithdrawTime < witnessAllowanceFrozenTime) {
            throw new ContractValidateException("The last withdraw time is " + latestWithdrawTime + ",less than 24 hours");
        }
        if (accountCapsule.getAllowance() <= 0L) {
            throw new ContractValidateException("witnessAccount does not have any allowance");
        }
        try {
            LongMath.checkedAdd((long)accountCapsule.getBalance(), (long)accountCapsule.getAllowance());
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.WithdrawBalanceContract)this.contract.unpack(Contract.WithdrawBalanceContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

