/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.AccountStore;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class UpdateSettingContractActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSettingContractActuator.class);

    UpdateSettingContractActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.UpdateSettingContract usContract = (Contract.UpdateSettingContract)this.contract.unpack(Contract.UpdateSettingContract.class);
            long newPercent = usContract.getConsumeUserResourcePercent();
            byte[] contractAddress = usContract.getContractAddress().toByteArray();
            ContractCapsule deployedContract = this.dbManager.getContractStore().get(contractAddress);
            this.dbManager.getContractStore().put(contractAddress, new ContractCapsule(deployedContract.getInstance().toBuilder().setConsumeUserResourcePercent(newPercent).build()));
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.UpdateSettingContract contract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.UpdateSettingContract.class)) {
            throw new ContractValidateException("contract type error,expected type [UpdateSettingContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            contract = (Contract.UpdateSettingContract)this.contract.unpack(Contract.UpdateSettingContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        if (!Wallet.addressValid(contract.getOwnerAddress().toByteArray())) {
            throw new ContractValidateException("Invalid address");
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
        AccountStore accountStore = this.dbManager.getAccountStore();
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule == null) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long newPercent = contract.getConsumeUserResourcePercent();
        if (newPercent > 100L || newPercent < 0L) {
            throw new ContractValidateException("percent not in [0, 100]");
        }
        byte[] contractAddress = contract.getContractAddress().toByteArray();
        ContractCapsule deployedContract = this.dbManager.getContractStore().get(contractAddress);
        if (deployedContract == null) {
            throw new ContractValidateException("Contract not exists");
        }
        byte[] deployedContractOwnerAddress = deployedContract.getInstance().getOriginAddress().toByteArray();
        if (!Arrays.equals(ownerAddress, deployedContractOwnerAddress)) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] is not the owner of the contract");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.UpdateSettingContract)this.contract.unpack(Contract.UpdateSettingContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

