/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.collect.Lists;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class UnfreezeAssetActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(UnfreezeAssetActuator.class);

    UnfreezeAssetActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.UnfreezeAssetContract unfreezeAssetContract = (Contract.UnfreezeAssetContract)this.contract.unpack(Contract.UnfreezeAssetContract.class);
            byte[] ownerAddress = unfreezeAssetContract.getOwnerAddress().toByteArray();
            AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
            long unfreezeAsset = 0L;
            ArrayList frozenList = Lists.newArrayList();
            frozenList.addAll(accountCapsule.getFrozenSupplyList());
            Iterator iterator = frozenList.iterator();
            long now = this.dbManager.getHeadBlockTimeStamp();
            while (iterator.hasNext()) {
                Protocol.Account.Frozen next = (Protocol.Account.Frozen)iterator.next();
                if (next.getExpireTime() > now) continue;
                unfreezeAsset += next.getFrozenBalance();
                iterator.remove();
            }
            if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
                accountCapsule.addAssetAmountV2(accountCapsule.getAssetIssuedName().toByteArray(), unfreezeAsset, this.dbManager);
            } else {
                accountCapsule.addAssetAmountV2(accountCapsule.getAssetIssuedID().toByteArray(), unfreezeAsset, this.dbManager);
            }
            accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().clearFrozenSupply().addAllFrozenSupply(frozenList).build());
            this.dbManager.getAccountStore().put(ownerAddress, accountCapsule);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.UnfreezeAssetContract unfreezeAssetContract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.UnfreezeAssetContract.class)) {
            throw new ContractValidateException("contract type error,expected type [UnfreezeAssetContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            unfreezeAssetContract = (Contract.UnfreezeAssetContract)this.contract.unpack(Contract.UnfreezeAssetContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = unfreezeAssetContract.getOwnerAddress().toByteArray();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        if (accountCapsule.getFrozenSupplyCount() <= 0) {
            throw new ContractValidateException("no frozen supply balance");
        }
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L ? accountCapsule.getAssetIssuedName().isEmpty() : accountCapsule.getAssetIssuedID().isEmpty()) {
            throw new ContractValidateException("this account did not issue any asset");
        }
        long now = this.dbManager.getHeadBlockTimeStamp();
        long allowedUnfreezeCount = accountCapsule.getFrozenSupplyList().stream().filter(frozen -> frozen.getExpireTime() <= now).count();
        if (allowedUnfreezeCount <= 0L) {
            throw new ContractValidateException("It's not time to unfreeze asset supply");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.UnfreezeAssetContract)this.contract.unpack(Contract.UnfreezeAssetContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

