/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.db.AccountIdIndexStore;
import org.tron.core.db.AccountStore;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class SetAccountIdActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(SetAccountIdActuator.class);

    SetAccountIdActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        Contract.SetAccountIdContract setAccountIdContract;
        long fee = this.calcFee();
        try {
            setAccountIdContract = (Contract.SetAccountIdContract)this.contract.unpack(Contract.SetAccountIdContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        byte[] ownerAddress = setAccountIdContract.getOwnerAddress().toByteArray();
        AccountStore accountStore = this.dbManager.getAccountStore();
        AccountIdIndexStore accountIdIndexStore = this.dbManager.getAccountIdIndexStore();
        AccountCapsule account = accountStore.get(ownerAddress);
        account.setAccountId(setAccountIdContract.getAccountId().toByteArray());
        accountStore.put(ownerAddress, account);
        accountIdIndexStore.put(account);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.SetAccountIdContract setAccountIdContract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.SetAccountIdContract.class)) {
            throw new ContractValidateException("contract type error,expected type [SetAccountIdContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            setAccountIdContract = (Contract.SetAccountIdContract)this.contract.unpack(Contract.SetAccountIdContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = setAccountIdContract.getOwnerAddress().toByteArray();
        byte[] accountId = setAccountIdContract.getAccountId().toByteArray();
        if (!TransactionUtil.validAccountId(accountId)) {
            throw new ContractValidateException("Invalid accountId");
        }
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        AccountCapsule account = this.dbManager.getAccountStore().get(ownerAddress);
        if (account == null) {
            throw new ContractValidateException("Account has not existed");
        }
        if (account.getAccountId() != null && !account.getAccountId().isEmpty()) {
            throw new ContractValidateException("This account id already set");
        }
        if (this.dbManager.getAccountIdIndexStore().has(accountId)) {
            throw new ContractValidateException("This id has existed");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.SetAccountIdContract)this.contract.unpack(Contract.SetAccountIdContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

