/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.Manager;
import org.tron.core.db.StorageMarket;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class SellStorageActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(SellStorageActuator.class);
    private StorageMarket storageMarket;

    SellStorageActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
        this.storageMarket = new StorageMarket(dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        Contract.SellStorageContract sellStorageContract;
        long fee = this.calcFee();
        try {
            sellStorageContract = (Contract.SellStorageContract)this.contract.unpack(Contract.SellStorageContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(sellStorageContract.getOwnerAddress().toByteArray());
        long bytes = sellStorageContract.getStorageBytes();
        this.storageMarket.sellStorage(accountCapsule, bytes);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.SellStorageContract sellStorageContract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.SellStorageContract.class)) {
            throw new ContractValidateException("contract type error,expected type [SellStorageContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            sellStorageContract = (Contract.SellStorageContract)this.contract.unpack(Contract.SellStorageContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = sellStorageContract.getOwnerAddress().toByteArray();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long bytes = sellStorageContract.getStorageBytes();
        if (bytes <= 0L) {
            throw new ContractValidateException("bytes must be positive");
        }
        long currentStorageLimit = accountCapsule.getStorageLimit();
        long currentUnusedStorage = currentStorageLimit - accountCapsule.getStorageUsage();
        if (bytes > currentUnusedStorage) {
            throw new ContractValidateException("bytes must be less than currentUnusedStorage[" + currentUnusedStorage + "]");
        }
        long quantity = this.storageMarket.trySellStorage(bytes);
        if (quantity <= 1000000L) {
            throw new ContractValidateException("quantity must be larger than 1TRX,current quantity[" + quantity + "]");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.SellStorageContract)this.contract.unpack(Contract.SellStorageContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

