/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class ProposalDeleteActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(ProposalDeleteActuator.class);

    ProposalDeleteActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.ProposalDeleteContract proposalDeleteContract = (Contract.ProposalDeleteContract)this.contract.unpack(Contract.ProposalDeleteContract.class);
            ProposalCapsule proposalCapsule = Objects.isNull(this.deposit) ? this.dbManager.getProposalStore().get(ByteArray.fromLong(proposalDeleteContract.getProposalId())) : this.deposit.getProposalCapsule(ByteArray.fromLong(proposalDeleteContract.getProposalId()));
            proposalCapsule.setState(Protocol.Proposal.State.CANCELED);
            if (Objects.isNull(this.deposit)) {
                this.dbManager.getProposalStore().put(proposalCapsule.createDbKey(), proposalCapsule);
            } else {
                this.deposit.putProposalValue(proposalCapsule.createDbKey(), proposalCapsule);
            }
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (ItemNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        ProposalCapsule proposalCapsule;
        long latestProposalNum;
        Contract.ProposalDeleteContract contract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null && (this.deposit == null || this.deposit.getDbManager() == null)) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.ProposalDeleteContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ProposalDeleteContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            contract = (Contract.ProposalDeleteContract)this.contract.unpack(Contract.ProposalDeleteContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!Objects.isNull(this.deposit) ? Objects.isNull(this.deposit.getAccount(ownerAddress)) : !this.dbManager.getAccountStore().has(ownerAddress)) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long l = latestProposalNum = Objects.isNull(this.deposit) ? this.dbManager.getDynamicPropertiesStore().getLatestProposalNum() : this.deposit.getLatestProposalNum();
        if (contract.getProposalId() > latestProposalNum) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] not exists");
        }
        try {
            proposalCapsule = Objects.isNull(this.getDeposit()) ? this.dbManager.getProposalStore().get(ByteArray.fromLong(contract.getProposalId())) : this.deposit.getProposalCapsule(ByteArray.fromLong(contract.getProposalId()));
        }
        catch (ItemNotFoundException ex) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] not exists");
        }
        long now = this.dbManager.getHeadBlockTimeStamp();
        if (!proposalCapsule.getProposalAddress().equals((Object)contract.getOwnerAddress())) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] is not proposed by " + readableOwnerAddress);
        }
        if (now >= proposalCapsule.getExpirationTime()) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] expired");
        }
        if (proposalCapsule.getState() == Protocol.Proposal.State.CANCELED) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] canceled");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.ProposalDeleteContract)this.contract.unpack(Contract.ProposalDeleteContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

