/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class FreezeBalanceActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(FreezeBalanceActuator.class);

    FreezeBalanceActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        Contract.FreezeBalanceContract freezeBalanceContract;
        long fee = this.calcFee();
        try {
            freezeBalanceContract = (Contract.FreezeBalanceContract)this.contract.unpack(Contract.FreezeBalanceContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(freezeBalanceContract.getOwnerAddress().toByteArray());
        long now = this.dbManager.getHeadBlockTimeStamp();
        long duration = freezeBalanceContract.getFrozenDuration() * 86400000L;
        long newBalance = accountCapsule.getBalance() - freezeBalanceContract.getFrozenBalance();
        long frozenBalance = freezeBalanceContract.getFrozenBalance();
        long expireTime = now + duration;
        byte[] ownerAddress = freezeBalanceContract.getOwnerAddress().toByteArray();
        byte[] receiverAddress = freezeBalanceContract.getReceiverAddress().toByteArray();
        switch (freezeBalanceContract.getResource()) {
            case BANDWIDTH: {
                if (!ArrayUtils.isEmpty((byte[])receiverAddress) && this.dbManager.getDynamicPropertiesStore().supportDR()) {
                    this.delegateResource(ownerAddress, receiverAddress, true, frozenBalance, expireTime);
                    accountCapsule.addDelegatedFrozenBalanceForBandwidth(frozenBalance);
                } else {
                    long newFrozenBalanceForBandwidth = frozenBalance + accountCapsule.getFrozenBalance();
                    accountCapsule.setFrozenForBandwidth(newFrozenBalanceForBandwidth, expireTime);
                }
                this.dbManager.getDynamicPropertiesStore().addTotalNetWeight(frozenBalance / 1000000L);
                break;
            }
            case ENERGY: {
                if (!ArrayUtils.isEmpty((byte[])receiverAddress) && this.dbManager.getDynamicPropertiesStore().supportDR()) {
                    this.delegateResource(ownerAddress, receiverAddress, false, frozenBalance, expireTime);
                    accountCapsule.addDelegatedFrozenBalanceForEnergy(frozenBalance);
                } else {
                    long newFrozenBalanceForEnergy = frozenBalance + accountCapsule.getAccountResource().getFrozenBalanceForEnergy().getFrozenBalance();
                    accountCapsule.setFrozenForEnergy(newFrozenBalanceForEnergy, expireTime);
                }
                this.dbManager.getDynamicPropertiesStore().addTotalEnergyWeight(frozenBalance / 1000000L);
            }
        }
        accountCapsule.setBalance(newBalance);
        this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        boolean needCheckFrozeTime;
        Contract.FreezeBalanceContract freezeBalanceContract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.FreezeBalanceContract.class)) {
            throw new ContractValidateException("contract type error,expected type [FreezeBalanceContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            freezeBalanceContract = (Contract.FreezeBalanceContract)this.contract.unpack(Contract.FreezeBalanceContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = freezeBalanceContract.getOwnerAddress().toByteArray();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long frozenBalance = freezeBalanceContract.getFrozenBalance();
        if (frozenBalance <= 0L) {
            throw new ContractValidateException("frozenBalance must be positive");
        }
        if (frozenBalance < 1000000L) {
            throw new ContractValidateException("frozenBalance must be more than 1TRX");
        }
        int frozenCount = accountCapsule.getFrozenCount();
        if (frozenCount != 0 && frozenCount != 1) {
            throw new ContractValidateException("frozenCount must be 0 or 1");
        }
        if (frozenBalance > accountCapsule.getBalance()) {
            throw new ContractValidateException("frozenBalance must be less than accountBalance");
        }
        long frozenDuration = freezeBalanceContract.getFrozenDuration();
        long minFrozenTime = this.dbManager.getDynamicPropertiesStore().getMinFrozenTime();
        long maxFrozenTime = this.dbManager.getDynamicPropertiesStore().getMaxFrozenTime();
        boolean bl = needCheckFrozeTime = Args.getInstance().getCheckFrozenTime() == 1;
        if (needCheckFrozeTime && (frozenDuration < minFrozenTime || frozenDuration > maxFrozenTime)) {
            throw new ContractValidateException("frozenDuration must be less than " + maxFrozenTime + " days and more than " + minFrozenTime + " days");
        }
        switch (freezeBalanceContract.getResource()) {
            case BANDWIDTH: {
                break;
            }
            case ENERGY: {
                break;
            }
            default: {
                throw new ContractValidateException("ResourceCode error,valid ResourceCode[BANDWIDTH\u3001ENERGY]");
            }
        }
        byte[] receiverAddress = freezeBalanceContract.getReceiverAddress().toByteArray();
        if (!ArrayUtils.isEmpty((byte[])receiverAddress) && this.dbManager.getDynamicPropertiesStore().supportDR()) {
            if (Arrays.equals(receiverAddress, ownerAddress)) {
                throw new ContractValidateException("receiverAddress must not be the same as ownerAddress");
            }
            if (!Wallet.addressValid(receiverAddress)) {
                throw new ContractValidateException("Invalid receiverAddress");
            }
            AccountCapsule receiverCapsule = this.dbManager.getAccountStore().get(receiverAddress);
            if (receiverCapsule == null) {
                String readableOwnerAddress = StringUtil.createReadableString(receiverAddress);
                throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
            }
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.FreezeBalanceContract)this.contract.unpack(Contract.FreezeBalanceContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }

    private void delegateResource(byte[] ownerAddress, byte[] receiverAddress, boolean isBandwidth, long balance, long expireTime) {
        List<ByteString> fromAccountsList;
        List<ByteString> toAccountsList;
        byte[] key = DelegatedResourceCapsule.createDbKey(ownerAddress, receiverAddress);
        DelegatedResourceCapsule delegatedResourceCapsule = this.dbManager.getDelegatedResourceStore().get(key);
        if (delegatedResourceCapsule != null) {
            if (isBandwidth) {
                delegatedResourceCapsule.addFrozenBalanceForBandwidth(balance, expireTime);
            } else {
                delegatedResourceCapsule.addFrozenBalanceForEnergy(balance, expireTime);
            }
        } else {
            delegatedResourceCapsule = new DelegatedResourceCapsule(ByteString.copyFrom((byte[])ownerAddress), ByteString.copyFrom((byte[])receiverAddress));
            if (isBandwidth) {
                delegatedResourceCapsule.setFrozenBalanceForBandwidth(balance, expireTime);
            } else {
                delegatedResourceCapsule.setFrozenBalanceForEnergy(balance, expireTime);
            }
        }
        this.dbManager.getDelegatedResourceStore().put(key, delegatedResourceCapsule);
        DelegatedResourceAccountIndexCapsule delegatedResourceAccountIndexCapsule = this.dbManager.getDelegatedResourceAccountIndexStore().get(ownerAddress);
        if (delegatedResourceAccountIndexCapsule == null) {
            delegatedResourceAccountIndexCapsule = new DelegatedResourceAccountIndexCapsule(ByteString.copyFrom((byte[])ownerAddress));
        }
        if (!(toAccountsList = delegatedResourceAccountIndexCapsule.getToAccountsList()).contains(ByteString.copyFrom((byte[])receiverAddress))) {
            delegatedResourceAccountIndexCapsule.addToAccount(ByteString.copyFrom((byte[])receiverAddress));
        }
        this.dbManager.getDelegatedResourceAccountIndexStore().put(ownerAddress, delegatedResourceAccountIndexCapsule);
        delegatedResourceAccountIndexCapsule = this.dbManager.getDelegatedResourceAccountIndexStore().get(receiverAddress);
        if (delegatedResourceAccountIndexCapsule == null) {
            delegatedResourceAccountIndexCapsule = new DelegatedResourceAccountIndexCapsule(ByteString.copyFrom((byte[])receiverAddress));
        }
        if (!(fromAccountsList = delegatedResourceAccountIndexCapsule.getFromAccountsList()).contains(ByteString.copyFrom((byte[])ownerAddress))) {
            delegatedResourceAccountIndexCapsule.addFromAccount(ByteString.copyFrom((byte[])ownerAddress));
        }
        this.dbManager.getDelegatedResourceAccountIndexStore().put(receiverAddress, delegatedResourceAccountIndexCapsule);
        AccountCapsule receiverCapsule = this.dbManager.getAccountStore().get(receiverAddress);
        if (isBandwidth) {
            receiverCapsule.addAcquiredDelegatedFrozenBalanceForBandwidth(balance);
        } else {
            receiverCapsule.addAcquiredDelegatedFrozenBalanceForEnergy(balance);
        }
        this.dbManager.getAccountStore().put(receiverCapsule.createDbKey(), receiverCapsule);
    }
}

