/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigInteger;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class ExchangeInjectActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeInjectActuator.class);

    ExchangeInjectActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            long anotherTokenQuant;
            byte[] anotherTokenID;
            Contract.ExchangeInjectContract exchangeInjectContract = (Contract.ExchangeInjectContract)this.contract.unpack(Contract.ExchangeInjectContract.class);
            AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(exchangeInjectContract.getOwnerAddress().toByteArray());
            ExchangeCapsule exchangeCapsule = this.dbManager.getExchangeStoreFinal().get(ByteArray.fromLong(exchangeInjectContract.getExchangeId()));
            byte[] firstTokenID = exchangeCapsule.getFirstTokenId();
            byte[] secondTokenID = exchangeCapsule.getSecondTokenId();
            long firstTokenBalance = exchangeCapsule.getFirstTokenBalance();
            long secondTokenBalance = exchangeCapsule.getSecondTokenBalance();
            byte[] tokenID = exchangeInjectContract.getTokenId().toByteArray();
            long tokenQuant = exchangeInjectContract.getQuant();
            if (Arrays.equals(tokenID, firstTokenID)) {
                anotherTokenID = secondTokenID;
                anotherTokenQuant = Math.floorDiv(Math.multiplyExact(secondTokenBalance, tokenQuant), firstTokenBalance);
                exchangeCapsule.setBalance(firstTokenBalance + tokenQuant, secondTokenBalance + anotherTokenQuant);
            } else {
                anotherTokenID = firstTokenID;
                anotherTokenQuant = Math.floorDiv(Math.multiplyExact(firstTokenBalance, tokenQuant), secondTokenBalance);
                exchangeCapsule.setBalance(firstTokenBalance + anotherTokenQuant, secondTokenBalance + tokenQuant);
            }
            long newBalance = accountCapsule.getBalance() - this.calcFee();
            accountCapsule.setBalance(newBalance);
            if (Arrays.equals(tokenID, "_".getBytes())) {
                accountCapsule.setBalance(newBalance - tokenQuant);
            } else {
                accountCapsule.reduceAssetAmountV2(tokenID, tokenQuant, this.dbManager);
            }
            if (Arrays.equals(anotherTokenID, "_".getBytes())) {
                accountCapsule.setBalance(newBalance - anotherTokenQuant);
            } else {
                accountCapsule.reduceAssetAmountV2(anotherTokenID, anotherTokenQuant, this.dbManager);
            }
            this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
            this.dbManager.putExchangeCapsule(exchangeCapsule);
            ret.setExchangeInjectAnotherAmount(anotherTokenQuant);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (ItemNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        long newAnotherTokenBalance;
        long newTokenBalance;
        long anotherTokenQuant;
        byte[] anotherTokenID;
        ExchangeCapsule exchangeCapsule;
        Contract.ExchangeInjectContract contract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.ExchangeInjectContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ExchangeInjectContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            contract = (Contract.ExchangeInjectContract)this.contract.unpack(Contract.ExchangeInjectContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!this.dbManager.getAccountStore().has(ownerAddress)) {
            throw new ContractValidateException("account[" + readableOwnerAddress + "] not exists");
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        if (accountCapsule.getBalance() < this.calcFee()) {
            throw new ContractValidateException("No enough balance for exchange inject fee!");
        }
        try {
            exchangeCapsule = this.dbManager.getExchangeStoreFinal().get(ByteArray.fromLong(contract.getExchangeId()));
        }
        catch (ItemNotFoundException ex) {
            throw new ContractValidateException("Exchange[" + contract.getExchangeId() + "] not exists");
        }
        if (!accountCapsule.getAddress().equals((Object)exchangeCapsule.getCreatorAddress())) {
            throw new ContractValidateException("account[" + readableOwnerAddress + "] is not creator");
        }
        byte[] firstTokenID = exchangeCapsule.getFirstTokenId();
        byte[] secondTokenID = exchangeCapsule.getSecondTokenId();
        long firstTokenBalance = exchangeCapsule.getFirstTokenBalance();
        long secondTokenBalance = exchangeCapsule.getSecondTokenBalance();
        byte[] tokenID = contract.getTokenId().toByteArray();
        long tokenQuant = contract.getQuant();
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 1L && !Arrays.equals(tokenID, "_".getBytes()) && !TransactionUtil.isNumber(tokenID)) {
            throw new ContractValidateException("token id is not a valid number");
        }
        if (!Arrays.equals(tokenID, firstTokenID) && !Arrays.equals(tokenID, secondTokenID)) {
            throw new ContractValidateException("token id is not in exchange");
        }
        if (firstTokenBalance == 0L || secondTokenBalance == 0L) {
            throw new ContractValidateException("Token balance in exchange is equal with 0,the exchange has been closed");
        }
        if (tokenQuant <= 0L) {
            throw new ContractValidateException("injected token quant must greater than zero");
        }
        BigInteger bigFirstTokenBalance = new BigInteger(String.valueOf(firstTokenBalance));
        BigInteger bigSecondTokenBalance = new BigInteger(String.valueOf(secondTokenBalance));
        BigInteger bigTokenQuant = new BigInteger(String.valueOf(tokenQuant));
        if (Arrays.equals(tokenID, firstTokenID)) {
            anotherTokenID = secondTokenID;
            anotherTokenQuant = bigSecondTokenBalance.multiply(bigTokenQuant).divide(bigFirstTokenBalance).longValueExact();
            newTokenBalance = firstTokenBalance + tokenQuant;
            newAnotherTokenBalance = secondTokenBalance + anotherTokenQuant;
        } else {
            anotherTokenID = firstTokenID;
            anotherTokenQuant = bigFirstTokenBalance.multiply(bigTokenQuant).divide(bigSecondTokenBalance).longValueExact();
            newTokenBalance = secondTokenBalance + tokenQuant;
            newAnotherTokenBalance = firstTokenBalance + anotherTokenQuant;
        }
        if (anotherTokenQuant <= 0L) {
            throw new ContractValidateException("the calculated token quant  must be greater than 0");
        }
        long balanceLimit = this.dbManager.getDynamicPropertiesStore().getExchangeBalanceLimit();
        if (newTokenBalance > balanceLimit || newAnotherTokenBalance > balanceLimit) {
            throw new ContractValidateException("token balance must less than " + balanceLimit);
        }
        if (Arrays.equals(tokenID, "_".getBytes())) {
            if (accountCapsule.getBalance() < tokenQuant + this.calcFee()) {
                throw new ContractValidateException("balance is not enough");
            }
        } else if (!accountCapsule.assetBalanceEnoughV2(tokenID, tokenQuant, this.dbManager)) {
            throw new ContractValidateException("token balance is not enough");
        }
        if (Arrays.equals(anotherTokenID, "_".getBytes())) {
            if (accountCapsule.getBalance() < anotherTokenQuant + this.calcFee()) {
                throw new ContractValidateException("balance is not enough");
            }
        } else if (!accountCapsule.assetBalanceEnoughV2(anotherTokenID, anotherTokenQuant, this.dbManager)) {
            throw new ContractValidateException("another token balance is not enough");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.ExchangeInjectContract)this.contract.unpack(Contract.ExchangeInjectContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

