/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.actuator.Actuator;
import org.tron.core.actuator.AssetIssueActuator;
import org.tron.core.actuator.CreateAccountActuator;
import org.tron.core.actuator.ExchangeCreateActuator;
import org.tron.core.actuator.ExchangeInjectActuator;
import org.tron.core.actuator.ExchangeTransactionActuator;
import org.tron.core.actuator.ExchangeWithdrawActuator;
import org.tron.core.actuator.FreezeBalanceActuator;
import org.tron.core.actuator.ParticipateAssetIssueActuator;
import org.tron.core.actuator.ProposalApproveActuator;
import org.tron.core.actuator.ProposalCreateActuator;
import org.tron.core.actuator.ProposalDeleteActuator;
import org.tron.core.actuator.SetAccountIdActuator;
import org.tron.core.actuator.TransferActuator;
import org.tron.core.actuator.TransferAssetActuator;
import org.tron.core.actuator.UnfreezeAssetActuator;
import org.tron.core.actuator.UnfreezeBalanceActuator;
import org.tron.core.actuator.UpdateAccountActuator;
import org.tron.core.actuator.UpdateAssetActuator;
import org.tron.core.actuator.UpdateEnergyLimitContractActuator;
import org.tron.core.actuator.UpdateSettingContractActuator;
import org.tron.core.actuator.VoteWitnessActuator;
import org.tron.core.actuator.WithdrawBalanceActuator;
import org.tron.core.actuator.WitnessCreateActuator;
import org.tron.core.actuator.WitnessUpdateActuator;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.Manager;
import org.tron.protos.Protocol;

public class ActuatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(ActuatorFactory.class);
    public static final ActuatorFactory INSTANCE = new ActuatorFactory();

    private ActuatorFactory() {
    }

    public static ActuatorFactory getInstance() {
        return INSTANCE;
    }

    public static List<Actuator> createActuator(TransactionCapsule transactionCapsule, Manager manager) {
        ArrayList actuatorList = Lists.newArrayList();
        if (null == transactionCapsule || null == transactionCapsule.getInstance()) {
            logger.info("transactionCapsule or Transaction is null");
            return actuatorList;
        }
        Preconditions.checkNotNull((Object)manager, (Object)"manager is null");
        Protocol.Transaction.raw rawData = transactionCapsule.getInstance().getRawData();
        rawData.getContractList().forEach(contract -> actuatorList.add(ActuatorFactory.getActuatorByContract(contract, manager)));
        return actuatorList;
    }

    private static Actuator getActuatorByContract(Protocol.Transaction.Contract contract, Manager manager) {
        switch (contract.getType()) {
            case AccountUpdateContract: {
                return new UpdateAccountActuator(contract.getParameter(), manager);
            }
            case TransferContract: {
                return new TransferActuator(contract.getParameter(), manager);
            }
            case TransferAssetContract: {
                return new TransferAssetActuator(contract.getParameter(), manager);
            }
            case VoteAssetContract: {
                break;
            }
            case VoteWitnessContract: {
                return new VoteWitnessActuator(contract.getParameter(), manager);
            }
            case WitnessCreateContract: {
                return new WitnessCreateActuator(contract.getParameter(), manager);
            }
            case AccountCreateContract: {
                return new CreateAccountActuator(contract.getParameter(), manager);
            }
            case AssetIssueContract: {
                return new AssetIssueActuator(contract.getParameter(), manager);
            }
            case UnfreezeAssetContract: {
                return new UnfreezeAssetActuator(contract.getParameter(), manager);
            }
            case WitnessUpdateContract: {
                return new WitnessUpdateActuator(contract.getParameter(), manager);
            }
            case ParticipateAssetIssueContract: {
                return new ParticipateAssetIssueActuator(contract.getParameter(), manager);
            }
            case FreezeBalanceContract: {
                return new FreezeBalanceActuator(contract.getParameter(), manager);
            }
            case UnfreezeBalanceContract: {
                return new UnfreezeBalanceActuator(contract.getParameter(), manager);
            }
            case WithdrawBalanceContract: {
                return new WithdrawBalanceActuator(contract.getParameter(), manager);
            }
            case UpdateAssetContract: {
                return new UpdateAssetActuator(contract.getParameter(), manager);
            }
            case ProposalCreateContract: {
                return new ProposalCreateActuator(contract.getParameter(), manager);
            }
            case ProposalApproveContract: {
                return new ProposalApproveActuator(contract.getParameter(), manager);
            }
            case ProposalDeleteContract: {
                return new ProposalDeleteActuator(contract.getParameter(), manager);
            }
            case SetAccountIdContract: {
                return new SetAccountIdActuator(contract.getParameter(), manager);
            }
            case UpdateSettingContract: {
                return new UpdateSettingContractActuator(contract.getParameter(), manager);
            }
            case UpdateEnergyLimitContract: {
                return new UpdateEnergyLimitContractActuator(contract.getParameter(), manager);
            }
            case ExchangeCreateContract: {
                return new ExchangeCreateActuator(contract.getParameter(), manager);
            }
            case ExchangeInjectContract: {
                return new ExchangeInjectActuator(contract.getParameter(), manager);
            }
            case ExchangeWithdrawContract: {
                return new ExchangeWithdrawActuator(contract.getParameter(), manager);
            }
            case ExchangeTransactionContract: {
                return new ExchangeTransactionActuator(contract.getParameter(), manager);
            }
        }
        return null;
    }
}

