/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;

public interface Utils {
    public static final SecureRandom random = new SecureRandom();

    public static SecureRandom getRandom() {
        return random;
    }

    public static byte[] getBytes(char[] chars) {
        Charset cs = Charset.forName("UTF-8");
        CharBuffer cb = CharBuffer.allocate(chars.length);
        cb.put(chars);
        cb.flip();
        ByteBuffer bb = cs.encode(cb);
        return bb.array();
    }

    public static String getIdShort(String Id) {
        return Id == null ? "<null>" : Id.substring(0, 8);
    }

    public static char[] getChars(byte[] bytes) {
        Charset cs = Charset.forName("UTF-8");
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes);
        bb.flip();
        CharBuffer cb = cs.decode(bb);
        return cb.array();
    }

    public static byte[] clone(byte[] value) {
        byte[] clone = new byte[value.length];
        System.arraycopy(value, 0, clone, 0, value.length);
        return clone;
    }

    public static String sizeToStr(long size) {
        if (size < 2048L) {
            return size + "b";
        }
        if (size < 0x200000L) {
            return String.format("%dKb", size / 1024L);
        }
        if (size < 0x80000000L) {
            return String.format("%dMb", size / 0x100000L);
        }
        return String.format("%dGb", size / 0x40000000L);
    }

    public static String align(String s, char fillChar, int targetLen, boolean alignRight) {
        if (targetLen <= s.length()) {
            return s;
        }
        String alignString = Utils.repeat("" + fillChar, targetLen - s.length());
        return alignRight ? alignString + s : s + alignString;
    }

    public static String repeat(String s, int n) {
        if (s.length() == 1) {
            byte[] bb = new byte[n];
            Arrays.fill(bb, s.getBytes()[0]);
            return new String(bb);
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            ret.append(s);
        }
        return ret.toString();
    }
}

