/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class ExecutorLoop<In> {
    private BlockingQueue<Runnable> queue;
    private ThreadPoolExecutor exec;
    private Consumer<In> consumer;
    private Consumer<Throwable> exceptionHandler;
    private String threadPoolName;
    private static AtomicInteger loopNum = new AtomicInteger(1);
    private AtomicInteger threadNumber = new AtomicInteger(1);

    public ExecutorLoop(int threads, int queueSize, Consumer<In> consumer, Consumer<Throwable> exceptionHandler) {
        this.queue = new LimitedQueue<Runnable>(queueSize);
        this.exec = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, this.queue, r -> new Thread(r, this.threadPoolName + "-" + this.threadNumber.getAndIncrement()));
        this.consumer = consumer;
        this.exceptionHandler = exceptionHandler;
        this.threadPoolName = "loop-" + loopNum.getAndIncrement();
    }

    public void push(In in) {
        this.exec.execute(() -> {
            try {
                this.consumer.accept(in);
            }
            catch (Throwable e) {
                this.exceptionHandler.accept(e);
            }
        });
    }

    public void pushAll(List<In> list) {
        for (In in : list) {
            this.push(in);
        }
    }

    public ExecutorLoop<In> setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
        return this;
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.queue;
    }

    public void shutdown() {
        try {
            this.exec.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isShutdown() {
        return this.exec.isShutdown();
    }

    public void join() throws InterruptedException {
        this.exec.shutdown();
        this.exec.awaitTermination(10L, TimeUnit.MINUTES);
    }

    private static class LimitedQueue<E>
    extends LinkedBlockingQueue<E> {
        public LimitedQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        public boolean offer(E e) {
            try {
                this.put(e);
                return true;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }
}

