/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.tron.core.db.ByteArrayWrapper;

public class ByteArraySet
implements Set<byte[]> {
    private Set<ByteArrayWrapper> delegate;

    public ByteArraySet() {
        this(new HashSet<ByteArrayWrapper>());
    }

    ByteArraySet(Set<ByteArrayWrapper> delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(new ByteArrayWrapper((byte[])o));
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            Iterator<ByteArrayWrapper> it;
            {
                this.it = ByteArraySet.this.delegate.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public byte[] next() {
                return this.it.next().getData();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        byte[][] ret = new byte[this.size()][];
        ByteArrayWrapper[] arr = this.delegate.toArray(new ByteArrayWrapper[this.size()]);
        for (int i = 0; i < arr.length; ++i) {
            ret[i] = arr[i].getData();
        }
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArray();
    }

    @Override
    public boolean add(byte[] bytes) {
        return this.delegate.add(new ByteArrayWrapper(bytes));
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(new ByteArrayWrapper((byte[])o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean addAll(Collection<? extends byte[]> c) {
        boolean ret = false;
        for (byte[] byArray : c) {
            ret |= this.add(byArray);
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public int hashCode() {
        throw new RuntimeException("Not implemented");
    }
}

