/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.storage;

public class Type {
    public static int VALUE_TYPE_NORMAL = 0;
    public static int VALUE_TYPE_DIRTY = 1;
    public static int VALUE_TYPE_CREATE = 2;
    public static int VALUE_TYPE_UNKNOWN = -4;
    protected int type = VALUE_TYPE_NORMAL;

    public Type(int type) {
        this.type |= type;
    }

    public Type() {
    }

    private Type(Type T) {
        this.type = T.getType();
    }

    public Type clone() {
        return new Type(this);
    }

    public boolean isDirty() {
        return (this.type & VALUE_TYPE_DIRTY) == VALUE_TYPE_DIRTY;
    }

    public boolean isNormal() {
        return this.type == VALUE_TYPE_NORMAL;
    }

    public boolean isCreate() {
        return (this.type & VALUE_TYPE_CREATE) == VALUE_TYPE_CREATE;
    }

    public boolean shouldCommit() {
        return this.type != VALUE_TYPE_NORMAL;
    }

    public int getType() {
        return this.type;
    }

    public boolean isValidType(int type) {
        return (type & VALUE_TYPE_UNKNOWN) == VALUE_TYPE_NORMAL;
    }

    public void setType(int type) {
        if (this.isValidType(type)) {
            this.type = type;
        }
    }

    public void addType(int type) {
        if (this.isValidType(type)) {
            this.type |= type;
        }
    }

    public void addType(Type T) {
        this.addType(T.getType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Type T = (Type)obj;
        return this.type == T.getType();
    }

    public int hashCode() {
        return new Integer(this.type).hashCode();
    }

    public String toString() {
        return "Type{type=" + this.type + '}';
    }
}

