/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm.program;

import java.util.HashMap;
import java.util.Map;
import org.tron.common.crypto.Hash;
import org.tron.common.runtime.vm.DataWord;
import org.tron.core.capsule.StorageRowCapsule;
import org.tron.core.db.StorageRowStore;

public class Storage {
    private byte[] addrHash;
    private StorageRowStore store;
    private final Map<DataWord, StorageRowCapsule> rowCache = new HashMap<DataWord, StorageRowCapsule>();
    private static final int PREFIX_BYTES = 16;

    public Storage(byte[] address, StorageRowStore store) {
        this.addrHash = Storage.addrHash(address);
        this.store = store;
    }

    public Storage(Storage storage) {
        this.addrHash = (byte[])storage.addrHash.clone();
        this.store = storage.store;
        storage.getRowCache().forEach((rowKey, row) -> {
            StorageRowCapsule newRow = new StorageRowCapsule((StorageRowCapsule)row);
            this.rowCache.put(rowKey.clone(), newRow);
        });
    }

    public DataWord getValue(DataWord key) {
        if (this.rowCache.containsKey(key)) {
            return this.rowCache.get(key).getValue();
        }
        StorageRowCapsule row = this.store.get(Storage.compose(key.getData(), this.addrHash));
        if (row == null || row.getInstance() == null) {
            return null;
        }
        this.rowCache.put(key, row);
        return row.getValue();
    }

    public void put(DataWord key, DataWord value) {
        if (this.rowCache.containsKey(key)) {
            this.rowCache.get(key).setValue(value);
        } else {
            byte[] rowKey = Storage.compose(key.getData(), this.addrHash);
            StorageRowCapsule row = new StorageRowCapsule(rowKey, value.getData());
            this.rowCache.put(key, row);
        }
    }

    private static byte[] compose(byte[] key, byte[] addrHash) {
        byte[] result = new byte[key.length];
        System.arraycopy(addrHash, 0, result, 0, 16);
        System.arraycopy(key, 16, result, 16, 16);
        return result;
    }

    private static byte[] addrHash(byte[] address) {
        return Hash.sha3(address);
    }

    public void commit() {
        this.rowCache.forEach((rowKey, row) -> {
            if (row.isDirty()) {
                if (row.getValue().isZero()) {
                    this.store.delete(row.getRowKey());
                } else {
                    this.store.put(row.getRowKey(), row);
                }
            }
        });
    }

    public byte[] getAddrHash() {
        return this.addrHash;
    }

    public StorageRowStore getStore() {
        return this.store;
    }

    public Map<DataWord, StorageRowCapsule> getRowCache() {
        return this.rowCache;
    }
}

