/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm.program;

import org.tron.common.runtime.vm.DataWord;
import org.tron.common.runtime.vm.program.Storage;
import org.tron.common.runtime.vm.program.invoke.ProgramInvoke;
import org.tron.common.runtime.vm.program.listener.ProgramListener;
import org.tron.common.runtime.vm.program.listener.ProgramListenerAware;
import org.tron.common.storage.Deposit;
import org.tron.common.storage.Key;
import org.tron.common.storage.Value;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.db.Manager;
import org.tron.protos.Protocol;

public class ContractState
implements Deposit,
ProgramListenerAware {
    private Deposit deposit;
    private final DataWord address;
    private ProgramListener programListener;

    ContractState(ProgramInvoke programInvoke) {
        this.address = programInvoke.getContractAddress();
        this.deposit = programInvoke.getDeposit();
    }

    @Override
    public Manager getDbManager() {
        return this.deposit.getDbManager();
    }

    @Override
    public void setProgramListener(ProgramListener listener) {
        this.programListener = listener;
    }

    @Override
    public AccountCapsule createAccount(byte[] addr, Protocol.AccountType type) {
        return this.deposit.createAccount(addr, type);
    }

    @Override
    public AccountCapsule createAccount(byte[] address, String accountName, Protocol.AccountType type) {
        return this.deposit.createAccount(address, accountName, type);
    }

    @Override
    public AccountCapsule getAccount(byte[] addr) {
        return this.deposit.getAccount(addr);
    }

    @Override
    public WitnessCapsule getWitness(byte[] address) {
        return this.deposit.getWitness(address);
    }

    @Override
    public VotesCapsule getVotesCapsule(byte[] address) {
        return this.deposit.getVotesCapsule(address);
    }

    @Override
    public ProposalCapsule getProposalCapsule(byte[] id) {
        return this.deposit.getProposalCapsule(id);
    }

    @Override
    public BytesCapsule getDynamic(byte[] bytesKey) {
        return this.deposit.getDynamic(bytesKey);
    }

    @Override
    public void deleteContract(byte[] address) {
        this.deposit.deleteContract(address);
    }

    @Override
    public void createContract(byte[] codeHash, ContractCapsule contractCapsule) {
        this.deposit.createContract(codeHash, contractCapsule);
    }

    @Override
    public ContractCapsule getContract(byte[] codeHash) {
        return this.deposit.getContract(codeHash);
    }

    @Override
    public void saveCode(byte[] addr, byte[] code2) {
        this.deposit.saveCode(addr, code2);
    }

    @Override
    public byte[] getCode(byte[] addr) {
        return this.deposit.getCode(addr);
    }

    @Override
    public void putStorageValue(byte[] addr, DataWord key, DataWord value) {
        if (this.canListenTrace(addr)) {
            this.programListener.onStoragePut(key, value);
        }
        this.deposit.putStorageValue(addr, key, value);
    }

    private boolean canListenTrace(byte[] address) {
        return this.programListener != null && this.address.equals(new DataWord(address));
    }

    @Override
    public DataWord getStorageValue(byte[] addr, DataWord key) {
        return this.deposit.getStorageValue(addr, key);
    }

    @Override
    public long getBalance(byte[] addr) {
        return this.deposit.getBalance(addr);
    }

    @Override
    public long addBalance(byte[] addr, long value) {
        return this.deposit.addBalance(addr, value);
    }

    @Override
    public Deposit newDepositChild() {
        return this.deposit.newDepositChild();
    }

    @Override
    public void commit() {
        this.deposit.commit();
    }

    @Override
    public Storage getStorage(byte[] address) {
        return this.deposit.getStorage(address);
    }

    @Override
    public void putAccount(Key key, Value value) {
        this.deposit.putAccount(key, value);
    }

    @Override
    public void putTransaction(Key key, Value value) {
        this.deposit.putTransaction(key, value);
    }

    @Override
    public void putBlock(Key key, Value value) {
        this.deposit.putBlock(key, value);
    }

    @Override
    public void putWitness(Key key, Value value) {
        this.deposit.putWitness(key, value);
    }

    @Override
    public void putCode(Key key, Value value) {
        this.deposit.putCode(key, value);
    }

    @Override
    public void putContract(Key key, Value value) {
        this.deposit.putContract(key, value);
    }

    @Override
    public void putStorage(Key key, Storage cache) {
        this.deposit.putStorage(key, cache);
    }

    @Override
    public void putVotes(Key key, Value value) {
        this.deposit.putVotes(key, value);
    }

    @Override
    public void putProposal(Key key, Value value) {
        this.deposit.putProposal(key, value);
    }

    @Override
    public void putDynamicProperties(Key key, Value value) {
        this.deposit.putDynamicProperties(key, value);
    }

    @Override
    public void setParent(Deposit deposit) {
        this.deposit.setParent(deposit);
    }

    @Override
    public TransactionCapsule getTransaction(byte[] trxHash) {
        return this.deposit.getTransaction(trxHash);
    }

    @Override
    public void putAccountValue(byte[] address, AccountCapsule accountCapsule) {
        this.deposit.putAccountValue(address, accountCapsule);
    }

    @Override
    public void putVoteValue(byte[] address, VotesCapsule votesCapsule) {
        this.deposit.putVoteValue(address, votesCapsule);
    }

    @Override
    public void putProposalValue(byte[] address, ProposalCapsule proposalCapsule) {
        this.deposit.putProposalValue(address, proposalCapsule);
    }

    @Override
    public void putDynamicPropertiesWithLatestProposalNum(long num) {
        this.deposit.putDynamicPropertiesWithLatestProposalNum(num);
    }

    @Override
    public long getLatestProposalNum() {
        return this.deposit.getLatestProposalNum();
    }

    @Override
    public long getWitnessAllowanceFrozenTime() {
        return this.deposit.getWitnessAllowanceFrozenTime();
    }

    @Override
    public long getMaintenanceTimeInterval() {
        return this.deposit.getMaintenanceTimeInterval();
    }

    @Override
    public long getNextMaintenanceTime() {
        return this.deposit.getNextMaintenanceTime();
    }

    @Override
    public long addTokenBalance(byte[] address, byte[] tokenId, long value) {
        return this.deposit.addTokenBalance(address, tokenId, value);
    }

    @Override
    public long getTokenBalance(byte[] address, byte[] tokenId) {
        return this.deposit.getTokenBalance(address, tokenId);
    }

    @Override
    public AssetIssueCapsule getAssetIssue(byte[] tokenId) {
        return this.deposit.getAssetIssue(tokenId);
    }

    @Override
    public BlockCapsule getBlock(byte[] blockHash) {
        return this.deposit.getBlock(blockHash);
    }

    @Override
    public byte[] getBlackHoleAddress() {
        return this.deposit.getBlackHoleAddress();
    }
}

