/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import org.spongycastle.util.encoders.Hex;
import org.tron.common.runtime.vm.DataWord;
import org.tron.protos.Protocol;

public class LogInfo {
    byte[] address = new byte[0];
    List<DataWord> topics = new ArrayList<DataWord>();
    byte[] data = new byte[0];

    public LogInfo(byte[] address, List<DataWord> topics, byte[] data) {
        this.address = address != null ? address : new byte[]{};
        this.topics = topics != null ? topics : new ArrayList();
        this.data = data != null ? data : new byte[]{};
    }

    public byte[] getAddress() {
        return this.address;
    }

    public List<DataWord> getTopics() {
        return this.topics;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        StringBuilder topicsStr = new StringBuilder();
        topicsStr.append("[");
        for (DataWord topic : this.topics) {
            String topicStr = Hex.toHexString((byte[])topic.getData());
            topicsStr.append(topicStr).append(" ");
        }
        topicsStr.append("]");
        return "LogInfo{address=" + Hex.toHexString((byte[])this.address) + ", topics=" + topicsStr + ", data=" + Hex.toHexString((byte[])this.data) + '}';
    }

    public static Protocol.TransactionInfo.Log buildLog(LogInfo logInfo) {
        ArrayList topics = Lists.newArrayList();
        logInfo.getTopics().forEach(topic -> topics.add(ByteString.copyFrom((byte[])topic.getData())));
        ByteString address = ByteString.copyFrom((byte[])logInfo.getAddress());
        ByteString data = ByteString.copyFrom((byte[])logInfo.getData());
        return Protocol.TransactionInfo.Log.newBuilder().setAddress(address).addAllTopics(topics).setData(data).build();
    }
}

