/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime;

import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;
import org.tron.common.runtime.Runtime;
import org.tron.common.runtime.config.VMConfig;
import org.tron.common.runtime.utils.MUtil;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.runtime.vm.EnergyCost;
import org.tron.common.runtime.vm.VM;
import org.tron.common.runtime.vm.VMUtils;
import org.tron.common.runtime.vm.program.InternalTransaction;
import org.tron.common.runtime.vm.program.Program;
import org.tron.common.runtime.vm.program.ProgramPrecompile;
import org.tron.common.runtime.vm.program.ProgramResult;
import org.tron.common.runtime.vm.program.invoke.ProgramInvoke;
import org.tron.common.runtime.vm.program.invoke.ProgramInvokeFactory;
import org.tron.common.storage.Deposit;
import org.tron.common.storage.DepositImpl;
import org.tron.core.Wallet;
import org.tron.core.actuator.Actuator;
import org.tron.core.actuator.ActuatorFactory;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.db.TransactionTrace;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.VMIllegalException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class RuntimeImpl
implements Runtime {
    private static final Logger logger = LoggerFactory.getLogger((String)"Runtime");
    private VMConfig config = VMConfig.getInstance();
    private Protocol.Transaction trx;
    private BlockCapsule blockCap;
    private Deposit deposit;
    private ProgramInvokeFactory programInvokeFactory;
    private String runtimeError;
    private EnergyProcessor energyProcessor;
    private ProgramResult result = new ProgramResult();
    private VM vm;
    private Program program;
    private InternalTransaction rootInternalTransaction;
    private InternalTransaction.TrxType trxType;
    private InternalTransaction.ExecutorType executorType;
    private TransactionTrace trace;
    private boolean isStaticCall;

    public RuntimeImpl(TransactionTrace trace, BlockCapsule block, Deposit deposit, ProgramInvokeFactory programInvokeFactory) {
        this.trace = trace;
        this.trx = trace.getTrx().getInstance();
        if (Objects.nonNull(block)) {
            this.blockCap = block;
            this.executorType = InternalTransaction.ExecutorType.ET_NORMAL_TYPE;
        } else {
            this.blockCap = new BlockCapsule(Protocol.Block.newBuilder().build());
            this.executorType = InternalTransaction.ExecutorType.ET_PRE_TYPE;
        }
        this.deposit = deposit;
        this.programInvokeFactory = programInvokeFactory;
        this.energyProcessor = new EnergyProcessor(deposit.getDbManager());
        Protocol.Transaction.Contract.ContractType contractType = this.trx.getRawData().getContract(0).getType();
        switch (contractType.getNumber()) {
            case 31: {
                this.trxType = InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE;
                break;
            }
            case 30: {
                this.trxType = InternalTransaction.TrxType.TRX_CONTRACT_CREATION_TYPE;
                break;
            }
            default: {
                this.trxType = InternalTransaction.TrxType.TRX_PRECOMPILED_TYPE;
            }
        }
    }

    public RuntimeImpl(Protocol.Transaction tx, BlockCapsule block, DepositImpl deposit, ProgramInvokeFactory programInvokeFactory, boolean isStaticCall) {
        this(tx, block, deposit, programInvokeFactory);
        this.isStaticCall = isStaticCall;
    }

    private RuntimeImpl(Protocol.Transaction tx, BlockCapsule block, DepositImpl deposit, ProgramInvokeFactory programInvokeFactory) {
        this.trx = tx;
        this.deposit = deposit;
        this.programInvokeFactory = programInvokeFactory;
        this.executorType = InternalTransaction.ExecutorType.ET_PRE_TYPE;
        this.blockCap = block;
        this.energyProcessor = new EnergyProcessor(deposit.getDbManager());
        Protocol.Transaction.Contract.ContractType contractType = tx.getRawData().getContract(0).getType();
        switch (contractType.getNumber()) {
            case 31: {
                this.trxType = InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE;
                break;
            }
            case 30: {
                this.trxType = InternalTransaction.TrxType.TRX_CONTRACT_CREATION_TYPE;
                break;
            }
            default: {
                this.trxType = InternalTransaction.TrxType.TRX_PRECOMPILED_TYPE;
            }
        }
    }

    private void precompiled() throws ContractValidateException, ContractExeException {
        TransactionCapsule trxCap = new TransactionCapsule(this.trx);
        List<Actuator> actuatorList = ActuatorFactory.createActuator(trxCap, this.deposit.getDbManager());
        for (Actuator act : actuatorList) {
            act.validate();
            act.execute(this.result.getRet());
        }
    }

    @Override
    public void execute() throws ContractValidateException, ContractExeException, VMIllegalException {
        switch (this.trxType) {
            case TRX_PRECOMPILED_TYPE: {
                this.precompiled();
                break;
            }
            case TRX_CONTRACT_CREATION_TYPE: {
                this.create();
                break;
            }
            case TRX_CONTRACT_CALL_TYPE: {
                this.call();
                break;
            }
            default: {
                throw new ContractValidateException("Unknown contract type");
            }
        }
    }

    public long getAccountEnergyLimitWithFixRatio(AccountCapsule account, long feeLimit, long callValue) {
        long sunPerEnergy = 100L;
        if (this.deposit.getDbManager().getDynamicPropertiesStore().getEnergyFee() > 0L) {
            sunPerEnergy = this.deposit.getDbManager().getDynamicPropertiesStore().getEnergyFee();
        }
        long leftFrozenEnergy = this.energyProcessor.getAccountLeftEnergyFromFreeze(account);
        long energyFromBalance = Math.max(account.getBalance() - callValue, 0L) / sunPerEnergy;
        long availableEnergy = Math.addExact(leftFrozenEnergy, energyFromBalance);
        long energyFromFeeLimit = feeLimit / sunPerEnergy;
        return Math.min(availableEnergy, energyFromFeeLimit);
    }

    private long getAccountEnergyLimitWithFloatRatio(AccountCapsule account, long feeLimit, long callValue) {
        long totalEnergyFromFreeze;
        long leftBalanceForEnergyFreeze;
        long sunPerEnergy = 100L;
        if (this.deposit.getDbManager().getDynamicPropertiesStore().getEnergyFee() > 0L) {
            sunPerEnergy = this.deposit.getDbManager().getDynamicPropertiesStore().getEnergyFee();
        }
        long leftEnergyFromFreeze = this.energyProcessor.getAccountLeftEnergyFromFreeze(account);
        callValue = Math.max(callValue, 0L);
        long energyFromBalance = Math.floorDiv(Math.max(account.getBalance() - callValue, 0L), sunPerEnergy);
        long totalBalanceForEnergyFreeze = account.getAllFrozenBalanceForEnergy();
        long energyFromFeeLimit = 0L == totalBalanceForEnergyFreeze ? feeLimit / sunPerEnergy : ((leftBalanceForEnergyFreeze = RuntimeImpl.getEnergyFee(totalBalanceForEnergyFreeze, leftEnergyFromFreeze, totalEnergyFromFreeze = this.energyProcessor.calculateGlobalEnergyLimit(account))) >= feeLimit ? BigInteger.valueOf(totalEnergyFromFreeze).multiply(BigInteger.valueOf(feeLimit)).divide(BigInteger.valueOf(totalBalanceForEnergyFreeze)).longValueExact() : Math.addExact(leftEnergyFromFreeze, (feeLimit - leftBalanceForEnergyFreeze) / sunPerEnergy));
        return Math.min(Math.addExact(leftEnergyFromFreeze, energyFromBalance), energyFromFeeLimit);
    }

    private long getTotalEnergyLimitWithFloatRatio(AccountCapsule creator, AccountCapsule caller, Contract.TriggerSmartContract contract, long feeLimit, long callValue) {
        ContractCapsule contractCapsule;
        long consumeUserResourcePercent;
        long callerEnergyLimit = this.getAccountEnergyLimitWithFloatRatio(caller, feeLimit, callValue);
        if (Arrays.equals(creator.getAddress().toByteArray(), caller.getAddress().toByteArray())) {
            return callerEnergyLimit;
        }
        long creatorEnergyLimit = this.energyProcessor.getAccountLeftEnergyFromFreeze(creator);
        if (creatorEnergyLimit * (consumeUserResourcePercent = (contractCapsule = this.deposit.getContract(contract.getContractAddress().toByteArray())).getConsumeUserResourcePercent()) > (100L - consumeUserResourcePercent) * callerEnergyLimit) {
            return Math.floorDiv(callerEnergyLimit * 100L, consumeUserResourcePercent);
        }
        return Math.addExact(callerEnergyLimit, creatorEnergyLimit);
    }

    public long getTotalEnergyLimitWithFixRatio(AccountCapsule creator, AccountCapsule caller, Contract.TriggerSmartContract contract, long feeLimit, long callValue) throws ContractValidateException {
        long callerEnergyLimit = this.getAccountEnergyLimitWithFixRatio(caller, feeLimit, callValue);
        if (Arrays.equals(creator.getAddress().toByteArray(), caller.getAddress().toByteArray())) {
            return callerEnergyLimit;
        }
        long creatorEnergyLimit = 0L;
        ContractCapsule contractCapsule = this.deposit.getContract(contract.getContractAddress().toByteArray());
        long consumeUserResourcePercent = contractCapsule.getConsumeUserResourcePercent();
        long originEnergyLimit = contractCapsule.getOriginEnergyLimit();
        if (originEnergyLimit < 0L) {
            throw new ContractValidateException("originEnergyLimit can't be < 0");
        }
        if (consumeUserResourcePercent <= 0L) {
            creatorEnergyLimit = Math.min(this.energyProcessor.getAccountLeftEnergyFromFreeze(creator), originEnergyLimit);
        } else if (consumeUserResourcePercent < 100L) {
            creatorEnergyLimit = Math.min(BigInteger.valueOf(callerEnergyLimit).multiply(BigInteger.valueOf(100L - consumeUserResourcePercent)).divide(BigInteger.valueOf(consumeUserResourcePercent)).longValueExact(), Math.min(this.energyProcessor.getAccountLeftEnergyFromFreeze(creator), originEnergyLimit));
        }
        return Math.addExact(callerEnergyLimit, creatorEnergyLimit);
    }

    public long getTotalEnergyLimit(AccountCapsule creator, AccountCapsule caller, Contract.TriggerSmartContract contract, long feeLimit, long callValue) throws ContractValidateException {
        if (VMConfig.getEnergyLimitHardFork()) {
            return this.getTotalEnergyLimitWithFixRatio(creator, caller, contract, feeLimit, callValue);
        }
        return this.getTotalEnergyLimitWithFloatRatio(creator, caller, contract, feeLimit, callValue);
    }

    private double getCpuLimitInUsRatio() {
        double cpuLimitRatio = InternalTransaction.ExecutorType.ET_NORMAL_TYPE == this.executorType ? (this.blockCap != null && this.blockCap.generatedByMyself && this.blockCap.getInstance().getBlockHeader().getWitnessSignature().isEmpty() ? 1.0 : (this.trx.getRet(0).getContractRet() == Protocol.Transaction.Result.contractResult.OUT_OF_TIME ? Args.getInstance().getMinTimeRatio() : Args.getInstance().getMaxTimeRatio())) : 1.0;
        return cpuLimitRatio;
    }

    private void create() throws ContractValidateException, VMIllegalException {
        if (!this.deposit.getDbManager().getDynamicPropertiesStore().supportVM()) {
            throw new ContractValidateException("vm work is off, need to be opened by the committee");
        }
        Contract.CreateSmartContract contract = ContractCapsule.getSmartContractFromTransaction(this.trx);
        if (contract == null) {
            throw new ContractValidateException("Cannot get CreateSmartContract from transaction");
        }
        Protocol.SmartContract newSmartContract = contract.getNewContract();
        if (!contract.getOwnerAddress().equals((Object)newSmartContract.getOriginAddress())) {
            logger.info("OwnerAddress not equals OriginAddress");
            throw new VMIllegalException("OwnerAddress is not equals OriginAddress");
        }
        byte[] contractName = newSmartContract.getName().getBytes();
        if (contractName.length > 32) {
            throw new ContractValidateException("contractName's length cannot be greater than 32");
        }
        long percent = contract.getNewContract().getConsumeUserResourcePercent();
        if (percent < 0L || percent > 100L) {
            throw new ContractValidateException("percent must be >= 0 and <= 100");
        }
        byte[] contractAddress = Wallet.generateContractAddress(this.trx);
        if (this.deposit.getAccount(contractAddress) != null) {
            throw new ContractValidateException("Trying to create a contract with existing contract address: " + Wallet.encode58Check(contractAddress));
        }
        newSmartContract = newSmartContract.toBuilder().setContractAddress(ByteString.copyFrom((byte[])contractAddress)).build();
        long callValue = newSmartContract.getCallValue();
        long tokenValue = 0L;
        long tokenId = 0L;
        if (VMConfig.allowTvmTransferTrc10()) {
            tokenValue = contract.getCallTokenValue();
            tokenId = contract.getTokenId();
        }
        try {
            long energyLimit;
            long feeLimit = this.trx.getRawData().getFeeLimit();
            if (feeLimit < 0L || feeLimit > 1000000000L) {
                logger.info("invalid feeLimit {}", (Object)feeLimit);
                throw new ContractValidateException("feeLimit must be >= 0 and <= 1000000000");
            }
            AccountCapsule creator = this.deposit.getAccount(newSmartContract.getOriginAddress().toByteArray());
            if (VMConfig.getEnergyLimitHardFork()) {
                if (callValue < 0L) {
                    throw new ContractValidateException("callValue must >= 0");
                }
                if (newSmartContract.getOriginEnergyLimit() <= 0L) {
                    throw new ContractValidateException("The originEnergyLimit must be > 0");
                }
                energyLimit = this.getAccountEnergyLimitWithFixRatio(creator, feeLimit, callValue);
            } else {
                energyLimit = this.getAccountEnergyLimitWithFloatRatio(creator, feeLimit, callValue);
            }
            byte[] ops = newSmartContract.getBytecode().toByteArray();
            this.rootInternalTransaction = new InternalTransaction(this.trx, this.trxType);
            long maxCpuTimeOfOneTx = this.deposit.getDbManager().getDynamicPropertiesStore().getMaxCpuTimeOfOneTx() * 1000L;
            long thisTxCPULimitInUs = (long)((double)maxCpuTimeOfOneTx * this.getCpuLimitInUsRatio());
            long vmStartInUs = System.nanoTime() / 1000L;
            long vmShouldEndInUs = vmStartInUs + thisTxCPULimitInUs;
            ProgramInvoke programInvoke = this.programInvokeFactory.createProgramInvoke(InternalTransaction.TrxType.TRX_CONTRACT_CREATION_TYPE, this.executorType, this.trx, tokenValue, tokenId, this.blockCap.getInstance(), this.deposit, vmStartInUs, vmShouldEndInUs, energyLimit);
            this.vm = new VM(this.config);
            this.program = new Program(ops, programInvoke, this.rootInternalTransaction, this.config, this.blockCap);
            this.program.setRootTransactionId(new TransactionCapsule(this.trx).getTransactionId().getBytes());
            this.program.setRootCallConstant(this.isCallConstant());
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw new ContractValidateException(e.getMessage());
        }
        this.program.getResult().setContractAddress(contractAddress);
        this.deposit.createAccount(contractAddress, newSmartContract.getName(), Protocol.AccountType.Contract);
        this.deposit.createContract(contractAddress, new ContractCapsule(newSmartContract));
        byte[] code2 = newSmartContract.getBytecode().toByteArray();
        this.deposit.saveCode(contractAddress, ProgramPrecompile.getCode(code2));
        byte[] callerAddress = contract.getOwnerAddress().toByteArray();
        if (callValue > 0L) {
            MUtil.transfer(this.deposit, callerAddress, contractAddress, callValue);
        }
        if (VMConfig.allowTvmTransferTrc10() && tokenValue > 0L) {
            MUtil.transferToken(this.deposit, callerAddress, contractAddress, String.valueOf(tokenId), tokenValue);
        }
    }

    private void call() throws ContractValidateException {
        byte[] code2;
        if (!this.deposit.getDbManager().getDynamicPropertiesStore().supportVM()) {
            logger.info("vm work is off, need to be opened by the committee");
            throw new ContractValidateException("VM work is off, need to be opened by the committee");
        }
        Contract.TriggerSmartContract contract = ContractCapsule.getTriggerContractFromTransaction(this.trx);
        if (contract == null) {
            return;
        }
        if (contract.getContractAddress() == null) {
            throw new ContractValidateException("Cannot get contract address from TriggerContract");
        }
        byte[] contractAddress = contract.getContractAddress().toByteArray();
        ContractCapsule deployedContract = this.deposit.getContract(contractAddress);
        if (null == deployedContract) {
            logger.info("No contract or not a smart contract");
            throw new ContractValidateException("No contract or not a smart contract");
        }
        long callValue = contract.getCallValue();
        if (VMConfig.getEnergyLimitHardFork() && callValue < 0L) {
            throw new ContractValidateException("callValue must >= 0");
        }
        long tokenValue = 0L;
        long tokenId = 0L;
        if (VMConfig.allowTvmTransferTrc10()) {
            tokenValue = contract.getCallTokenValue();
            tokenId = contract.getTokenId();
        }
        if (ArrayUtils.isNotEmpty((byte[])(code2 = this.deposit.getCode(contractAddress)))) {
            long energyLimit;
            long feeLimit = this.trx.getRawData().getFeeLimit();
            if (feeLimit < 0L || feeLimit > 1000000000L) {
                logger.info("invalid feeLimit {}", (Object)feeLimit);
                throw new ContractValidateException("feeLimit must be >= 0 and <= 1000000000");
            }
            AccountCapsule caller = this.deposit.getAccount(contract.getOwnerAddress().toByteArray());
            if (this.isCallConstant(contractAddress)) {
                this.isStaticCall = true;
                energyLimit = 3000000L;
            } else {
                AccountCapsule creator = this.deposit.getAccount(deployedContract.getInstance().getOriginAddress().toByteArray());
                energyLimit = this.getTotalEnergyLimit(creator, caller, contract, feeLimit, callValue);
            }
            long maxCpuTimeOfOneTx = this.deposit.getDbManager().getDynamicPropertiesStore().getMaxCpuTimeOfOneTx() * 1000L;
            long thisTxCPULimitInUs = (long)((double)maxCpuTimeOfOneTx * this.getCpuLimitInUsRatio());
            long vmStartInUs = System.nanoTime() / 1000L;
            long vmShouldEndInUs = vmStartInUs + thisTxCPULimitInUs;
            ProgramInvoke programInvoke = this.programInvokeFactory.createProgramInvoke(InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE, this.executorType, this.trx, tokenValue, tokenId, this.blockCap.getInstance(), this.deposit, vmStartInUs, vmShouldEndInUs, energyLimit);
            if (this.isStaticCall) {
                programInvoke.setStaticCall();
            }
            this.vm = new VM(this.config);
            this.rootInternalTransaction = new InternalTransaction(this.trx, this.trxType);
            this.program = new Program(code2, programInvoke, this.rootInternalTransaction, this.config, this.blockCap);
            this.program.setRootTransactionId(new TransactionCapsule(this.trx).getTransactionId().getBytes());
            this.program.setRootCallConstant(this.isCallConstant());
        }
        this.program.getResult().setContractAddress(contractAddress);
        byte[] callerAddress = contract.getOwnerAddress().toByteArray();
        if (callValue > 0L) {
            MUtil.transfer(this.deposit, callerAddress, contractAddress, callValue);
        }
        if (VMConfig.allowTvmTransferTrc10() && tokenValue > 0L) {
            MUtil.transferToken(this.deposit, callerAddress, contractAddress, String.valueOf(tokenId), tokenValue);
        }
    }

    @Override
    public void go() {
        try {
            if (this.vm != null) {
                TransactionCapsule trxCap = new TransactionCapsule(this.trx);
                if (null != this.blockCap && this.blockCap.generatedByMyself && null != trxCap.getContractRet() && Protocol.Transaction.Result.contractResult.OUT_OF_TIME == trxCap.getContractRet()) {
                    this.result = this.program.getResult();
                    this.program.spendAllEnergy();
                    Program.OutOfTimeException e = Program.Exception.alreadyTimeOut();
                    this.runtimeError = e.getMessage();
                    this.result.setException(e);
                    throw e;
                }
                this.vm.play(this.program);
                this.result = this.program.getResult();
                if (this.isCallConstant()) {
                    long callValue = TransactionCapsule.getCallValue(this.trx.getRawData().getContract(0));
                    long callTokenValue = TransactionCapsule.getCallTokenValue(this.trx.getRawData().getContract(0));
                    if (callValue > 0L || callTokenValue > 0L) {
                        this.runtimeError = "constant cannot set call value or call token value.";
                        this.result.rejectInternalTransactions();
                    }
                    return;
                }
                if (InternalTransaction.TrxType.TRX_CONTRACT_CREATION_TYPE == this.trxType && !this.result.isRevert()) {
                    byte[] code2 = this.program.getResult().getHReturn();
                    long saveCodeEnergy = (long)ArrayUtils.getLength((Object)code2) * (long)EnergyCost.getInstance().getCREATE_DATA();
                    long afterSpend = this.program.getEnergyLimitLeft().longValue() - saveCodeEnergy;
                    if (afterSpend < 0L) {
                        if (null == this.result.getException()) {
                            this.result.setException(Program.Exception.notEnoughSpendEnergy("save just created contract code", saveCodeEnergy, this.program.getEnergyLimitLeft().longValue()));
                        }
                    } else {
                        this.result.spendEnergy(saveCodeEnergy);
                    }
                }
                if (this.result.getException() != null || this.result.isRevert()) {
                    this.result.getDeleteAccounts().clear();
                    this.result.getLogInfoList().clear();
                    this.result.resetFutureRefund();
                    this.result.rejectInternalTransactions();
                    if (this.result.getException() != null) {
                        this.program.spendAllEnergy();
                        this.runtimeError = this.result.getException().getMessage();
                        throw this.result.getException();
                    }
                    this.runtimeError = "REVERT opcode executed";
                } else {
                    this.deposit.commit();
                }
            } else {
                this.deposit.commit();
            }
        }
        catch (Program.JVMStackOverFlowException e) {
            this.program.spendAllEnergy();
            this.result = this.program.getResult();
            this.result.setException(e);
            this.result.rejectInternalTransactions();
            this.runtimeError = this.result.getException().getMessage();
            logger.info("JVMStackOverFlowException: {}", (Object)this.result.getException().getMessage());
        }
        catch (Program.OutOfTimeException e) {
            this.program.spendAllEnergy();
            this.result = this.program.getResult();
            this.result.setException(e);
            this.result.rejectInternalTransactions();
            this.runtimeError = this.result.getException().getMessage();
            logger.info("timeout: {}", (Object)this.result.getException().getMessage());
        }
        catch (ContractValidateException e) {
            logger.info("when check constant, {}", (Object)e.getMessage());
        }
        catch (Throwable e) {
            this.program.spendAllEnergy();
            this.result = this.program.getResult();
            this.result.rejectInternalTransactions();
            if (Objects.isNull(this.result.getException())) {
                logger.error(e.getMessage(), e);
                this.result.setException(new RuntimeException("Unknown Throwable"));
            }
            if (StringUtils.isEmpty((CharSequence)this.runtimeError)) {
                this.runtimeError = this.result.getException().getMessage();
            }
            logger.info("runtime result is :{}", (Object)this.result.getException().getMessage());
        }
        this.trace.setBill(this.result.getEnergyUsed());
    }

    private static long getEnergyFee(long callerEnergyUsage, long callerEnergyFrozen, long callerEnergyTotal) {
        if (callerEnergyTotal <= 0L) {
            return 0L;
        }
        return BigInteger.valueOf(callerEnergyFrozen).multiply(BigInteger.valueOf(callerEnergyUsage)).divide(BigInteger.valueOf(callerEnergyTotal)).longValueExact();
    }

    @Override
    public boolean isCallConstant() throws ContractValidateException {
        Contract.TriggerSmartContract triggerContractFromTransaction = ContractCapsule.getTriggerContractFromTransaction(this.trx);
        if (InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE == this.trxType) {
            ContractCapsule contract = this.deposit.getContract(triggerContractFromTransaction.getContractAddress().toByteArray());
            if (contract == null) {
                logger.info("contract: {} is not in contract store", (Object)Wallet.encode58Check(triggerContractFromTransaction.getContractAddress().toByteArray()));
                throw new ContractValidateException("contract: " + Wallet.encode58Check(triggerContractFromTransaction.getContractAddress().toByteArray()) + " is not in contract store");
            }
            Protocol.SmartContract.ABI abi = contract.getInstance().getAbi();
            if (Wallet.isConstant(abi, triggerContractFromTransaction)) {
                return true;
            }
        }
        return false;
    }

    private boolean isCallConstant(byte[] address) throws ContractValidateException {
        Protocol.SmartContract.ABI abi;
        return InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE == this.trxType && Wallet.isConstant(abi = this.deposit.getContract(address).getInstance().getAbi(), ContractCapsule.getTriggerContractFromTransaction(this.trx));
    }

    @Override
    public void finalization() {
        if (StringUtils.isEmpty((CharSequence)this.runtimeError)) {
            for (DataWord contract : this.result.getDeleteAccounts()) {
                this.deposit.deleteContract(MUtil.convertToTronAddress(contract.getLast20Bytes()));
            }
        }
        if (this.config.vmTrace() && this.program != null) {
            String traceContent = this.program.getTrace().result(this.result.getHReturn()).error(this.result.getException()).toString();
            if (this.config.vmTraceCompressed()) {
                traceContent = VMUtils.zipAndEncode(traceContent);
            }
            String txHash = Hex.toHexString((byte[])this.rootInternalTransaction.getHash());
            VMUtils.saveProgramTraceFile(this.config, txHash, traceContent);
        }
    }

    @Override
    public ProgramResult getResult() {
        return this.result;
    }

    @Override
    public String getRuntimeError() {
        return this.runtimeError;
    }

    @Override
    public InternalTransaction.TrxType getTrxType() {
        return this.trxType;
    }

    public void setTrxType(InternalTransaction.TrxType trxType) {
        this.trxType = trxType;
    }
}

