/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WireTrafficStats
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger((String)"WireTrafficStats");
    private ScheduledExecutorService executor;
    public final TrafficStatHandler tcp = new TrafficStatHandler();
    public final TrafficStatHandler udp = new TrafficStatHandler();

    public WireTrafficStats() {
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("WireTrafficStats-%d").build());
        this.executor.scheduleAtFixedRate(this, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
    }

    @PreDestroy
    public void close() {
        this.executor.shutdownNow();
    }

    @ChannelHandler.Sharable
    static class TrafficStatHandler
    extends ChannelDuplexHandler {
        long outSizeTot;
        long inSizeTot;
        AtomicLong outSize = new AtomicLong();
        AtomicLong inSize = new AtomicLong();
        AtomicLong outPackets = new AtomicLong();
        AtomicLong inPackets = new AtomicLong();
        long lastTime = System.currentTimeMillis();

        TrafficStatHandler() {
        }

        public String stats() {
            long out = this.outSize.getAndSet(0L);
            long outPac = this.outPackets.getAndSet(0L);
            long in = this.inSize.getAndSet(0L);
            long inPac = this.inPackets.getAndSet(0L);
            this.outSizeTot += out;
            this.inSizeTot += in;
            long curTime = System.currentTimeMillis();
            long d = curTime - this.lastTime;
            long outSpeed = out * 1000L / d;
            long inSpeed = in * 1000L / d;
            this.lastTime = curTime;
            return "";
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.inPackets.incrementAndGet();
            if (msg instanceof ByteBuf) {
                this.inSize.addAndGet(((ByteBuf)msg).readableBytes());
            } else if (msg instanceof DatagramPacket) {
                this.inSize.addAndGet(((ByteBuf)((DatagramPacket)msg).content()).readableBytes());
            }
            super.channelRead(ctx, msg);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            this.outPackets.incrementAndGet();
            if (msg instanceof ByteBuf) {
                this.outSize.addAndGet(((ByteBuf)msg).readableBytes());
            } else if (msg instanceof DatagramPacket) {
                this.outSize.addAndGet(((ByteBuf)((DatagramPacket)msg).content()).readableBytes());
            }
            super.write(ctx, msg, promise);
        }
    }
}

