/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.tron.common.overlay.discover.node.statistics.NodeStatistics;
import org.tron.common.overlay.server.ChannelManager;
import org.tron.common.overlay.server.SyncPool;
import org.tron.common.utils.CollectionUtils;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;
import org.tron.core.net.peer.PeerConnection;
import org.tron.protos.Protocol;

@Service
public class PeerConnectionCheckService {
    private static final Logger logger = LoggerFactory.getLogger(PeerConnectionCheckService.class);
    public static final long CHECK_TIME = 300000L;
    private double disconnectNumberFactor = Args.getInstance().getDisconnectNumberFactor();
    private double maxConnectNumberFactor = Args.getInstance().getMaxConnectNumberFactor();
    @Autowired
    private SyncPool pool;
    @Autowired
    private ChannelManager channelManager;
    @Autowired
    private Manager manager;
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2, r -> new Thread(r, "check-peer-connect"));

    @PostConstruct
    public void check() {
        logger.info("start the PeerConnectionCheckService");
        this.scheduledExecutorService.scheduleWithFixedDelay(new CheckDataTransferTask(), 5L, 5L, TimeUnit.MINUTES);
        if (Args.getInstance().isOpenFullTcpDisconnect()) {
            this.scheduledExecutorService.scheduleWithFixedDelay(new CheckConnectNumberTask(), 4L, 1L, TimeUnit.MINUTES);
        }
    }

    @PreDestroy
    public void destroy() {
        this.scheduledExecutorService.shutdown();
    }

    private class CheckConnectNumberTask
    implements Runnable {
        private CheckConnectNumberTask() {
        }

        @Override
        public void run() {
            if (PeerConnectionCheckService.this.pool.getActivePeers().size() >= Args.getInstance().getNodeMaxActiveNodes()) {
                logger.warn("connection pool is full");
                List<PeerConnection> peerList = new ArrayList<PeerConnection>();
                for (PeerConnection peer : PeerConnectionCheckService.this.pool.getActivePeers()) {
                    if (peer.isTrustPeer() || peer.getNodeStatistics().isPredefined()) continue;
                    peerList.add(peer);
                }
                if (peerList.size() >= 2) {
                    peerList.sort(Comparator.comparingInt(o -> o.getNodeStatistics().getReputation()));
                    peerList = CollectionUtils.truncateRandom(peerList, 2, 1);
                }
                for (PeerConnection peerConnection : peerList) {
                    logger.warn("connection pool is full, disconnect the peer : {}", (Object)peerConnection.getInetAddress());
                    peerConnection.disconnect(Protocol.ReasonCode.RESET);
                }
            }
        }
    }

    private class CheckDataTransferTask
    implements Runnable {
        private CheckDataTransferTask() {
        }

        @Override
        public void run() {
            List<PeerConnection> peerConnectionList = PeerConnectionCheckService.this.pool.getActivePeers();
            ArrayList<PeerConnection> willDisconnectPeerList = new ArrayList<PeerConnection>();
            for (PeerConnection peerConnection : peerConnectionList) {
                NodeStatistics nodeStatistics = peerConnection.getNodeStatistics();
                if (!(nodeStatistics.nodeIsHaveDataTransfer() || System.currentTimeMillis() - peerConnection.getStartTime() < 300000L || peerConnection.isTrustPeer() || nodeStatistics.isPredefined())) {
                    willDisconnectPeerList.add(peerConnection);
                }
                nodeStatistics.resetTcpFlow();
            }
            if (!willDisconnectPeerList.isEmpty() && (double)peerConnectionList.size() > (double)Args.getInstance().getNodeMaxActiveNodes() * PeerConnectionCheckService.this.maxConnectNumberFactor) {
                Collections.shuffle(willDisconnectPeerList);
                int i = 0;
                while ((double)i < (double)willDisconnectPeerList.size() * PeerConnectionCheckService.this.disconnectNumberFactor) {
                    logger.error("{} not have data transfer, disconnect the peer", (Object)((PeerConnection)willDisconnectPeerList.get(i)).getInetAddress());
                    ((PeerConnection)willDisconnectPeerList.get(i)).disconnect(Protocol.ReasonCode.TOO_MANY_PEERS);
                    ++i;
                }
            }
        }
    }
}

