/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.discover.node.statistics.MessageStatistics;
import org.tron.common.overlay.message.DisconnectMessage;
import org.tron.common.overlay.message.P2pMessage;
import org.tron.common.overlay.message.StaticMessages;
import org.tron.common.overlay.server.Channel;
import org.tron.common.overlay.server.MessageQueue;
import org.tron.protos.Protocol;

@Component
@Scope(value="prototype")
public class P2pHandler
extends SimpleChannelInboundHandler<P2pMessage> {
    private static final Logger logger = LoggerFactory.getLogger(P2pHandler.class);
    private static ScheduledExecutorService pingTimer = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "P2pPingTimer"));
    private MessageQueue msgQueue;
    private Channel channel;
    private ScheduledFuture<?> pingTask;
    private volatile boolean hasPing = false;
    private volatile long sendPingTime;
    private ChannelHandlerContext ctx;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.pingTask = pingTimer.scheduleAtFixedRate(() -> {
            if (!this.hasPing) {
                this.sendPingTime = System.currentTimeMillis();
                this.hasPing = this.msgQueue.sendMessage(StaticMessages.PING_MESSAGE);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public void channelRead0(ChannelHandlerContext ctx, P2pMessage msg) {
        this.msgQueue.receivedMessage(msg);
        MessageStatistics messageStatistics = this.channel.getNodeStatistics().messageStatistics;
        switch (msg.getType()) {
            case P2P_PING: {
                int count = messageStatistics.p2pInPing.getCount(10);
                if (count > 3) {
                    logger.warn("TCP attack found: {} with ping count({})", (Object)ctx.channel().remoteAddress(), (Object)count);
                    this.channel.disconnect(Protocol.ReasonCode.BAD_PROTOCOL);
                    return;
                }
                this.msgQueue.sendMessage(StaticMessages.PONG_MESSAGE);
                break;
            }
            case P2P_PONG: {
                if (messageStatistics.p2pInPong.getTotalCount() > messageStatistics.p2pOutPing.getTotalCount()) {
                    logger.warn("TCP attack found: {} with ping count({}), pong count({})", new Object[]{ctx.channel().remoteAddress(), messageStatistics.p2pOutPing.getTotalCount(), messageStatistics.p2pInPong.getTotalCount()});
                    this.channel.disconnect(Protocol.ReasonCode.BAD_PROTOCOL);
                    return;
                }
                this.hasPing = false;
                this.channel.getNodeStatistics().lastPongReplyTime.set(System.currentTimeMillis());
                this.channel.getPeerStats().pong(this.sendPingTime);
                break;
            }
            case P2P_DISCONNECT: {
                this.channel.getNodeStatistics().nodeDisconnectedRemote(((DisconnectMessage)msg).getReasonCode());
                this.channel.close();
                break;
            }
            default: {
                this.channel.close();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.channel.processException(cause);
    }

    public void setMsgQueue(MessageQueue msgQueue) {
        this.msgQueue = msgQueue;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void close() {
        if (this.pingTask != null && !this.pingTask.isCancelled()) {
            this.pingTask.cancel(false);
        }
    }
}

