/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.client.PeerClient;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.overlay.server.Channel;
import org.tron.common.overlay.server.PeerServer;
import org.tron.common.overlay.server.SyncPool;
import org.tron.core.config.args.Args;
import org.tron.core.db.ByteArrayWrapper;
import org.tron.protos.Protocol;

@Component
public class ChannelManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"ChannelManager");
    private final Map<ByteArrayWrapper, Channel> activePeers = new ConcurrentHashMap<ByteArrayWrapper, Channel>();
    private Cache<InetAddress, Protocol.ReasonCode> badPeers = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.HOURS).recordStats().build();
    private Cache<InetAddress, Protocol.ReasonCode> recentlyDisconnected = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(30L, TimeUnit.SECONDS).recordStats().build();
    private Map<InetAddress, Node> trustPeers = new ConcurrentHashMap<InetAddress, Node>();
    private Args args = Args.getInstance();
    private int maxActivePeers = this.args.getNodeMaxActiveNodes();
    private int getMaxActivePeersWithSameIp = this.args.getNodeMaxActiveNodesWithSameIp();
    private PeerServer peerServer;
    private PeerClient peerClient;
    @Autowired
    private SyncPool syncPool;

    @Autowired
    private ChannelManager(PeerServer peerServer, PeerClient peerClient) {
        this.peerServer = peerServer;
        this.peerClient = peerClient;
    }

    public void init() {
        if (this.args.getNodeListenPort() > 0) {
            new Thread(() -> this.peerServer.start(Args.getInstance().getNodeListenPort()), "PeerServerThread").start();
        }
        for (Node node : this.args.getPassiveNodes()) {
            this.trustPeers.put(new InetSocketAddress(node.getHost(), node.getPort()).getAddress(), node);
        }
        logger.info("Trust peer size {}", (Object)this.trustPeers.size());
    }

    public void processDisconnect(Channel channel, Protocol.ReasonCode reason) {
        InetAddress inetAddress = channel.getInetAddress();
        if (inetAddress == null) {
            return;
        }
        switch (reason) {
            case BAD_PROTOCOL: 
            case BAD_BLOCK: 
            case BAD_TX: {
                this.badPeers.put((Object)channel.getInetAddress(), (Object)reason);
                break;
            }
            default: {
                this.recentlyDisconnected.put((Object)channel.getInetAddress(), (Object)reason);
            }
        }
    }

    public void notifyDisconnect(Channel channel) {
        this.syncPool.onDisconnect(channel);
        this.activePeers.values().remove(channel);
        if (channel != null) {
            InetAddress inetAddress;
            if (channel.getNodeStatistics() != null) {
                channel.getNodeStatistics().notifyDisconnect();
            }
            if ((inetAddress = channel.getInetAddress()) != null && this.recentlyDisconnected.getIfPresent((Object)inetAddress) == null) {
                this.recentlyDisconnected.put((Object)channel.getInetAddress(), (Object)Protocol.ReasonCode.UNKNOWN);
            }
        }
    }

    public synchronized boolean processPeer(Channel peer) {
        Channel channel;
        if (!this.trustPeers.containsKey(peer.getInetAddress())) {
            if (this.recentlyDisconnected.getIfPresent((Object)peer) != null) {
                logger.info("Peer {} recently disconnected.", (Object)peer.getInetAddress());
                return false;
            }
            if (this.badPeers.getIfPresent((Object)peer) != null) {
                peer.disconnect(peer.getNodeStatistics().getDisconnectReason());
                return false;
            }
            if (!peer.isActive() && this.activePeers.size() >= this.maxActivePeers) {
                peer.disconnect(Protocol.ReasonCode.TOO_MANY_PEERS);
                return false;
            }
            if (this.getConnectionNum(peer.getInetAddress()) >= this.getMaxActivePeersWithSameIp) {
                peer.disconnect(Protocol.ReasonCode.TOO_MANY_PEERS_WITH_SAME_IP);
                return false;
            }
        }
        if ((channel = this.activePeers.get(peer.getNodeIdWrapper())) != null) {
            if (channel.getStartTime() > peer.getStartTime()) {
                logger.info("Disconnect connection established later, {}", (Object)channel.getNode());
                channel.disconnect(Protocol.ReasonCode.DUPLICATE_PEER);
            } else {
                peer.disconnect(Protocol.ReasonCode.DUPLICATE_PEER);
                return false;
            }
        }
        this.activePeers.put(peer.getNodeIdWrapper(), peer);
        logger.info("Add active peer {}, total active peers: {}", (Object)peer, (Object)this.activePeers.size());
        return true;
    }

    public int getConnectionNum(InetAddress inetAddress) {
        int cnt = 0;
        for (Channel channel : this.activePeers.values()) {
            if (!channel.getInetAddress().equals(inetAddress)) continue;
            ++cnt;
        }
        return cnt;
    }

    public Collection<Channel> getActivePeers() {
        return this.activePeers.values();
    }

    public Cache<InetAddress, Protocol.ReasonCode> getRecentlyDisconnected() {
        return this.recentlyDisconnected;
    }

    public Cache<InetAddress, Protocol.ReasonCode> getBadPeers() {
        return this.badPeers;
    }

    public void close() {
        this.peerServer.close();
        this.peerClient.close();
    }

    public Map<InetAddress, Node> getTrustPeers() {
        return this.trustPeers;
    }
}

