/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.net.message.MessageTypes;

public abstract class Message {
    protected static final Logger logger = LoggerFactory.getLogger((String)"Message");
    protected byte[] data;
    protected byte type;

    public Message() {
    }

    public Message(byte[] packed) {
        this.data = packed;
    }

    public Message(byte type, byte[] packed) {
        this.type = type;
        this.data = packed;
    }

    public ByteBuf getSendData() {
        return Unpooled.wrappedBuffer((byte[])ArrayUtils.add((byte[])this.getData(), (int)0, (byte)this.type));
    }

    public Sha256Hash getMessageId() {
        return Sha256Hash.of(this.getData());
    }

    public byte[] getData() {
        return this.data;
    }

    public MessageTypes getType() {
        return MessageTypes.fromByte(this.type);
    }

    public abstract Class<?> getAnswerMessage();

    public String toString() {
        return "type: " + (Object)((Object)this.getType()) + "\n";
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message message = (Message)o;
        return Arrays.equals(this.data, message.data);
    }
}

