/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.overlay.discover.table.DistanceComparator;
import org.tron.common.overlay.discover.table.NodeBucket;
import org.tron.common.overlay.discover.table.NodeEntry;

public class NodeTable {
    static final Logger logger = LoggerFactory.getLogger((String)"NodeTable");
    private final Node node;
    private transient NodeBucket[] buckets;
    private transient List<NodeEntry> nodes;
    private Map<Node, Node> evictedCandidates = new HashMap<Node, Node>();
    private Map<Node, Date> expectedPongs = new HashMap<Node, Date>();

    public NodeTable(Node n) {
        this.node = n;
        this.initialize();
    }

    public Node getNode() {
        return this.node;
    }

    public final void initialize() {
        this.nodes = new ArrayList<NodeEntry>();
        this.buckets = new NodeBucket[256];
        for (int i = 0; i < 256; ++i) {
            this.buckets[i] = new NodeBucket(i);
        }
    }

    public synchronized Node addNode(Node n) {
        NodeEntry e = new NodeEntry(this.node.getId(), n);
        if (this.nodes.contains(e)) {
            this.nodes.forEach(nodeEntry -> {
                if (nodeEntry.equals(e)) {
                    nodeEntry.touch();
                }
            });
            return null;
        }
        NodeEntry lastSeen = this.buckets[this.getBucketId(e)].addNode(e);
        if (lastSeen != null) {
            return lastSeen.getNode();
        }
        if (!this.nodes.contains(e)) {
            this.nodes.add(e);
        }
        return null;
    }

    public synchronized void dropNode(Node n) {
        NodeEntry e = new NodeEntry(this.node.getId(), n);
        this.buckets[this.getBucketId(e)].dropNode(e);
        this.nodes.remove(e);
    }

    public synchronized boolean contains(Node n) {
        NodeEntry e = new NodeEntry(this.node.getId(), n);
        for (NodeBucket b : this.buckets) {
            if (!b.getNodes().contains(e)) continue;
            return true;
        }
        return false;
    }

    public synchronized void touchNode(Node n) {
        NodeEntry e = new NodeEntry(this.node.getId(), n);
        for (NodeBucket b : this.buckets) {
            if (!b.getNodes().contains(e)) continue;
            b.getNodes().get(b.getNodes().indexOf(e)).touch();
            break;
        }
    }

    public int getBucketsCount() {
        int i = 0;
        for (NodeBucket b : this.buckets) {
            if (b.getNodesCount() <= 0) continue;
            ++i;
        }
        return i;
    }

    public synchronized NodeBucket[] getBuckets() {
        return this.buckets;
    }

    public int getBucketId(NodeEntry e) {
        int id = e.getDistance() - 1;
        return id < 0 ? 0 : id;
    }

    public synchronized int getNodesCount() {
        return this.nodes.size();
    }

    public synchronized List<NodeEntry> getAllNodes() {
        ArrayList<NodeEntry> nodes = new ArrayList<NodeEntry>();
        for (NodeBucket b : this.buckets) {
            for (NodeEntry e : b.getNodes()) {
                if (e.getNode().equals(this.node)) continue;
                nodes.add(e);
            }
        }
        return nodes;
    }

    public synchronized List<Node> getClosestNodes(byte[] targetId) {
        List<NodeEntry> closestEntries = this.getAllNodes();
        ArrayList<Node> closestNodes = new ArrayList<Node>();
        Collections.sort(closestEntries, new DistanceComparator(targetId));
        if (closestEntries.size() > 16) {
            closestEntries = closestEntries.subList(0, 16);
        }
        for (NodeEntry e : closestEntries) {
            if (e.getNode().isDiscoveryNode()) continue;
            closestNodes.add(e.getNode());
        }
        return closestNodes;
    }
}

