/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.node;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.net.udp.handler.UdpEvent;
import org.tron.common.net.udp.message.Message;
import org.tron.common.net.udp.message.discover.FindNodeMessage;
import org.tron.common.net.udp.message.discover.NeighborsMessage;
import org.tron.common.net.udp.message.discover.PingMessage;
import org.tron.common.net.udp.message.discover.PongMessage;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.overlay.discover.node.NodeManager;
import org.tron.common.overlay.discover.node.statistics.NodeStatistics;
import org.tron.core.config.args.Args;

public class NodeHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"NodeHandler");
    private static long PingTimeout = 15000L;
    private Node sourceNode;
    private Node node;
    private State state;
    private NodeManager nodeManager;
    private NodeStatistics nodeStatistics;
    private NodeHandler replaceCandidate;
    private InetSocketAddress inetSocketAddress;
    private volatile boolean waitForPong = false;
    private volatile boolean waitForNeighbors = false;
    private volatile int pingTrials = 3;
    private long pingSent;

    public NodeHandler(Node node, NodeManager nodeManager) {
        this.node = node;
        this.nodeManager = nodeManager;
        this.inetSocketAddress = new InetSocketAddress(node.getHost(), node.getPort());
        this.nodeStatistics = new NodeStatistics(node);
        this.changeState(State.Discovered);
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetSocketAddress;
    }

    public void setSourceNode(Node sourceNode) {
        this.sourceNode = sourceNode;
    }

    public Node getSourceNode() {
        return this.sourceNode;
    }

    public Node getNode() {
        return this.node;
    }

    public State getState() {
        return this.state;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public NodeStatistics getNodeStatistics() {
        return this.nodeStatistics;
    }

    private void challengeWith(NodeHandler replaceCandidate) {
        this.replaceCandidate = replaceCandidate;
        this.changeState(State.EvictCandidate);
    }

    public void changeState(State newState) {
        State oldState = this.state;
        if (newState == State.Discovered) {
            if (this.sourceNode != null && this.sourceNode.getPort() != this.node.getPort()) {
                this.changeState(State.Dead);
            } else {
                this.sendPing();
            }
        }
        if (!this.node.isDiscoveryNode()) {
            if (newState == State.Alive) {
                Node evictCandidate = this.nodeManager.getTable().addNode(this.node);
                if (evictCandidate == null) {
                    newState = State.Active;
                } else {
                    NodeHandler evictHandler = this.nodeManager.getNodeHandler(evictCandidate);
                    if (evictHandler.state != State.EvictCandidate) {
                        evictHandler.challengeWith(this);
                    }
                }
            }
            if (newState == State.Active) {
                if (oldState == State.Alive) {
                    this.nodeManager.getTable().addNode(this.node);
                } else if (oldState == State.EvictCandidate) {
                    // empty if block
                }
            }
            if (newState == State.NonActive) {
                if (oldState == State.EvictCandidate) {
                    this.nodeManager.getTable().dropNode(this.node);
                    this.replaceCandidate.changeState(State.Active);
                } else if (oldState == State.Alive) {
                    // empty if block
                }
            }
        }
        if (newState == State.EvictCandidate) {
            this.sendPing();
        }
        this.state = newState;
    }

    public void handlePing(PingMessage msg) {
        if (!this.nodeManager.getTable().getNode().equals(this.node)) {
            this.sendPong();
        }
        if (msg.getVersion() != Args.getInstance().getNodeP2pVersion()) {
            this.changeState(State.NonActive);
        } else if (this.state.equals((Object)State.NonActive) || this.state.equals((Object)State.Dead)) {
            this.changeState(State.Discovered);
        }
    }

    public void handlePong(PongMessage msg) {
        if (this.waitForPong) {
            this.waitForPong = false;
            this.getNodeStatistics().discoverMessageLatency.add((double)System.currentTimeMillis() - (double)this.pingSent);
            this.getNodeStatistics().lastPongReplyTime.set(System.currentTimeMillis());
            this.node.setId(msg.getFrom().getId());
            if (msg.getVersion() != Args.getInstance().getNodeP2pVersion()) {
                this.changeState(State.NonActive);
            } else {
                this.changeState(State.Alive);
            }
        }
    }

    public void handleNeighbours(NeighborsMessage msg) {
        if (!this.waitForNeighbors) {
            logger.warn("Receive neighbors from {} without send find nodes.", (Object)this.node.getHost());
            return;
        }
        this.waitForNeighbors = false;
        for (Node n : msg.getNodes()) {
            if (this.nodeManager.getPublicHomeNode().getHexId().equals(n.getHexId())) continue;
            this.nodeManager.getNodeHandler(n);
        }
    }

    public void handleFindNode(FindNodeMessage msg) {
        List<Node> closest = this.nodeManager.getTable().getClosestNodes(msg.getTargetId());
        this.sendNeighbours(closest);
    }

    public void handleTimedOut() {
        this.waitForPong = false;
        if (--this.pingTrials > 0) {
            this.sendPing();
        } else if (this.state == State.Discovered) {
            this.changeState(State.Dead);
        } else if (this.state == State.EvictCandidate) {
            this.changeState(State.NonActive);
        }
    }

    public void sendPing() {
        PingMessage ping = new PingMessage(this.nodeManager.getPublicHomeNode(), this.getNode());
        this.waitForPong = true;
        this.pingSent = System.currentTimeMillis();
        this.sendMessage(ping);
        if (this.nodeManager.getPongTimer().isShutdown()) {
            return;
        }
        this.nodeManager.getPongTimer().schedule(() -> {
            try {
                if (this.waitForPong) {
                    this.waitForPong = false;
                    this.handleTimedOut();
                }
            }
            catch (Throwable t) {
                logger.error("Unhandled exception", t);
            }
        }, PingTimeout, TimeUnit.MILLISECONDS);
    }

    public void sendPong() {
        PongMessage pong = new PongMessage(this.nodeManager.getPublicHomeNode());
        this.sendMessage(pong);
    }

    public void sendNeighbours(List<Node> neighbours) {
        NeighborsMessage neighbors = new NeighborsMessage(this.nodeManager.getPublicHomeNode(), neighbours);
        this.sendMessage(neighbors);
    }

    public void sendFindNode(byte[] target) {
        this.waitForNeighbors = true;
        FindNodeMessage findNode = new FindNodeMessage(this.nodeManager.getPublicHomeNode(), target);
        this.sendMessage(findNode);
    }

    private void sendMessage(Message msg) {
        this.nodeManager.sendOutbound(new UdpEvent(msg, this.getInetSocketAddress()));
        this.nodeStatistics.messageStatistics.addUdpOutMessage(msg.getType());
    }

    public String toString() {
        return "NodeHandler[state: " + (Object)((Object)this.state) + ", node: " + this.node.getHost() + ":" + this.node.getPort() + "]";
    }

    public static enum State {
        Discovered,
        Dead,
        Alive,
        Active,
        EvictCandidate,
        NonActive;

    }
}

